/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xinclude;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.extensions.xinclude.XIncludeErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XIncludeValidationExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void xIncludeValidationTrueIssue175() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE chapter PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\" \"https://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd\">    <chapter id=\"chapter_id\">\r\n    <xi:include xmlns:xi=\"http://www.w3.org/2001/XInclude\" href=\"reference.xml\"/>\r\n</schema>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(1, 63, 1, 118, (IXMLErrorCode)ExternalResourceErrorCode.DownloadingResource), XMLAssert.d(1, 125, 1, 132, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(2, 5, 2, 15, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED), XMLAssert.d(2, 64, 2, 79, (IXMLErrorCode)XIncludeErrorCode.XMLResourceError), XMLAssert.d(2, 64, 2, 79, (IXMLErrorCode)XIncludeErrorCode.NoFallback));
    }

    @Test
    public void xIncludeValidationTrueNoDTD() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n    <title>The Wit and Wisdom of George W. Bush</title>\r\n    <title>Sample title</title>\r\n    <xi:include href=\"http://www.whitehouse.gov/malapropisms.xml\"/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(4, 21, 4, 65, (IXMLErrorCode)XIncludeErrorCode.XMLResourceError), XMLAssert.d(4, 21, 4, 65, (IXMLErrorCode)XIncludeErrorCode.NoFallback));
    }

    @Test
    public void xIncludeValidationFalseNoDTD() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(false);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n    <title>The Wit and Wisdom of George W. Bush</title>\r\n    <title>Sample title</title>\r\n    <xi:include href=\"http://www.whitehouse.gov/malapropisms.xml\"/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, new Diagnostic[0]);
    }

    @Test
    public void xIncludeValidationTrueNoHrefAttr() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n    <xi:include/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(2, 5, 2, 15, (IXMLErrorCode)XIncludeErrorCode.XpointerMissing));
    }

    @Test
    public void xIncludeValidationTrueMultiFallback() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n  <xi:include href=\"src/test/resources/xml/reference.xml\">\r\n    <xi:fallback><a href=\"mailto:bob@example.org\">Report error</a></xi:fallback>\r\n    <xi:fallback><a href=\"mailto:bob@example.org\">Report error</a></xi:fallback>\r\n  </xi:include></book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(4, 5, 4, 16, (IXMLErrorCode)XIncludeErrorCode.MultipleFallbacks));
    }

    @Test
    public void xIncludeValidationTrueFallbackNoParent() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n  <xi:fallback><a href=\"mailto:bob@example.org\">Report error</a></xi:fallback>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(2, 3, 2, 14, (IXMLErrorCode)XIncludeErrorCode.FallbackParent));
    }

    @Test
    public void xIncludeValidationTrueInvalidIncludeChild() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n  <xi:include href=\"src/test/resources/xml/reference.xml\">\r\n    <xi:include></include>\r\n  </xi:include></book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(3, 5, 3, 15, (IXMLErrorCode)XIncludeErrorCode.IncludeChild));
    }

    @Test
    public void xIncludeValidationTrueInvalidParseValue() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n  <xi:include href=\"src/test/resources/xml/reference.xml\" parse=\"invalid\"/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(2, 64, 2, 73, (IXMLErrorCode)XIncludeErrorCode.InvalidParseValue));
    }

    @Test
    public void xIncludeValidationTrueAcceptMalformed() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n  <xi:include href=\"src/test/resources/xml/reference.xml\" accept=\"\ufffd\"/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(2, 65, 2, 68, (IXMLErrorCode)XIncludeErrorCode.AcceptMalformed));
    }

    @Test
    public void xIncludeValidationTrueAcceptLanguageMalformed() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n  <xi:include href=\"src/test/resources/xml/reference.xml\" accept-language=\"\ufffd\"/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(2, 74, 2, 77, (IXMLErrorCode)XIncludeErrorCode.AcceptLanguageMalformed));
    }

    @Test
    public void xIncludeValidationTrueNoRootElement() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "   \r\n";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(0, 1, 0, 1, (IXMLErrorCode)XIncludeErrorCode.RootElementRequired));
    }

    @Test
    public void xIncludeValidationTrueHrefFragmentIdentifier() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n    <xi:include href=\"http://www.whitehouse.gov/#invalid/malapropisms.xml\"/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(2, 21, 2, 74, (IXMLErrorCode)XIncludeErrorCode.HrefFragmentIdentifierIllegal));
    }

    @Test
    public void xIncludeValidationTrueHrefInvalidSyntax() throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        validation.setNoGrammar("ignore");
        settings.setValidation(validation);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n    <xi:include href=\"\ufffd\"/>\r\n</book>";
        XIncludeValidationExtensionsTest.testDiagnosticsFor(xml, settings, XMLAssert.d(2, 21, 2, 24, (IXMLErrorCode)XIncludeErrorCode.HrefSyntacticallyInvalid));
    }

    public static void testDiagnosticsFor(String xml, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, null, true, settings, expected);
    }
}

