/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.parsers;

import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class SAXToDOMHandler
extends DefaultHandler
implements LexicalHandler {
    private final DocumentBuilder documentBuilder;
    private Document document;
    private final Stack<Node> elementStack;
    private StringBuilder textBuffer;

    public SAXToDOMHandler(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
        this.elementStack = new Stack();
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void startDocument() throws SAXException {
        this.document = this.documentBuilder.newDocument();
        this.elementStack.clear();
        this.elementStack.push(this.document);
        this.textBuffer = new StringBuilder();
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushText();
        this.elementStack.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.flushText();
        Element element = this.document.createElement(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            element.setAttribute(attributes.getQName(i), attributes.getValue(i));
        }
        Node parent = this.elementStack.peek();
        parent.appendChild(element);
        this.elementStack.push(element);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushText();
        this.elementStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.textBuffer.append(ch, start, length);
    }

    private void flushText() {
        if (this.textBuffer.length() > 0) {
            String text = this.textBuffer.toString();
            this.textBuffer.setLength(0);
            if (this.elementStack.isEmpty()) {
                return;
            }
            Node parent = this.elementStack.peek();
            if (parent.getNodeType() == 1 && !text.isEmpty()) {
                Text textNode = this.document.createTextNode(text);
                parent.appendChild(textNode);
            }
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushText();
        String commentText = new String(ch, start, length);
        Comment commentNode = this.document.createComment(commentText);
        Node parent = this.elementStack.peek();
        parent.appendChild(commentNode);
    }
}

