/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.model;

import com.google.gson.annotations.SerializedName;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.lsat.external.api.model.ActionBase;
import org.eclipse.lsat.external.api.model.Peripheral;
import org.eclipse.lsat.external.api.model.Resource;
import org.eclipse.lsat.external.api.model.SchedulingType;

public class Move
extends ActionBase {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_SCHEDULING_TYPE = "schedulingType";
    @SerializedName(value="schedulingType")
    @Nullable
    private SchedulingType schedulingType;
    public static final String SERIALIZED_NAME_PROFILE = "profile";
    @SerializedName(value="profile")
    @Nullable
    private String profile;
    public static final String SERIALIZED_NAME_SOURCE_POSITION = "sourcePosition";
    @SerializedName(value="sourcePosition")
    @Nullable
    private Map<String, String> sourcePosition = new LinkedHashMap<String, String>();
    public static final String SERIALIZED_NAME_TARGET_POSITION = "targetPosition";
    @SerializedName(value="targetPosition")
    @Nullable
    private Map<String, String> targetPosition = new LinkedHashMap<String, String>();
    public static final String SERIALIZED_NAME_PREDECESSOR_MOVE_ID = "predecessorMoveId";
    @SerializedName(value="predecessorMoveId")
    @Nullable
    private String predecessorMoveId;
    private transient ActionBase predecessorMove;
    public static final String SERIALIZED_NAME_SUCCESSOR_MOVE_ID = "successorMoveId";
    @SerializedName(value="successorMoveId")
    @Nullable
    private String successorMoveId;
    private transient ActionBase successorMove;
    public static final String SERIALIZED_NAME_DISTANCE = "distance";
    @SerializedName(value="distance")
    @Nullable
    private String distance;
    public static final String SERIALIZED_NAME_STOP_AT_TARGET = "stopAtTarget";
    @SerializedName(value="stopAtTarget")
    @Nullable
    private Boolean stopAtTarget;
    public static final String SERIALIZED_NAME_POSITION_MOVE = "positionMove";
    @SerializedName(value="positionMove")
    @Nullable
    private Boolean positionMove;
    public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
    @SerializedName(value="resourceId")
    @Nullable
    private String resourceId;
    private transient Resource resource;
    public static final String SERIALIZED_NAME_PERIPHERAL_ID = "peripheralId";
    @SerializedName(value="peripheralId")
    @Nullable
    private String peripheralId;
    private transient Peripheral peripheral;

    public Move name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public Move schedulingType(@Nullable SchedulingType schedulingType) {
        this.schedulingType = schedulingType;
        return this;
    }

    @Nullable
    public SchedulingType getSchedulingType() {
        return this.schedulingType;
    }

    public void setSchedulingType(@Nullable SchedulingType schedulingType) {
        this.schedulingType = schedulingType;
    }

    public Move profile(@Nullable String profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    public String getProfile() {
        return this.profile;
    }

    public void setProfile(@Nullable String profile) {
        this.profile = profile;
    }

    public Move sourcePosition(@Nullable Map<String, String> sourcePosition) {
        this.sourcePosition = sourcePosition;
        return this;
    }

    public Move putSourcePositionItem(String key, String sourcePositionItem) {
        if (this.sourcePosition == null) {
            this.sourcePosition = new LinkedHashMap<String, String>();
        }
        this.sourcePosition.put(key, sourcePositionItem);
        return this;
    }

    @Nullable
    public Map<String, String> getSourcePosition() {
        return this.sourcePosition;
    }

    public void setSourcePosition(@Nullable Map<String, String> sourcePosition) {
        this.sourcePosition = sourcePosition;
    }

    public Move targetPosition(@Nullable Map<String, String> targetPosition) {
        this.targetPosition = targetPosition;
        return this;
    }

    public Move putTargetPositionItem(String key, String targetPositionItem) {
        if (this.targetPosition == null) {
            this.targetPosition = new LinkedHashMap<String, String>();
        }
        this.targetPosition.put(key, targetPositionItem);
        return this;
    }

    @Nullable
    public Map<String, String> getTargetPosition() {
        return this.targetPosition;
    }

    public void setTargetPosition(@Nullable Map<String, String> targetPosition) {
        this.targetPosition = targetPosition;
    }

    public Move predecessorMoveId(@Nullable String predecessorMoveId) {
        this.predecessorMoveId = predecessorMoveId;
        return this;
    }

    @Nullable
    public String getPredecessorMoveId() {
        return this.predecessorMoveId;
    }

    public void setPredecessorMoveId(@Nullable String predecessorMoveId) {
        this.predecessorMoveId = predecessorMoveId;
    }

    public Move successorMoveId(@Nullable String successorMoveId) {
        this.successorMoveId = successorMoveId;
        return this;
    }

    @Nullable
    public String getSuccessorMoveId() {
        return this.successorMoveId;
    }

    public void setSuccessorMoveId(@Nullable String successorMoveId) {
        this.successorMoveId = successorMoveId;
    }

    public Move distance(@Nullable String distance) {
        this.distance = distance;
        return this;
    }

    @Nullable
    public String getDistance() {
        return this.distance;
    }

    public void setDistance(@Nullable String distance) {
        this.distance = distance;
    }

    public Move stopAtTarget(@Nullable Boolean stopAtTarget) {
        this.stopAtTarget = stopAtTarget;
        return this;
    }

    @Nullable
    public Boolean getStopAtTarget() {
        return this.stopAtTarget;
    }

    public void setStopAtTarget(@Nullable Boolean stopAtTarget) {
        this.stopAtTarget = stopAtTarget;
    }

    public Move positionMove(@Nullable Boolean positionMove) {
        this.positionMove = positionMove;
        return this;
    }

    @Nullable
    public Boolean getPositionMove() {
        return this.positionMove;
    }

    public void setPositionMove(@Nullable Boolean positionMove) {
        this.positionMove = positionMove;
    }

    public Move resourceId(@Nullable String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nullable
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(@Nullable String resourceId) {
        this.resourceId = resourceId;
    }

    public Move peripheralId(@Nullable String peripheralId) {
        this.peripheralId = peripheralId;
        return this;
    }

    @Nullable
    public String getPeripheralId() {
        return this.peripheralId;
    }

    public void setPeripheralId(@Nullable String peripheralId) {
        this.peripheralId = peripheralId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Move move = (Move)o;
        return Objects.equals(this.name, move.name) && Objects.equals((Object)this.schedulingType, (Object)move.schedulingType) && Objects.equals(this.profile, move.profile) && Objects.equals(this.sourcePosition, move.sourcePosition) && Objects.equals(this.targetPosition, move.targetPosition) && Objects.equals(this.predecessorMoveId, move.predecessorMoveId) && Objects.equals(this.successorMoveId, move.successorMoveId) && Objects.equals(this.distance, move.distance) && Objects.equals(this.stopAtTarget, move.stopAtTarget) && Objects.equals(this.positionMove, move.positionMove) && Objects.equals(this.resourceId, move.resourceId) && Objects.equals(this.peripheralId, move.peripheralId) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.schedulingType, this.profile, this.sourcePosition, this.targetPosition, this.predecessorMoveId, this.successorMoveId, this.distance, this.stopAtTarget, this.positionMove, this.resourceId, this.peripheralId, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Move {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    schedulingType: ").append(this.toIndentedString((Object)this.schedulingType)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    sourcePosition: ").append(this.toIndentedString(this.sourcePosition)).append("\n");
        sb.append("    targetPosition: ").append(this.toIndentedString(this.targetPosition)).append("\n");
        sb.append("    predecessorMoveId: ").append(this.toIndentedString(this.predecessorMoveId)).append("\n");
        sb.append("    successorMoveId: ").append(this.toIndentedString(this.successorMoveId)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    stopAtTarget: ").append(this.toIndentedString(this.stopAtTarget)).append("\n");
        sb.append("    positionMove: ").append(this.toIndentedString(this.positionMove)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    peripheralId: ").append(this.toIndentedString(this.peripheralId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public ActionBase getPredecessorMove() {
        return this.predecessorMove;
    }

    public ActionBase getSuccessorMove() {
        return this.successorMove;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Peripheral getPeripheral() {
        return this.peripheral;
    }
}

