/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.machine.teditor.validation;

import com.google.common.collect.Iterables;
import common.CommonPackage;
import common.Import;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import machine.Axis;
import machine.BidirectionalPath;
import machine.FullMeshPath;
import machine.Machine;
import machine.MachinePackage;
import machine.Peripheral;
import machine.PeripheralType;
import machine.Profile;
import machine.Resource;
import machine.ResourceItem;
import machine.SymbolicPosition;
import machine.UnidirectionalPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.machine.teditor.validation.AbstractMachineValidator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import product.ProductDefinition;

public class MachineValidator
extends AbstractMachineValidator {
    public static final String SETPOINTS_NO_UNIT = "noUnitForSetPoint";
    public static final String UNKNOWN_CONVERSION_AXIS_TO_SETPOINT = "unknownConversionAxisToSetPoint";
    public static final String SAME_SOURCE_AND_TARGET_UNID_PATH_FOR_POSITION = "sameSourceAndTargetForPositionUNI";
    public static final String SAME_SOURCE_AND_TARGET_BID_PATH_FOR_POSITION = "sameSourceAndTargetForPositionBI";
    public static final String SAME_SOURCE_AND_TARGET_FUM_PATH_FOR_POSITION = "sameSourceAndTargetForPositionFU";
    public static final String PROFILE_NOT_USED = "profileNotUsed";
    public static final String CONFLICTING_POSITIONS = "conflictingPositions";
    public static final String INVALID_IMPORT = "invalidImport";
    public static final String INVALID_MUTUAL_EXCLUSIONS = "invalidMutualExclusions";
    public static final String PERIPHERAL_TYPE_NOT_SET = "peripheralTypeNotSet";
    public static final String PERIPHERAL_NOT_PART_OF_RESOURCE = "peripheralNotPartOfResource";

    @Check
    public void checkImportIsValid(Import imp) {
        try {
            boolean isUnderstood;
            boolean isImportUriValid = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
            if (!isImportUriValid) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The import ");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append(" cannot be resolved. Make sure that the name is spelled correctly.");
                this.error(_builder.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            if (!(isUnderstood = imp.getImportURI().matches(".*\\.(machine)"))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Importing ");
                String _importURI_1 = imp.getImportURI();
                _builder_1.append(_importURI_1);
                _builder_1.append(" is not allowed. Only 'machine' files are allowed");
                this.error(_builder_1.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("The import ");
                String _importURI_2 = imp.getImportURI();
                _builder_2.append(_importURI_2);
                _builder_2.append(" is not a valid URI.");
                this.error(_builder_2.toString(), (EObject)imp, (EStructuralFeature)CommonPackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Check
    public void checkPeripheralTypeRequired(Peripheral peripheral) {
        boolean _tripleEquals;
        PeripheralType _type = peripheral.getType();
        boolean bl = _tripleEquals = _type == null;
        if (_tripleEquals) {
            this.error("Peripheral type must be set", (EStructuralFeature)MachinePackage.Literals.PERIPHERAL__TYPE, PERIPHERAL_TYPE_NOT_SET, new String[0]);
        }
    }

    @Check
    public void checkPeripheralPartOfResource(Peripheral peripheral) {
        boolean _tripleEquals;
        Resource _resource = peripheral.getResource();
        boolean bl = _tripleEquals = _resource == null;
        if (_tripleEquals) {
            this.error("Peripheral must be part of a resource", (EStructuralFeature)MachinePackage.Literals.PERIPHERAL__RESOURCE, PERIPHERAL_NOT_PART_OF_RESOURCE, new String[0]);
        }
    }

    @Check
    public void checkUnknownConversionAxisToSetPoint(Axis axis) {
        if (!axis.getSetPoints().isEmpty() && IterableUtil.asSet((Iterable)Queries.xcollectOne((Iterable)axis.getSetPoints(), it -> it.getUnit())).size() > 1) {
            this.error("Setpoints of axes should have same unit", (EStructuralFeature)MachinePackage.Literals.AXIS__SET_POINTS, SETPOINTS_NO_UNIT, new String[0]);
        }
    }

    @Check
    public void checkEqualSetPointUnits(PeripheralType peripheralType) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)peripheralType.getConversion());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            return;
        }
        Functions.Function1 _function = axis -> {
            Functions.Function1 _function_1 = setPoint -> {
                String _unit = axis.getUnit();
                String _unit_1 = setPoint.getUnit();
                return Objects.equals(_unit, _unit_1);
            };
            return IterableExtensions.forall((Iterable)axis.getSetPoints(), (Functions.Function1)_function_1);
        };
        boolean conditionIsMet = IterableExtensions.forall((Iterable)peripheralType.getAxes(), (Functions.Function1)_function);
        if (!conditionIsMet) {
            this.error("Don't know how to convert axes to setpoints, please specifiy a conversion.", (EStructuralFeature)MachinePackage.Literals.PERIPHERAL_TYPE__SET_POINTS, UNKNOWN_CONVERSION_AXIS_TO_SETPOINT, new String[0]);
        }
    }

    @Check
    public void checkEqualSourceTargetUnidirectional(UnidirectionalPath undPath) {
        if (undPath.getSource() != null && undPath.getTarget() != null && Objects.equals(undPath.getSource().getName(), undPath.getTarget().getName())) {
            this.warning("Source and target should not refer to same position", (EStructuralFeature)MachinePackage.Literals.UNIDIRECTIONAL_PATH__SOURCE, SAME_SOURCE_AND_TARGET_UNID_PATH_FOR_POSITION, new String[0]);
        }
    }

    @Check
    public void checkEqualEndPointsBidirectional(BidirectionalPath biPath) {
        if (!biPath.getEndPoints().isEmpty() && Queries.containsDuplicates((Iterable)Queries.xcollectOne((Iterable)biPath.getEndPoints(), it -> it.getPosition()))) {
            this.warning("Source and target should not refer to same position", (EStructuralFeature)MachinePackage.Literals.BIDIRECTIONAL_PATH__END_POINTS, SAME_SOURCE_AND_TARGET_BID_PATH_FOR_POSITION, new String[0]);
        }
    }

    @Check
    public void checkEqualEndPointsFullMesh(FullMeshPath fullPath) {
        if (!fullPath.getEndPoints().isEmpty() && Queries.containsDuplicates((Iterable)Queries.xcollectOne((Iterable)fullPath.getEndPoints(), it -> it.getPosition()))) {
            this.error("Positions in full mesh should be unique", (EStructuralFeature)MachinePackage.Literals.FULL_MESH_PATH__END_POINTS, SAME_SOURCE_AND_TARGET_FUM_PATH_FOR_POSITION, new String[0]);
        }
    }

    @Check
    public void checkProductDefinitionsUnique(Machine machine) {
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<ProductDefinition> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Product names must be unique. Please remove all duplicate instances.");
            this.error(_builder.toString(), (EObject)machine, (EStructuralFeature)MachinePackage.Literals.MACHINE__PRODUCT_DEFINITIONS, machine.getProductDefinitions().indexOf(it));
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)machine.getProductDefinitions(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkPeripheralTypesUnique(Machine machine) {
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<PeripheralType> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Peripheral type names must be unique. Please remove all duplicate instances.");
            this.error(_builder.toString(), (EObject)machine, (EStructuralFeature)MachinePackage.Literals.MACHINE__PERIPHERAL_TYPES, machine.getPeripheralTypes().indexOf(it));
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)machine.getPeripheralTypes(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkResourcesUnique(Machine machine) {
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Resource> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Resource names must be unique. Please remove all duplicate instances.");
            this.error(_builder.toString(), (EObject)machine, (EStructuralFeature)MachinePackage.Literals.MACHINE__RESOURCES, machine.getResources().indexOf(it));
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)machine.getResources(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkResourceItemsUnique(Resource resource) {
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<ResourceItem> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Items names must be unique. Please remove all duplicate instances.");
            this.error(_builder.toString(), (EObject)resource, (EStructuralFeature)MachinePackage.Literals.RESOURCE__ITEMS, resource.getItems().indexOf(it));
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)resource.getItems(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkPositionHasAxes(Peripheral peripheral) {
        boolean _isEmpty = peripheral.getType().getAxes().isEmpty();
        if (_isEmpty) {
            boolean _isEmpty_4;
            boolean _not_3;
            boolean _isEmpty_3;
            boolean _not_2;
            boolean _isEmpty_2;
            boolean _not_1;
            boolean _not;
            LinkedHashMap items = CollectionLiterals.newLinkedHashMap();
            boolean _isEmpty_1 = peripheral.getAxisPositions().isEmpty();
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                items.put("AxisPositions", MachinePackage.Literals.PERIPHERAL__AXIS_POSITIONS);
            }
            boolean bl2 = _not_1 = !(_isEmpty_2 = peripheral.getPaths().isEmpty());
            if (_not_1) {
                items.put("Paths", MachinePackage.Literals.PERIPHERAL__PATHS);
            }
            boolean bl3 = _not_2 = !(_isEmpty_3 = peripheral.getPositions().isEmpty());
            if (_not_2) {
                items.put("SymbolicPositions", MachinePackage.Literals.PERIPHERAL__POSITIONS);
            }
            boolean bl4 = _not_3 = !(_isEmpty_4 = items.isEmpty());
            if (_not_3) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Positions can only be used for peripheral types with axes. Remove positions or add axes to PeripheralType ");
                String _name = peripheral.getType().getName();
                _builder.append(_name);
                String msg = _builder.toString();
                Set _entrySet = items.entrySet();
                for (Map.Entry e : _entrySet) {
                    this.error(msg, (EObject)peripheral, (EStructuralFeature)e.getValue(), -1, INVALID_MUTUAL_EXCLUSIONS, new String[0]);
                }
            }
        }
    }

    @Check
    public void checkMutualExclusiveness(Peripheral peripheral) {
        boolean distanceDefined;
        boolean _isEmpty = peripheral.getDistances().isEmpty();
        boolean bl = distanceDefined = !_isEmpty;
        if (distanceDefined) {
            boolean _isEmpty_4;
            boolean _not_3;
            boolean _isEmpty_3;
            boolean _not_2;
            boolean _isEmpty_2;
            boolean _not_1;
            boolean _not;
            LinkedHashMap items = CollectionLiterals.newLinkedHashMap();
            boolean _isEmpty_1 = peripheral.getAxisPositions().isEmpty();
            boolean bl2 = _not = !_isEmpty_1;
            if (_not) {
                items.put("AxisPositions", MachinePackage.Literals.PERIPHERAL__AXIS_POSITIONS);
            }
            boolean bl3 = _not_1 = !(_isEmpty_2 = peripheral.getPaths().isEmpty());
            if (_not_1) {
                items.put("Paths", MachinePackage.Literals.PERIPHERAL__PATHS);
            }
            boolean bl4 = _not_2 = !(_isEmpty_3 = peripheral.getPositions().isEmpty());
            if (_not_2) {
                items.put("SymbolicPositions", MachinePackage.Literals.PERIPHERAL__POSITIONS);
            }
            boolean bl5 = _not_3 = !(_isEmpty_4 = items.isEmpty());
            if (_not_3) {
                String _xifexpression = null;
                int _size = items.size();
                boolean _greaterThan = _size > 1;
                _xifexpression = _greaterThan ? "Remove Distances or all others" : "Remove one";
                String request = _xifexpression;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Distances cannot be mixed with ");
                String _join = IterableExtensions.join(items.keySet(), (CharSequence)" and ");
                _builder.append(_join);
                _builder.append(". ");
                _builder.append(request);
                String msg = _builder.toString();
                Set _entrySet = items.entrySet();
                for (Map.Entry e : _entrySet) {
                    this.error(msg, (EObject)peripheral, (EStructuralFeature)e.getValue(), 0, INVALID_MUTUAL_EXCLUSIONS, new String[0]);
                }
                this.error(msg, (EObject)peripheral, (EStructuralFeature)MachinePackage.Literals.PERIPHERAL__DISTANCES, 0, INVALID_MUTUAL_EXCLUSIONS, new String[0]);
            }
        }
    }

    @Check
    public void checkNotUsedProfile(Peripheral peripheral) {
        boolean _not;
        boolean _isEmpty = peripheral.getDistances().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return;
        }
        Functions.Function1 _function = it -> it.getProfiles();
        Iterable usedProfiles = Queries.xcollect((Iterable)peripheral.getPaths(), (Functions.Function1)_function);
        EList _profiles = peripheral.getProfiles();
        for (Profile profile : _profiles) {
            boolean _not_1;
            boolean _contains = IterableUtil.contains((Iterable)usedProfiles, (Object)profile);
            boolean bl2 = _not_1 = !_contains;
            if (!_not_1) continue;
            String _name = profile.getName();
            String _plus = "Profile " + _name;
            String _plus_1 = _plus + " is not used.";
            this.warning(_plus_1, (EStructuralFeature)MachinePackage.Literals.PERIPHERAL__PROFILES, peripheral.getProfiles().indexOf((Object)profile), PROFILE_NOT_USED, new String[0]);
        }
    }

    @Check
    public void checkConflictingPositions(SymbolicPosition symbolicPosition) {
        if (symbolicPosition != null) {
            Set axesWithoutPosition = IterableExtensions.toSet((Iterable)symbolicPosition.getPeripheral().getType().getAxes());
            axesWithoutPosition.removeAll(symbolicPosition.getAxisPosition().keySet());
            Functions.Function1 _function = axis -> {
                Functions.Function1 _function_1 = axisPos -> {
                    String _name_1;
                    String _name = axisPos.getName();
                    return !Objects.equals(_name, _name_1 = symbolicPosition.getName());
                };
                return IterableExtensions.forall((Iterable)((Iterable)symbolicPosition.getPeripheral().getAxisPositions().get(axis)), (Functions.Function1)_function_1);
            };
            boolean conditionIsMet = IterableExtensions.forall((Iterable)axesWithoutPosition, (Functions.Function1)_function);
            Peripheral peripheral = symbolicPosition.getPeripheral();
            if (peripheral != null && !conditionIsMet) {
                String _name = symbolicPosition.getName();
                String _plus = "A position with name " + _name;
                String _plus_1 = _plus + " already exists for one of the axes, please specify these axis positions explicitly";
                this.error(_plus_1, (EStructuralFeature)MachinePackage.Literals.SYMBOLIC_POSITION__AXIS_POSITION, CONFLICTING_POSITIONS, new String[0]);
            }
        }
    }
}

