/*
 * Decompiled with CFR 0.152.
 */
package product.impl;

import java.io.Serializable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import product.BooleanValue;
import product.IntegerValue;
import product.ProductDefinition;
import product.ProductFactory;
import product.ProductPackage;
import product.Property;
import product.PropertyDefinition;
import product.StringValue;
import product.TransferType;
import product.ValueType;
import product.impl.BooleanValueImpl;
import product.impl.IntegerValueImpl;
import product.impl.ProductDefinitionImpl;
import product.impl.PropertyDefinitionImpl;
import product.impl.PropertyImpl;
import product.impl.StringValueImpl;

public class ProductFactoryImpl
extends EFactoryImpl
implements ProductFactory {
    public static ProductFactory init() {
        try {
            ProductFactory theProductFactory = (ProductFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/lsat/product");
            if (theProductFactory != null) {
                return theProductFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ProductFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProductDefinition();
            }
            case 1: {
                return this.createPropertyDefinition();
            }
            case 2: {
                return this.createProperty();
            }
            case 4: {
                return this.createStringValue();
            }
            case 5: {
                return this.createBooleanValue();
            }
            case 6: {
                return this.createIntegerValue();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createValueTypeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createTransferTypeFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createSerializableFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertValueTypeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertTransferTypeToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertSerializableToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ProductDefinition createProductDefinition() {
        ProductDefinitionImpl productDefinition = new ProductDefinitionImpl();
        return productDefinition;
    }

    @Override
    public PropertyDefinition createPropertyDefinition() {
        PropertyDefinitionImpl propertyDefinition = new PropertyDefinitionImpl();
        return propertyDefinition;
    }

    @Override
    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    @Override
    public StringValue createStringValue() {
        StringValueImpl stringValue = new StringValueImpl();
        return stringValue;
    }

    @Override
    public BooleanValue createBooleanValue() {
        BooleanValueImpl booleanValue = new BooleanValueImpl();
        return booleanValue;
    }

    @Override
    public IntegerValue createIntegerValue() {
        IntegerValueImpl integerValue = new IntegerValueImpl();
        return integerValue;
    }

    public ValueType createValueTypeFromString(EDataType eDataType, String initialValue) {
        ValueType result = ValueType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertValueTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public TransferType createTransferTypeFromString(EDataType eDataType, String initialValue) {
        TransferType result = TransferType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTransferTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Serializable createSerializableFromString(EDataType eDataType, String initialValue) {
        return (Serializable)super.createFromString(eDataType, initialValue);
    }

    public String convertSerializableToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ProductPackage getProductPackage() {
        return (ProductPackage)this.getEPackage();
    }

    @Deprecated
    public static ProductPackage getPackage() {
        return ProductPackage.eINSTANCE;
    }
}

