/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.lsat.activity.teditor.ide.contentassist.antlr.internal.InternalActivityParser;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class ActivityParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(ActivityGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, ActivityGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getActivitySetAccess().getAlternatives_2(), "rule__ActivitySet__Alternatives_2");
			builder.put(grammarAccess.getParameterDeclarationAccess().getAlternatives(), "rule__ParameterDeclaration__Alternatives");
			builder.put(grammarAccess.getNodeAccess().getAlternatives(), "rule__Node__Alternatives");
			builder.put(grammarAccess.getClaimAccess().getAlternatives_3(), "rule__Claim__Alternatives_3");
			builder.put(grammarAccess.getClaimAccess().getAlternatives_8(), "rule__Claim__Alternatives_8");
			builder.put(grammarAccess.getReleaseAccess().getAlternatives_3(), "rule__Release__Alternatives_3");
			builder.put(grammarAccess.getReleaseAccess().getAlternatives_7(), "rule__Release__Alternatives_7");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_3(), "rule__Move__Alternatives_3");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_9(), "rule__Move__Alternatives_9");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_9_0_0(), "rule__Move__Alternatives_9_0_0");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_9_1_0(), "rule__Move__Alternatives_9_1_0");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_13(), "rule__Move__Alternatives_13");
			builder.put(grammarAccess.getSimpleActionAccess().getAlternatives_3(), "rule__SimpleAction__Alternatives_3");
			builder.put(grammarAccess.getSimpleActionAccess().getAlternatives_8(), "rule__SimpleAction__Alternatives_8");
			builder.put(grammarAccess.getProductChangeAccess().getAlternatives(), "rule__ProductChange__Alternatives");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getAlternatives_1(), "rule__ProductChangeNoTransferType__Alternatives_1");
			builder.put(grammarAccess.getPropertyAccess().getValueAlternatives_3_0(), "rule__Property__ValueAlternatives_3_0");
			builder.put(grammarAccess.getBooleanLiteralAccess().getAlternatives(), "rule__BooleanLiteral__Alternatives");
			builder.put(grammarAccess.getEdgesAccess().getAlternatives(), "rule__Edges__Alternatives");
			builder.put(grammarAccess.getEdgesWithConstraintsAccess().getAlternatives(), "rule__EdgesWithConstraints__Alternatives");
			builder.put(grammarAccess.getSourceReferenceAccess().getAlternatives_1(), "rule__SourceReference__Alternatives_1");
			builder.put(grammarAccess.getDependencyTargetAccess().getAlternatives(), "rule__DependencyTarget__Alternatives");
			builder.put(grammarAccess.getDependencyTargetAccess().getAlternatives_1(), "rule__DependencyTarget__Alternatives_1");
			builder.put(grammarAccess.getTargetReferenceAccess().getAlternatives_1(), "rule__TargetReference__Alternatives_1");
			builder.put(grammarAccess.getIIDAccess().getAlternatives(), "rule__IID__Alternatives");
			builder.put(grammarAccess.getEBigDecimalAccess().getAlternatives_3_0(), "rule__EBigDecimal__Alternatives_3_0");
			builder.put(grammarAccess.getEBigDecimalAccess().getAlternatives_3_1(), "rule__EBigDecimal__Alternatives_3_1");
			builder.put(grammarAccess.getEStringAccess().getAlternatives(), "rule__EString__Alternatives");
			builder.put(grammarAccess.getSchedulingAccess().getAlternatives(), "rule__Scheduling__Alternatives");
			builder.put(grammarAccess.getTransferTypeAccess().getAlternatives(), "rule__TransferType__Alternatives");
			builder.put(grammarAccess.getActivitySetAccess().getGroup(), "rule__ActivitySet__Group__0");
			builder.put(grammarAccess.getImportAccess().getGroup(), "rule__Import__Group__0");
			builder.put(grammarAccess.getActivityAccess().getGroup(), "rule__Activity__Group__0");
			builder.put(grammarAccess.getActivityAccess().getGroup_2(), "rule__Activity__Group_2__0");
			builder.put(grammarAccess.getActivityAccess().getGroup_2_2(), "rule__Activity__Group_2_2__0");
			builder.put(grammarAccess.getActivityAccess().getGroup_4(), "rule__Activity__Group_4__0");
			builder.put(grammarAccess.getActivityAccess().getGroup_13(), "rule__Activity__Group_13__0");
			builder.put(grammarAccess.getEventDeclarationAccess().getGroup(), "rule__EventDeclaration__Group__0");
			builder.put(grammarAccess.getEventDeclarationAccess().getGroup_2(), "rule__EventDeclaration__Group_2__0");
			builder.put(grammarAccess.getActionDeclarationAccess().getGroup(), "rule__ActionDeclaration__Group__0");
			builder.put(grammarAccess.getActionDeclarationAccess().getGroup_2(), "rule__ActionDeclaration__Group_2__0");
			builder.put(grammarAccess.getSymbolicPositionDeclarationAccess().getGroup(), "rule__SymbolicPositionDeclaration__Group__0");
			builder.put(grammarAccess.getSymbolicPositionDeclarationAccess().getGroup_2(), "rule__SymbolicPositionDeclaration__Group_2__0");
			builder.put(grammarAccess.getProfileDeclarationAccess().getGroup(), "rule__ProfileDeclaration__Group__0");
			builder.put(grammarAccess.getProfileDeclarationAccess().getGroup_2(), "rule__ProfileDeclaration__Group_2__0");
			builder.put(grammarAccess.getDistanceDeclarationAccess().getGroup(), "rule__DistanceDeclaration__Group__0");
			builder.put(grammarAccess.getDistanceDeclarationAccess().getGroup_2(), "rule__DistanceDeclaration__Group_2__0");
			builder.put(grammarAccess.getResourceDeclarationAccess().getGroup(), "rule__ResourceDeclaration__Group__0");
			builder.put(grammarAccess.getResourceDeclarationAccess().getGroup_2(), "rule__ResourceDeclaration__Group_2__0");
			builder.put(grammarAccess.getModelTypeDefinitionRefDeclarationAccess().getGroup(), "rule__ModelTypeDefinitionRefDeclaration__Group__0");
			builder.put(grammarAccess.getEventDefAccess().getGroup(), "rule__EventDef__Group__0");
			builder.put(grammarAccess.getActionDefAccess().getGroup(), "rule__ActionDef__Group__0");
			builder.put(grammarAccess.getSymbolicPositionDefAccess().getGroup(), "rule__SymbolicPositionDef__Group__0");
			builder.put(grammarAccess.getProfileDefAccess().getGroup(), "rule__ProfileDef__Group__0");
			builder.put(grammarAccess.getDistanceDefAccess().getGroup(), "rule__DistanceDef__Group__0");
			builder.put(grammarAccess.getResourceDefAccess().getGroup(), "rule__ResourceDef__Group__0");
			builder.put(grammarAccess.getModelTypeDefinitionRefAccess().getGroup(), "rule__ModelTypeDefinitionRef__Group__0");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getGroup(), "rule__LocationPrerequisite__Group__0");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getGroup_1(), "rule__LocationPrerequisite__Group_1__0");
			builder.put(grammarAccess.getClaimAccess().getGroup(), "rule__Claim__Group__0");
			builder.put(grammarAccess.getClaimAccess().getGroup_3_1(), "rule__Claim__Group_3_1__0");
			builder.put(grammarAccess.getClaimAccess().getGroup_7(), "rule__Claim__Group_7__0");
			builder.put(grammarAccess.getClaimAccess().getGroup_8_1(), "rule__Claim__Group_8_1__0");
			builder.put(grammarAccess.getReleaseAccess().getGroup(), "rule__Release__Group__0");
			builder.put(grammarAccess.getReleaseAccess().getGroup_3_1(), "rule__Release__Group_3_1__0");
			builder.put(grammarAccess.getReleaseAccess().getGroup_6(), "rule__Release__Group_6__0");
			builder.put(grammarAccess.getReleaseAccess().getGroup_7_1(), "rule__Release__Group_7_1__0");
			builder.put(grammarAccess.getRaiseEventAccess().getGroup(), "rule__RaiseEvent__Group__0");
			builder.put(grammarAccess.getRaiseEventAccess().getGroup_5(), "rule__RaiseEvent__Group_5__0");
			builder.put(grammarAccess.getRequireEventAccess().getGroup(), "rule__RequireEvent__Group__0");
			builder.put(grammarAccess.getRequireEventAccess().getGroup_5(), "rule__RequireEvent__Group_5__0");
			builder.put(grammarAccess.getMoveAccess().getGroup(), "rule__Move__Group__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_3_1(), "rule__Move__Group_3_1__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_6(), "rule__Move__Group_6__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_9_0(), "rule__Move__Group_9_0__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_9_1(), "rule__Move__Group_9_1__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_10(), "rule__Move__Group_10__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_12(), "rule__Move__Group_12__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_13_1(), "rule__Move__Group_13_1__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup(), "rule__SimpleAction__Group__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_3_1(), "rule__SimpleAction__Group_3_1__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_4(), "rule__SimpleAction__Group_4__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_4_2(), "rule__SimpleAction__Group_4_2__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_7(), "rule__SimpleAction__Group_7__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_8_1(), "rule__SimpleAction__Group_8_1__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup(), "rule__ProductChangeNoTransferType__Group__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_0(), "rule__ProductChangeNoTransferType__Group_1_0__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_0_0(), "rule__ProductChangeNoTransferType__Group_1_0_0__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_0_1(), "rule__ProductChangeNoTransferType__Group_1_0_1__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_0_2(), "rule__ProductChangeNoTransferType__Group_1_0_2__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_0_2_3(), "rule__ProductChangeNoTransferType__Group_1_0_2_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_0_3(), "rule__ProductChangeNoTransferType__Group_1_0_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_0_3_3(), "rule__ProductChangeNoTransferType__Group_1_0_3_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_1(), "rule__ProductChangeNoTransferType__Group_1_1__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_1_0(), "rule__ProductChangeNoTransferType__Group_1_1_0__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_1_1(), "rule__ProductChangeNoTransferType__Group_1_1_1__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_1_1_3(), "rule__ProductChangeNoTransferType__Group_1_1_1_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_1_2(), "rule__ProductChangeNoTransferType__Group_1_1_2__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_1_2_3(), "rule__ProductChangeNoTransferType__Group_1_1_2_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_2(), "rule__ProductChangeNoTransferType__Group_1_2__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_2_0(), "rule__ProductChangeNoTransferType__Group_1_2_0__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_2_0_3(), "rule__ProductChangeNoTransferType__Group_1_2_0_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_2_1(), "rule__ProductChangeNoTransferType__Group_1_2_1__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_2_1_3(), "rule__ProductChangeNoTransferType__Group_1_2_1_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_3(), "rule__ProductChangeNoTransferType__Group_1_3__0");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getGroup_1_3_3(), "rule__ProductChangeNoTransferType__Group_1_3_3__0");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getGroup(), "rule__ProductChangeWithTransferType__Group__0");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getGroup_2(), "rule__ProductChangeWithTransferType__Group_2__0");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getGroup_3(), "rule__ProductChangeWithTransferType__Group_3__0");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getGroup_4(), "rule__ProductChangeWithTransferType__Group_4__0");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getGroup_4_3(), "rule__ProductChangeWithTransferType__Group_4_3__0");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getGroup_5(), "rule__ProductChangeWithTransferType__Group_5__0");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getGroup_5_3(), "rule__ProductChangeWithTransferType__Group_5_3__0");
			builder.put(grammarAccess.getPropertyAccess().getGroup(), "rule__Property__Group__0");
			builder.put(grammarAccess.getBooleanValueAccess().getGroup(), "rule__BooleanValue__Group__0");
			builder.put(grammarAccess.getIntegerValueAccess().getGroup(), "rule__IntegerValue__Group__0");
			builder.put(grammarAccess.getStringValueAccess().getGroup(), "rule__StringValue__Group__0");
			builder.put(grammarAccess.getTracePointAccess().getGroup(), "rule__TracePoint__Group__0");
			builder.put(grammarAccess.getEdgeAccess().getGroup(), "rule__Edge__Group__0");
			builder.put(grammarAccess.getJitConstraintEdgeAccess().getGroup(), "rule__JitConstraintEdge__Group__0");
			builder.put(grammarAccess.getTimeConstraintEdgeAccess().getGroup(), "rule__TimeConstraintEdge__Group__0");
			builder.put(grammarAccess.getEdgeWithJitConstraintAccess().getGroup(), "rule__EdgeWithJitConstraint__Group__0");
			builder.put(grammarAccess.getEdgeWithTimeConstraintAccess().getGroup(), "rule__EdgeWithTimeConstraint__Group__0");
			builder.put(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getGroup(), "rule__EdgeWithInfiniteTimeConstraint__Group__0");
			builder.put(grammarAccess.getTimeConstraintAccess().getGroup(), "rule__TimeConstraint__Group__0");
			builder.put(grammarAccess.getSourceReferenceAccess().getGroup(), "rule__SourceReference__Group__0");
			builder.put(grammarAccess.getSourceReferenceAccess().getGroup_1_1(), "rule__SourceReference__Group_1_1__0");
			builder.put(grammarAccess.getTargetReferenceAccess().getGroup(), "rule__TargetReference__Group__0");
			builder.put(grammarAccess.getTargetReferenceAccess().getGroup_1_1(), "rule__TargetReference__Group_1_1__0");
			builder.put(grammarAccess.getEventAccess().getGroup(), "rule__Event__Group__0");
			builder.put(grammarAccess.getEventAccess().getGroup_2(), "rule__Event__Group_2__0");
			builder.put(grammarAccess.getEventAccess().getGroup_2_2(), "rule__Event__Group_2_2__0");
			builder.put(grammarAccess.getEventItemAccess().getGroup(), "rule__EventItem__Group__0");
			builder.put(grammarAccess.getEBigDecimalAccess().getGroup(), "rule__EBigDecimal__Group__0");
			builder.put(grammarAccess.getEBigDecimalAccess().getGroup_2(), "rule__EBigDecimal__Group_2__0");
			builder.put(grammarAccess.getEBigDecimalAccess().getGroup_3(), "rule__EBigDecimal__Group_3__0");
			builder.put(grammarAccess.getActivitySetAccess().getImportsAssignment_1(), "rule__ActivitySet__ImportsAssignment_1");
			builder.put(grammarAccess.getActivitySetAccess().getActivitiesAssignment_2_0(), "rule__ActivitySet__ActivitiesAssignment_2_0");
			builder.put(grammarAccess.getActivitySetAccess().getEventsAssignment_2_1(), "rule__ActivitySet__EventsAssignment_2_1");
			builder.put(grammarAccess.getImportAccess().getImportURIAssignment_1(), "rule__Import__ImportURIAssignment_1");
			builder.put(grammarAccess.getActivityAccess().getNameAssignment_1(), "rule__Activity__NameAssignment_1");
			builder.put(grammarAccess.getActivityAccess().getParameterDeclarationsAssignment_2_1(), "rule__Activity__ParameterDeclarationsAssignment_2_1");
			builder.put(grammarAccess.getActivityAccess().getParameterDeclarationsAssignment_2_2_1(), "rule__Activity__ParameterDeclarationsAssignment_2_2_1");
			builder.put(grammarAccess.getActivityAccess().getPrerequisitesAssignment_4_2(), "rule__Activity__PrerequisitesAssignment_4_2");
			builder.put(grammarAccess.getActivityAccess().getNodesAssignment_7(), "rule__Activity__NodesAssignment_7");
			builder.put(grammarAccess.getActivityAccess().getEdgesAssignment_11(), "rule__Activity__EdgesAssignment_11");
			builder.put(grammarAccess.getActivityAccess().getConstraintsAssignment_13_2(), "rule__Activity__ConstraintsAssignment_13_2");
			builder.put(grammarAccess.getEventDeclarationAccess().getDeclarationsAssignment_1(), "rule__EventDeclaration__DeclarationsAssignment_1");
			builder.put(grammarAccess.getEventDeclarationAccess().getDeclarationsAssignment_2_1(), "rule__EventDeclaration__DeclarationsAssignment_2_1");
			builder.put(grammarAccess.getActionDeclarationAccess().getDeclarationsAssignment_1(), "rule__ActionDeclaration__DeclarationsAssignment_1");
			builder.put(grammarAccess.getActionDeclarationAccess().getDeclarationsAssignment_2_1(), "rule__ActionDeclaration__DeclarationsAssignment_2_1");
			builder.put(grammarAccess.getSymbolicPositionDeclarationAccess().getDeclarationsAssignment_1(), "rule__SymbolicPositionDeclaration__DeclarationsAssignment_1");
			builder.put(grammarAccess.getSymbolicPositionDeclarationAccess().getDeclarationsAssignment_2_1(), "rule__SymbolicPositionDeclaration__DeclarationsAssignment_2_1");
			builder.put(grammarAccess.getProfileDeclarationAccess().getDeclarationsAssignment_1(), "rule__ProfileDeclaration__DeclarationsAssignment_1");
			builder.put(grammarAccess.getProfileDeclarationAccess().getDeclarationsAssignment_2_1(), "rule__ProfileDeclaration__DeclarationsAssignment_2_1");
			builder.put(grammarAccess.getDistanceDeclarationAccess().getDeclarationsAssignment_1(), "rule__DistanceDeclaration__DeclarationsAssignment_1");
			builder.put(grammarAccess.getDistanceDeclarationAccess().getDeclarationsAssignment_2_1(), "rule__DistanceDeclaration__DeclarationsAssignment_2_1");
			builder.put(grammarAccess.getResourceDeclarationAccess().getDeclarationsAssignment_1(), "rule__ResourceDeclaration__DeclarationsAssignment_1");
			builder.put(grammarAccess.getResourceDeclarationAccess().getDeclarationsAssignment_2_1(), "rule__ResourceDeclaration__DeclarationsAssignment_2_1");
			builder.put(grammarAccess.getModelTypeDefinitionRefDeclarationAccess().getDeclarationsAssignment_1(), "rule__ModelTypeDefinitionRefDeclaration__DeclarationsAssignment_1");
			builder.put(grammarAccess.getEventDefAccess().getNameAssignment_1(), "rule__EventDef__NameAssignment_1");
			builder.put(grammarAccess.getActionDefAccess().getNameAssignment_1(), "rule__ActionDef__NameAssignment_1");
			builder.put(grammarAccess.getSymbolicPositionDefAccess().getNameAssignment_1(), "rule__SymbolicPositionDef__NameAssignment_1");
			builder.put(grammarAccess.getProfileDefAccess().getNameAssignment_1(), "rule__ProfileDef__NameAssignment_1");
			builder.put(grammarAccess.getDistanceDefAccess().getNameAssignment_1(), "rule__DistanceDef__NameAssignment_1");
			builder.put(grammarAccess.getResourceDefAccess().getNameAssignment_1(), "rule__ResourceDef__NameAssignment_1");
			builder.put(grammarAccess.getModelTypeDefinitionRefAccess().getNameAssignment_1(), "rule__ModelTypeDefinitionRef__NameAssignment_1");
			builder.put(grammarAccess.getModelTypeDefinitionRefAccess().getTypeDefinitionAssignment_3(), "rule__ModelTypeDefinitionRef__TypeDefinitionAssignment_3");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getResourceDefinitionAssignment_0(), "rule__LocationPrerequisite__ResourceDefinitionAssignment_0");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getResourceItemAssignment_1_1(), "rule__LocationPrerequisite__ResourceItemAssignment_1_1");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getPeripheralAssignment_3(), "rule__LocationPrerequisite__PeripheralAssignment_3");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getPositionAssignment_5(), "rule__LocationPrerequisite__PositionAssignment_5");
			builder.put(grammarAccess.getClaimAccess().getNameAssignment_1(), "rule__Claim__NameAssignment_1");
			builder.put(grammarAccess.getClaimAccess().getEntryAssignment_3_0(), "rule__Claim__EntryAssignment_3_0");
			builder.put(grammarAccess.getClaimAccess().getOuterEntryAssignment_3_1_0(), "rule__Claim__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getClaimAccess().getEntryAssignment_3_1_1(), "rule__Claim__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getClaimAccess().getPassiveAssignment_4(), "rule__Claim__PassiveAssignment_4");
			builder.put(grammarAccess.getClaimAccess().getResourceDefinitionAssignment_6(), "rule__Claim__ResourceDefinitionAssignment_6");
			builder.put(grammarAccess.getClaimAccess().getResourceItemAssignment_7_1(), "rule__Claim__ResourceItemAssignment_7_1");
			builder.put(grammarAccess.getClaimAccess().getExitAssignment_8_0(), "rule__Claim__ExitAssignment_8_0");
			builder.put(grammarAccess.getClaimAccess().getExitAssignment_8_1_0(), "rule__Claim__ExitAssignment_8_1_0");
			builder.put(grammarAccess.getClaimAccess().getOuterExitAssignment_8_1_1(), "rule__Claim__OuterExitAssignment_8_1_1");
			builder.put(grammarAccess.getReleaseAccess().getNameAssignment_1(), "rule__Release__NameAssignment_1");
			builder.put(grammarAccess.getReleaseAccess().getEntryAssignment_3_0(), "rule__Release__EntryAssignment_3_0");
			builder.put(grammarAccess.getReleaseAccess().getOuterEntryAssignment_3_1_0(), "rule__Release__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getReleaseAccess().getEntryAssignment_3_1_1(), "rule__Release__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getReleaseAccess().getResourceDefinitionAssignment_5(), "rule__Release__ResourceDefinitionAssignment_5");
			builder.put(grammarAccess.getReleaseAccess().getResourceItemAssignment_6_1(), "rule__Release__ResourceItemAssignment_6_1");
			builder.put(grammarAccess.getReleaseAccess().getExitAssignment_7_0(), "rule__Release__ExitAssignment_7_0");
			builder.put(grammarAccess.getReleaseAccess().getExitAssignment_7_1_0(), "rule__Release__ExitAssignment_7_1_0");
			builder.put(grammarAccess.getReleaseAccess().getOuterExitAssignment_7_1_1(), "rule__Release__OuterExitAssignment_7_1_1");
			builder.put(grammarAccess.getRaiseEventAccess().getNameAssignment_1(), "rule__RaiseEvent__NameAssignment_1");
			builder.put(grammarAccess.getRaiseEventAccess().getResourceDefinitionAssignment_4(), "rule__RaiseEvent__ResourceDefinitionAssignment_4");
			builder.put(grammarAccess.getRaiseEventAccess().getResourceItemAssignment_5_1(), "rule__RaiseEvent__ResourceItemAssignment_5_1");
			builder.put(grammarAccess.getRequireEventAccess().getNameAssignment_1(), "rule__RequireEvent__NameAssignment_1");
			builder.put(grammarAccess.getRequireEventAccess().getResourceDefinitionAssignment_4(), "rule__RequireEvent__ResourceDefinitionAssignment_4");
			builder.put(grammarAccess.getRequireEventAccess().getResourceItemAssignment_5_1(), "rule__RequireEvent__ResourceItemAssignment_5_1");
			builder.put(grammarAccess.getMoveAccess().getNameAssignment_1(), "rule__Move__NameAssignment_1");
			builder.put(grammarAccess.getMoveAccess().getEntryAssignment_3_0(), "rule__Move__EntryAssignment_3_0");
			builder.put(grammarAccess.getMoveAccess().getOuterEntryAssignment_3_1_0(), "rule__Move__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getMoveAccess().getEntryAssignment_3_1_1(), "rule__Move__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getMoveAccess().getResourceDefinitionAssignment_5(), "rule__Move__ResourceDefinitionAssignment_5");
			builder.put(grammarAccess.getMoveAccess().getResourceItemAssignment_6_1(), "rule__Move__ResourceItemAssignment_6_1");
			builder.put(grammarAccess.getMoveAccess().getPeripheralAssignment_8(), "rule__Move__PeripheralAssignment_8");
			builder.put(grammarAccess.getMoveAccess().getPassingAssignment_9_0_0_0(), "rule__Move__PassingAssignment_9_0_0_0");
			builder.put(grammarAccess.getMoveAccess().getTargetPositionAssignment_9_0_1(), "rule__Move__TargetPositionAssignment_9_0_1");
			builder.put(grammarAccess.getMoveAccess().getContinuingAssignment_9_1_0_0(), "rule__Move__ContinuingAssignment_9_1_0_0");
			builder.put(grammarAccess.getMoveAccess().getDistanceAssignment_9_1_1(), "rule__Move__DistanceAssignment_9_1_1");
			builder.put(grammarAccess.getMoveAccess().getProfileAssignment_10_1(), "rule__Move__ProfileAssignment_10_1");
			builder.put(grammarAccess.getMoveAccess().getSchedulingTypeAssignment_11(), "rule__Move__SchedulingTypeAssignment_11");
			builder.put(grammarAccess.getMoveAccess().getProductChangesAssignment_12_0(), "rule__Move__ProductChangesAssignment_12_0");
			builder.put(grammarAccess.getMoveAccess().getProductChangesAssignment_12_1(), "rule__Move__ProductChangesAssignment_12_1");
			builder.put(grammarAccess.getMoveAccess().getExitAssignment_13_0(), "rule__Move__ExitAssignment_13_0");
			builder.put(grammarAccess.getMoveAccess().getExitAssignment_13_1_0(), "rule__Move__ExitAssignment_13_1_0");
			builder.put(grammarAccess.getMoveAccess().getOuterExitAssignment_13_1_1(), "rule__Move__OuterExitAssignment_13_1_1");
			builder.put(grammarAccess.getSimpleActionAccess().getNameAssignment_1(), "rule__SimpleAction__NameAssignment_1");
			builder.put(grammarAccess.getSimpleActionAccess().getEntryAssignment_3_0(), "rule__SimpleAction__EntryAssignment_3_0");
			builder.put(grammarAccess.getSimpleActionAccess().getOuterEntryAssignment_3_1_0(), "rule__SimpleAction__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getSimpleActionAccess().getEntryAssignment_3_1_1(), "rule__SimpleAction__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getSimpleActionAccess().getResourceDefinitionAssignment_4_0(), "rule__SimpleAction__ResourceDefinitionAssignment_4_0");
			builder.put(grammarAccess.getSimpleActionAccess().getResourceItemAssignment_4_2_0(), "rule__SimpleAction__ResourceItemAssignment_4_2_0");
			builder.put(grammarAccess.getSimpleActionAccess().getPeripheralAssignment_4_3(), "rule__SimpleAction__PeripheralAssignment_4_3");
			builder.put(grammarAccess.getSimpleActionAccess().getTypeAssignment_5(), "rule__SimpleAction__TypeAssignment_5");
			builder.put(grammarAccess.getSimpleActionAccess().getSchedulingTypeAssignment_6(), "rule__SimpleAction__SchedulingTypeAssignment_6");
			builder.put(grammarAccess.getSimpleActionAccess().getProductChangesAssignment_7_0(), "rule__SimpleAction__ProductChangesAssignment_7_0");
			builder.put(grammarAccess.getSimpleActionAccess().getProductChangesAssignment_7_1(), "rule__SimpleAction__ProductChangesAssignment_7_1");
			builder.put(grammarAccess.getSimpleActionAccess().getExitAssignment_8_0(), "rule__SimpleAction__ExitAssignment_8_0");
			builder.put(grammarAccess.getSimpleActionAccess().getExitAssignment_8_1_0(), "rule__SimpleAction__ExitAssignment_8_1_0");
			builder.put(grammarAccess.getSimpleActionAccess().getOuterExitAssignment_8_1_1(), "rule__SimpleAction__OuterExitAssignment_8_1_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getProductAssignment_1_0_0_1(), "rule__ProductChangeNoTransferType__ProductAssignment_1_0_0_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getSlotAssignment_1_0_1_1(), "rule__ProductChangeNoTransferType__SlotAssignment_1_0_1_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesAssignment_1_0_2_2(), "rule__ProductChangeNoTransferType__StartPropertiesAssignment_1_0_2_2");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesAssignment_1_0_2_3_1(), "rule__ProductChangeNoTransferType__StartPropertiesAssignment_1_0_2_3_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_0_3_2(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_0_3_2");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_0_3_3_1(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_0_3_3_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getSlotAssignment_1_1_0_1(), "rule__ProductChangeNoTransferType__SlotAssignment_1_1_0_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesAssignment_1_1_1_2(), "rule__ProductChangeNoTransferType__StartPropertiesAssignment_1_1_1_2");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesAssignment_1_1_1_3_1(), "rule__ProductChangeNoTransferType__StartPropertiesAssignment_1_1_1_3_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_1_2_2(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_1_2_2");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_1_2_3_1(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_1_2_3_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesAssignment_1_2_0_2(), "rule__ProductChangeNoTransferType__StartPropertiesAssignment_1_2_0_2");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesAssignment_1_2_0_3_1(), "rule__ProductChangeNoTransferType__StartPropertiesAssignment_1_2_0_3_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_2_1_2(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_2_1_2");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_2_1_3_1(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_2_1_3_1");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_3_2(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_3_2");
			builder.put(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesAssignment_1_3_3_1(), "rule__ProductChangeNoTransferType__EndPropertiesAssignment_1_3_3_1");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getTransferTypeAssignment_1(), "rule__ProductChangeWithTransferType__TransferTypeAssignment_1");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getProductAssignment_2_1(), "rule__ProductChangeWithTransferType__ProductAssignment_2_1");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getSlotAssignment_3_1(), "rule__ProductChangeWithTransferType__SlotAssignment_3_1");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getStartPropertiesAssignment_4_2(), "rule__ProductChangeWithTransferType__StartPropertiesAssignment_4_2");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getStartPropertiesAssignment_4_3_1(), "rule__ProductChangeWithTransferType__StartPropertiesAssignment_4_3_1");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getEndPropertiesAssignment_5_2(), "rule__ProductChangeWithTransferType__EndPropertiesAssignment_5_2");
			builder.put(grammarAccess.getProductChangeWithTransferTypeAccess().getEndPropertiesAssignment_5_3_1(), "rule__ProductChangeWithTransferType__EndPropertiesAssignment_5_3_1");
			builder.put(grammarAccess.getPropertyAccess().getDefinitionAssignment_1(), "rule__Property__DefinitionAssignment_1");
			builder.put(grammarAccess.getPropertyAccess().getValueAssignment_3(), "rule__Property__ValueAssignment_3");
			builder.put(grammarAccess.getBooleanValueAccess().getValueAssignment_1(), "rule__BooleanValue__ValueAssignment_1");
			builder.put(grammarAccess.getIntegerValueAccess().getValueAssignment_1(), "rule__IntegerValue__ValueAssignment_1");
			builder.put(grammarAccess.getStringValueAccess().getValueAssignment_1(), "rule__StringValue__ValueAssignment_1");
			builder.put(grammarAccess.getTracePointAccess().getRegexAssignment_1(), "rule__TracePoint__RegexAssignment_1");
			builder.put(grammarAccess.getTracePointAccess().getValueAssignment_2(), "rule__TracePoint__ValueAssignment_2");
			builder.put(grammarAccess.getEdgeAccess().getSourceAssignment_1(), "rule__Edge__SourceAssignment_1");
			builder.put(grammarAccess.getEdgeAccess().getTargetAssignment_3(), "rule__Edge__TargetAssignment_3");
			builder.put(grammarAccess.getJitConstraintEdgeAccess().getSourceAssignment_1(), "rule__JitConstraintEdge__SourceAssignment_1");
			builder.put(grammarAccess.getJitConstraintEdgeAccess().getBoundsAssignment_3(), "rule__JitConstraintEdge__BoundsAssignment_3");
			builder.put(grammarAccess.getJitConstraintEdgeAccess().getTargetAssignment_4(), "rule__JitConstraintEdge__TargetAssignment_4");
			builder.put(grammarAccess.getTimeConstraintEdgeAccess().getSourceAssignment_1(), "rule__TimeConstraintEdge__SourceAssignment_1");
			builder.put(grammarAccess.getTimeConstraintEdgeAccess().getBoundsAssignment_3(), "rule__TimeConstraintEdge__BoundsAssignment_3");
			builder.put(grammarAccess.getTimeConstraintEdgeAccess().getTargetAssignment_5(), "rule__TimeConstraintEdge__TargetAssignment_5");
			builder.put(grammarAccess.getEdgeWithJitConstraintAccess().getSourceAssignment_1(), "rule__EdgeWithJitConstraint__SourceAssignment_1");
			builder.put(grammarAccess.getEdgeWithJitConstraintAccess().getBoundsAssignment_3(), "rule__EdgeWithJitConstraint__BoundsAssignment_3");
			builder.put(grammarAccess.getEdgeWithJitConstraintAccess().getTargetAssignment_4(), "rule__EdgeWithJitConstraint__TargetAssignment_4");
			builder.put(grammarAccess.getEdgeWithTimeConstraintAccess().getSourceAssignment_1(), "rule__EdgeWithTimeConstraint__SourceAssignment_1");
			builder.put(grammarAccess.getEdgeWithTimeConstraintAccess().getBoundsAssignment_3(), "rule__EdgeWithTimeConstraint__BoundsAssignment_3");
			builder.put(grammarAccess.getEdgeWithTimeConstraintAccess().getTargetAssignment_5(), "rule__EdgeWithTimeConstraint__TargetAssignment_5");
			builder.put(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getSourceAssignment_1(), "rule__EdgeWithInfiniteTimeConstraint__SourceAssignment_1");
			builder.put(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getBoundsAssignment_3(), "rule__EdgeWithInfiniteTimeConstraint__BoundsAssignment_3");
			builder.put(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getTargetAssignment_4(), "rule__EdgeWithInfiniteTimeConstraint__TargetAssignment_4");
			builder.put(grammarAccess.getTimeConstraintAccess().getLowerAssignment_1(), "rule__TimeConstraint__LowerAssignment_1");
			builder.put(grammarAccess.getTimeConstraintAccess().getUpperAssignment_3(), "rule__TimeConstraint__UpperAssignment_3");
			builder.put(grammarAccess.getSourceReferenceAccess().getNodeAssignment_1_0(), "rule__SourceReference__NodeAssignment_1_0");
			builder.put(grammarAccess.getSourceReferenceAccess().getNodeAssignment_1_1_1(), "rule__SourceReference__NodeAssignment_1_1_1");
			builder.put(grammarAccess.getTargetReferenceAccess().getNodeAssignment_1_0(), "rule__TargetReference__NodeAssignment_1_0");
			builder.put(grammarAccess.getTargetReferenceAccess().getNodeAssignment_1_1_1(), "rule__TargetReference__NodeAssignment_1_1_1");
			builder.put(grammarAccess.getEventAccess().getNameAssignment_1(), "rule__Event__NameAssignment_1");
			builder.put(grammarAccess.getEventAccess().getItemsAssignment_2_1(), "rule__Event__ItemsAssignment_2_1");
			builder.put(grammarAccess.getEventAccess().getItemsAssignment_2_2_1(), "rule__Event__ItemsAssignment_2_2_1");
			builder.put(grammarAccess.getEventItemAccess().getNameAssignment_1(), "rule__EventItem__NameAssignment_1");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private ActivityGrammarAccess grammarAccess;

	@Override
	protected InternalActivityParser createParser() {
		InternalActivityParser result = new InternalActivityParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public ActivityGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(ActivityGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
	
	public NameMappings getNameMappings() {
		return nameMappings;
	}
	
	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
