/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.api.algorithm;

import java.util.Collection;
import java.util.Map;
import org.eclipse.lsat.common.ludus.api.MaxPlusException;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algorithms.CycleCheck;
import org.eclipse.lsat.common.ludus.backend.algorithms.SimpleCyclesResourceCheck;
import org.eclipse.lsat.common.ludus.backend.algorithms.SimpleCyclesResourceCheckResult;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.mpt.api.NotAllResourcesLinkedException;

public class MaxPlusAlgorithm {
    protected MaxPlusAlgorithm() {
    }

    protected static <V, E> void checkNotCyclic(FSM<V, E> fsm) throws MaxPlusException {
        if (CycleCheck.check(fsm)) {
            throw new MaxPlusException("Finite-state machine contains a cycle.");
        }
    }

    protected static <V, E> void checkCyclic(FSM<V, E> fsm) throws MaxPlusException {
        if (!CycleCheck.check(fsm)) {
            throw new MaxPlusException("Finite-state machine does not contain a cycle.");
        }
    }

    protected static <V, E> void checkNoDeadlocks(FSM<V, E> fsm) throws MaxPlusException {
        for (Object l : fsm.getVertices()) {
            if (!fsm.outgoingEdgesOf(l).isEmpty()) continue;
            throw new MaxPlusException("Location " + l.toString() + " has no outgoing edges.");
        }
    }

    protected static void checkAllMatricesSameSize(Collection<Matrix> matrixCollection) throws MaxPlusException {
        Matrix first = matrixCollection.iterator().next();
        int rows = first.getRows();
        int columns = first.getColumns();
        for (Matrix m : matrixCollection) {
            if (m.getRows() != rows) {
                throw new MaxPlusException("Matrices have different row sizes.");
            }
            if (m.getColumns() == columns) continue;
            throw new MaxPlusException("Matrices have different column sizes.");
        }
    }

    protected static void checkEventMapping(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws MaxPlusException {
        for (Edge e : fsm.getEdges()) {
            if (matrixMap.containsKey(e.getEvent())) continue;
            throw new MaxPlusException("No matrix found for event " + e.getEvent());
        }
    }

    protected static void checkResourcesConnected(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws NotAllResourcesLinkedException {
        SimpleCyclesResourceCheck simpleCycleCheck = new SimpleCyclesResourceCheck();
        SimpleCyclesResourceCheckResult result = simpleCycleCheck.check(fsm, matrixMap);
        if (!result.isAllResourcesUsed()) {
            throw new NotAllResourcesLinkedException(result.getSimpleCycle(), result.getMissingClaimPairs());
        }
    }
}

