/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class StackedIterator<E>
implements Iterator<E> {
    private final LinkedList<Iterator<? extends E>> sources = new LinkedList();

    public StackedIterator(Iterator<? extends E> source) {
        this.sources.offerFirst(source);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        while (!this.sources.isEmpty()) {
            if (this.sources.peekFirst().hasNext()) {
                return true;
            }
            this.sources.pollFirst();
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E next = this.sources.peekFirst().next();
        return next;
    }

    public void push(Iterator<? extends E> iterator) {
        this.sources.offerFirst(iterator);
    }

    public void pop() {
        this.sources.removeFirst();
    }
}

