/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Activity;
import activity.ActivitySet;
import activity.Claim;
import activity.Release;
import activity.ResourceAction;
import activity.util.ActivityUtil;
import java.util.ArrayList;
import java.util.function.Consumer;
import machine.IResource;
import machine.Machine;
import machine.MachineFactory;
import machine.Resource;
import machine.ResourceType;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.util.IterableUtil;

public class PassiveClaimTransformer {
    private PassiveClaimTransformer() {
    }

    public static void transform(ActivitySet activities) {
        PassiveClaimTransformer.process(activities, Release.class, PassiveClaimTransformer::processRelease);
        PassiveClaimTransformer.process(activities, Claim.class, PassiveClaimTransformer::processClaim);
        PassiveClaimTransformer.process(activities, ResourceAction.class, ActivityUtil::insertSyncBars);
        PassiveClaimTransformer.process(activities, Claim.class, (? super T it) -> it.setPassive(false));
    }

    private static void processRelease(Release release) {
        Activity activity = (Activity)release.getGraph();
        Claim claim = (Claim)IterableUtil.first(ActivityUtil.getClaims(activity, release.getResource()));
        if (claim.isPassive()) {
            IResource resource = release.getResource();
            Resource passiveResource = PassiveClaimTransformer.getPassiveResource(resource, true);
            release.setResource((IResource)passiveResource);
            Claim pClaim = PassiveClaimTransformer.addPassiveClaim(ActivityUtil.getPassiveName(resource), activity, (IResource)passiveResource);
            pClaim.setPassive(true);
            ActivityUtil.addDependency(activity, pClaim, release);
            Release iRelease = PassiveClaimTransformer.addPassiveRelease(ActivityUtil.getPassiveName(claim.getResource()), activity, claim.getResource());
            ActivityUtil.addDependency(activity, claim, iRelease);
        }
    }

    private static void processClaim(Claim claim) {
        if (!claim.isPassive()) {
            PassiveClaimTransformer.processActiveClaim(claim);
        }
    }

    private static void processActiveClaim(Claim claim) {
        IResource resource = claim.getResource();
        Resource passiveResource = PassiveClaimTransformer.getPassiveResource(resource, false);
        if (passiveResource == null) {
            return;
        }
        Activity activity = (Activity)claim.getGraph();
        Release release = (Release)IterableUtil.first(ActivityUtil.getReleases(activity, resource));
        Claim pClaim = PassiveClaimTransformer.addPassiveClaim(ActivityUtil.getPassiveName(resource), activity, (IResource)passiveResource);
        Release pRelease = PassiveClaimTransformer.addPassiveRelease(ActivityUtil.getPassiveName(resource), activity, (IResource)passiveResource);
        ActivityUtil.addDependency(activity, pClaim, claim);
        ActivityUtil.addDependency(activity, release, pRelease);
    }

    private static Resource getPassiveResource(IResource resource, boolean create) {
        Machine machine = (Machine)resource.getResource().eContainer();
        for (Resource pResource : machine.getResources()) {
            if (!pResource.getName().equals(ActivityUtil.getPassiveName(resource))) continue;
            return pResource;
        }
        if (create) {
            return PassiveClaimTransformer.createPassiveResource(resource);
        }
        return null;
    }

    private static Resource createPassiveResource(IResource resource) {
        Machine machine = (Machine)resource.getResource().eContainer();
        Resource pResource = MachineFactory.eINSTANCE.createResource();
        pResource.setName(ActivityUtil.getPassiveName(resource));
        pResource.setResourceType(ResourceType.PASSIVE);
        machine.getResources().add((Object)pResource);
        return pResource;
    }

    private static Claim addPassiveClaim(String name, Activity activity, IResource passiveResource) {
        Claim claim = ActivityUtil.addClaim(activity, passiveResource);
        claim.setName("C_" + name);
        return claim;
    }

    private static Release addPassiveRelease(String name, Activity activity, IResource passiveResource) {
        Release release = ActivityUtil.addRelease(activity, passiveResource);
        release.setName("R_" + name);
        return release;
    }

    private static <T extends Node> void process(ActivitySet activitySet, Class<T> clazz, Consumer<? super T> predicate) {
        activitySet.getActivities().forEach(a -> PassiveClaimTransformer.process(a, clazz, predicate));
    }

    private static <T extends Node> void process(Activity activity, Class<T> clazz, Consumer<? super T> predicate) {
        new ArrayList(activity.getNodes()).stream().filter(clazz::isInstance).map(clazz::cast).distinct().forEach(predicate);
    }
}

