/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.scheduler.graph.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.lsat.common.scheduler.graph.TimeStepData;

public class ResampleTimeStepData {
    public static Map<String, List<List<BigDecimal>>> resample(EMap<String, EList<TimeStepData>> executionData, double newSampleFrequency) {
        LinkedHashMap<String, List<List<BigDecimal>>> result = new LinkedHashMap<String, List<List<BigDecimal>>>();
        for (Map.Entry entry : executionData.entrySet()) {
            result.put((String)entry.getKey(), ResampleTimeStepData.resample((EList<TimeStepData>)((EList)entry.getValue()), newSampleFrequency));
        }
        return result;
    }

    public static List<List<BigDecimal>> resample(EList<TimeStepData> data, double newSampleFrequency) {
        BigDecimal tZero;
        int numInputSamples = data.size();
        BigDecimal tStep = BigDecimal.valueOf(1.0 / newSampleFrequency);
        BigDecimal tStart = tZero = ((TimeStepData)data.get(0)).timeValue();
        BigDecimal tEnd = tStart.add(tStep);
        int index = 0;
        ArrayList<EList<BigDecimal>> sampleList = new ArrayList<EList<BigDecimal>>();
        ArrayList<List<BigDecimal>> result = new ArrayList<List<BigDecimal>>();
        while (index < numInputSamples) {
            BigDecimal t = ((TimeStepData)data.get(index)).timeValue();
            if (t.compareTo(tEnd) < 0) {
                EList<BigDecimal> d = ((TimeStepData)data.get(index)).getValues();
                sampleList.add(d);
                ++index;
            }
            if (t.compareTo(tEnd) < 0 && index != numInputSamples) continue;
            int numSamples = sampleList.size();
            if (numSamples > 0) {
                ArrayList<BigDecimal> resampledValues = new ArrayList<BigDecimal>();
                resampledValues.add(tStart);
                int valueSize = ((List)sampleList.get(0)).size();
                int n = 1;
                while (n < valueSize) {
                    BigDecimal dataValue = null;
                    if (tStart.equals(tZero)) {
                        dataValue = (BigDecimal)((List)sampleList.get(0)).get(n);
                    } else if (index == numInputSamples) {
                        dataValue = (BigDecimal)((List)sampleList.get(numSamples - 1)).get(n);
                    } else if (numSamples % 2 == 0) {
                        sortedSampleList = new ArrayList<List>(sampleList);
                        sortedSampleList.sort(Comparator.comparing(l -> (BigDecimal)l.get(0)));
                        BigDecimal v1 = (BigDecimal)((List)sortedSampleList.get(numSamples / 2 - 1)).get(n);
                        BigDecimal v2 = (BigDecimal)((List)sortedSampleList.get(numSamples / 2)).get(n);
                        dataValue = v1.add(v2).divide(BigDecimal.TWO);
                    } else {
                        sortedSampleList = new ArrayList(sampleList);
                        sortedSampleList.sort(Comparator.comparing(l -> (BigDecimal)l.get(0)));
                        dataValue = (BigDecimal)((List)sortedSampleList.get(numSamples / 2)).get(n);
                    }
                    resampledValues.add(dataValue);
                    ++n;
                }
                result.add(resampledValues);
                sampleList.clear();
            }
            tStart = tEnd;
            tEnd = tStart.add(tStep);
        }
        return result;
    }
}

