/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.model;

import com.google.gson.annotations.SerializedName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.lsat.external.api.model.ActionBase;
import org.eclipse.lsat.external.api.model.Activity;
import org.eclipse.lsat.external.api.model.Dispatch;
import org.eclipse.lsat.external.api.model.LsatBase;
import org.eclipse.lsat.external.api.model.TaskAttributesValue;
import org.eclipse.lsat.external.api.model.TaskType;

public class Task
extends LsatBase {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    @Nonnull
    private Double startTime;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    @Nonnull
    private Double duration;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    @Nullable
    private Double endTime;
    public static final String SERIALIZED_NAME_ACTION_ID = "actionId";
    @SerializedName(value="actionId")
    @Nullable
    private String actionId;
    private transient ActionBase action;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    @Nullable
    private String activityId;
    private transient Activity activity;
    public static final String SERIALIZED_NAME_DISPATCH_ID = "dispatchId";
    @SerializedName(value="dispatchId")
    @Nullable
    private String dispatchId;
    private transient Dispatch dispatch;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    @Nullable
    private Map<String, TaskAttributesValue> attributes = new LinkedHashMap<String, TaskAttributesValue>();
    public static final String SERIALIZED_NAME_EXECUTION_DATA = "executionData";
    @SerializedName(value="executionData")
    @Nullable
    private Map<String, Map<String, List<Double>>> executionData = new LinkedHashMap<String, Map<String, List<Double>>>();
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private TaskType type;

    public Task() {
    }

    public Task(Double endTime) {
        this();
        this.endTime = endTime;
    }

    public Task name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Task startTime(@Nonnull Double startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nonnull
    public Double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(@Nonnull Double startTime) {
        this.startTime = startTime;
    }

    public Task duration(@Nonnull Double duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(@Nonnull Double duration) {
        this.duration = duration;
    }

    @Nullable
    public Double getEndTime() {
        return this.startTime + this.duration;
    }

    public Task actionId(@Nullable String actionId) {
        this.actionId = actionId;
        return this;
    }

    @Nullable
    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(@Nullable String actionId) {
        this.actionId = actionId;
    }

    public Task activityId(@Nullable String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(@Nullable String activityId) {
        this.activityId = activityId;
    }

    public Task dispatchId(@Nullable String dispatchId) {
        this.dispatchId = dispatchId;
        return this;
    }

    @Nullable
    public String getDispatchId() {
        return this.dispatchId;
    }

    public void setDispatchId(@Nullable String dispatchId) {
        this.dispatchId = dispatchId;
    }

    public Task attributes(@Nullable Map<String, TaskAttributesValue> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Task putAttributesItem(String key, TaskAttributesValue attributesItem) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, TaskAttributesValue>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    public Map<String, TaskAttributesValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable Map<String, TaskAttributesValue> attributes) {
        this.attributes = attributes;
    }

    public Task executionData(@Nullable Map<String, Map<String, List<Double>>> executionData) {
        this.executionData = executionData;
        return this;
    }

    public Task putExecutionDataItem(String key, Map<String, List<Double>> executionDataItem) {
        if (this.executionData == null) {
            this.executionData = new LinkedHashMap<String, Map<String, List<Double>>>();
        }
        this.executionData.put(key, executionDataItem);
        return this;
    }

    @Nullable
    public Map<String, Map<String, List<Double>>> getExecutionData() {
        return this.executionData;
    }

    public void setExecutionData(@Nullable Map<String, Map<String, List<Double>>> executionData) {
        this.executionData = executionData;
    }

    public Task type(@Nonnull TaskType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TaskType getType() {
        return this.type;
    }

    public void setType(@Nonnull TaskType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return Objects.equals(this.name, task.name) && Objects.equals(this.startTime, task.startTime) && Objects.equals(this.duration, task.duration) && Objects.equals(this.endTime, task.endTime) && Objects.equals(this.actionId, task.actionId) && Objects.equals(this.activityId, task.activityId) && Objects.equals(this.dispatchId, task.dispatchId) && Objects.equals(this.attributes, task.attributes) && Objects.equals(this.executionData, task.executionData) && Objects.equals((Object)this.type, (Object)task.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.startTime, this.duration, this.endTime, this.actionId, this.activityId, this.dispatchId, this.attributes, this.executionData, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Task {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    actionId: ").append(this.toIndentedString(this.actionId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    dispatchId: ").append(this.toIndentedString(this.dispatchId)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    executionData: ").append(this.toIndentedString(this.executionData)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public ActionBase getAction() {
        return this.action;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Dispatch getDispatch() {
        return this.dispatch;
    }
}

