/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.transformation;

import activity.Activity;
import activity.ActivitySet;
import activity.Claim;
import activity.util.ActivityParametersUtil;
import com.google.common.collect.Iterables;
import common.CommonFactory;
import common.HasName;
import common.Import;
import common.Parameter;
import common.ParameterReference;
import common.TypeDefinition;
import dispatching.ActivityDispatching;
import dispatching.Dispatch;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import machine.IResource;
import machine.Resource;
import machine.ResourceItem;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.mpt.transformation.ExpandActivities;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public final class ReduceActivityDispatching {
    private ReduceActivityDispatching() {
    }

    public static void reduce(ActivityDispatching activityDispatching, ActivitySet activitySet) {
        HashSet allActivities = CollectionLiterals.newHashSet();
        EList _activities = activitySet.getActivities();
        Iterables.addAll((Collection)allActivities, (Iterable)_activities);
        Functions.Function1 _function = it -> it.getActivities();
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)activitySet.loadAll(), ActivitySet.class), (Functions.Function1)_function);
        Iterables.addAll((Collection)allActivities, (Iterable)_flatMap);
        LinkedHashMap expandMap = CollectionLiterals.newLinkedHashMap();
        Consumer<Activity> _function_1 = a -> {
            Consumer<String> _function_2 = it -> expandMap.put(it, a);
            ActivityParametersUtil.getAllExpandedNames((Activity)a).forEach(_function_2);
        };
        allActivities.forEach(_function_1);
        Import importActivitySet = CommonFactory.eINSTANCE.createImport();
        importActivitySet.setImportURI(activitySet.eResource().getURI().toString());
        EList _imports = activityDispatching.getImports();
        _imports.add((Object)importActivitySet);
        Functions.Function1 _function_2 = it -> it.getDispatches();
        Consumer<Dispatch> _function_3 = dis -> {
            int _size_1;
            boolean _notEquals;
            Activity activity = (Activity)expandMap.get(dis.getActivity().getName());
            Collection parNames = ActivityParametersUtil.getParameterNames((String)activity.getName(), (String)dis.getActivity().getName());
            Functions.Function1 _function_4 = it -> it.getResource();
            Functions.Function1 _function_5 = it -> it instanceof ResourceItem || it instanceof Resource;
            List resourceItemsFromActivity = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)dis.getActivity().getNodes(), Claim.class), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
            List declarations = ActivityParametersUtil.getDeclarations((Activity)activity);
            int _size = parNames.size();
            boolean bl = _notEquals = _size != (_size_1 = declarations.size());
            if (_notEquals) {
                throw new RuntimeException("Cannot convert expanded activity");
            }
            Iterator iter = declarations.iterator();
            List resources = resourceItemsFromActivity;
            for (List parName : parNames) {
                Parameter parameter = CommonFactory.eINSTANCE.createParameter();
                TypeDefinition declaration = (TypeDefinition)iter.next();
                int i = 0;
                while (i < parName.size()) {
                    Functions.Function1 _function_6 = it -> it.getReference();
                    HasName namedReference = ReduceActivityDispatching.findItem(activity, resources, declaration, (String)parName.get(i), ListExtensions.map((List)parameter.getReferences(), (Functions.Function1)_function_6));
                    if (namedReference instanceof ResourceItem) {
                        resources.add((IResource)namedReference);
                    }
                    if (namedReference == null) {
                        String _get = (String)parName.get(i);
                        String _plus = "Cannot find item with name " + _get;
                        throw new RuntimeException(_plus);
                    }
                    ParameterReference ref = CommonFactory.eINSTANCE.createParameterReference();
                    ref.setReference(namedReference);
                    EList _references = parameter.getReferences();
                    _references.add((Object)ref);
                    ++i;
                }
                EList _parameters = dis.getParameters();
                _parameters.add((Object)parameter);
            }
            dis.setActivity(activity);
        };
        IterableExtensions.flatMap((Iterable)activityDispatching.getDispatchGroups(), (Functions.Function1)_function_2).forEach(_function_3);
        EList _imports_1 = activityDispatching.getImports();
        _imports_1.remove((Object)importActivitySet);
        Functions.Function1 _function_4 = it -> it.getImportURI().contains(".activity");
        Import _findFirst = (Import)IterableExtensions.findFirst((Iterable)activityDispatching.getImports(), (Functions.Function1)_function_4);
        _findFirst.setImportURI(activitySet.eResource().getURI().toString());
    }

    private static HasName findItem(Activity activity, List<? extends IResource> resources, TypeDefinition declaration, String itemName, List<? extends HasName> current) {
        Collection candidates = ActivityParametersUtil.findCandidate((Activity)activity, resources, (TypeDefinition)declaration, current);
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, itemName);
        };
        return (HasName)IterableExtensions.findFirst((Iterable)candidates, (Functions.Function1)_function);
    }

    private static LinkedHashMap<String, Activity> expandNames(List<Activity> activities) {
        return ExpandActivities.expandNames(activities);
    }
}

