/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.documentLink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentLinkReconcilingTest
extends AbstractTestWithProject {
    private static final String CONTENT = "1st-line #LINK1 1st-line\n2nd-line #LINK2_START\n#LINK2_END 3rd-line #LINK3 3rd-line\n#LINK4\n5th-line #LINK5_START_#LINK5_END\n#LINK6_START\n#LINK6_END\n8th-line #LINK7 8th-line";
    private static final List<DocumentLink> CONTENT_LINKS = List.of(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://link1"), new DocumentLink(new Range(new Position(1, 9), new Position(2, 10)), "file://link2"), new DocumentLink(new Range(new Position(2, 20), new Position(2, 26)), "file://link3"), new DocumentLink(new Range(new Position(3, 0), new Position(3, 6)), "file://link4"), new DocumentLink(new Range(new Position(4, 9), new Position(4, 32)), "file://link5"), new DocumentLink(new Range(new Position(5, 0), new Position(6, 10)), "file://link6"), new DocumentLink(new Range(new Position(7, 9), new Position(7, 15)), "file://link7"));
    public static final Color COLOR_1ST_LINE = new Color(255, 0, 0);
    public static final Color COLOR_2ND_LINE = new Color(225, 255, 0);
    public static final Color COLOR_3RD_LINE = new Color(255, 0, 255);
    public static final Color COLOR_4TH_LINE = new Color(0, 255, 0);
    public static final Color COLOR_5TH_LINE = new Color(0, 255, 255);
    public static final Color COLOR_6TH_LINE = new Color(128, 128, 255);
    public static final Color COLOR_7TH_LINE = new Color(128, 0, 0);
    public static final Color COLOR_8TH_LINE = new Color(0, 128, 0);
    private List<TextPresentation> textPresentations = new ArrayList<TextPresentation>(4);

    @Test
    public void testFullDocumentLinkReconciling() throws Exception {
        MockLanguageServer.INSTANCE.setDocumentLinks(CONTENT_LINKS);
        TextViewer viewer = (TextViewer)TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, CONTENT));
        IDocument doc = viewer.getDocument();
        int pos = 0;
        int len = 0;
        StyleRange[] styleRangeArray = new StyleRange[8];
        len = doc.getLineLength(0);
        styleRangeArray[0] = this.textStyle(pos, len, COLOR_1ST_LINE);
        pos += len;
        len = doc.getLineLength(1);
        styleRangeArray[1] = this.textStyle(pos, len, COLOR_2ND_LINE);
        pos += len;
        len = doc.getLineLength(2);
        styleRangeArray[2] = this.textStyle(pos, len, COLOR_3RD_LINE);
        pos += len;
        len = doc.getLineLength(3);
        styleRangeArray[3] = this.textStyle(pos, len, COLOR_4TH_LINE);
        pos += len;
        len = doc.getLineLength(4);
        styleRangeArray[4] = this.textStyle(pos, len, COLOR_5TH_LINE);
        pos += len;
        len = doc.getLineLength(5);
        styleRangeArray[5] = this.textStyle(pos, len, COLOR_6TH_LINE);
        pos += len;
        len = doc.getLineLength(6);
        styleRangeArray[6] = this.textStyle(pos, len, COLOR_7TH_LINE);
        styleRangeArray[7] = this.textStyle(pos += len, doc.getLineLength(7), COLOR_8TH_LINE);
        viewer.getTextWidget().setStyleRanges(styleRangeArray);
        viewer.addTextPresentationListener(this::textPresentationListener);
        this.waitForAndAssertTextPresentations(doc);
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(0)));
        Assertions.assertEquals((int)2, (int)this.getStylesCount(this.textPresentations.get(1)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(2)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(3)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(4)));
        Assertions.assertEquals((int)2, (int)this.getStylesCount(this.textPresentations.get(5)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(6)));
        StyleRange[] styles = viewer.getTextWidget().getStyleRanges();
        Assertions.assertEquals((int)20, (int)styles.length);
        pos = 0;
        len = 0;
        len = 9;
        Assertions.assertEquals((Object)this.textStyle(pos, 9, COLOR_1ST_LINE), (Object)styles[0]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_1ST_LINE), (Object)styles[1]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_1ST_LINE), (Object)styles[2]);
        pos += len;
        len = 9;
        Assertions.assertEquals((Object)this.textStyle(pos, 9, COLOR_2ND_LINE), (Object)styles[3]);
        pos += len;
        len = 13;
        Assertions.assertEquals((Object)this.linkStyle(pos, 13, COLOR_2ND_LINE), (Object)styles[4]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.linkStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[5]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[6]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_3RD_LINE), (Object)styles[7]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[8]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_4TH_LINE), (Object)styles[9]);
        pos += len;
        len = 1;
        Assertions.assertEquals((Object)this.textStyle(pos, 1, COLOR_4TH_LINE), (Object)styles[10]);
        pos += len;
        len = 9;
        Assertions.assertEquals((Object)this.textStyle(pos, 9, COLOR_5TH_LINE), (Object)styles[11]);
        pos += len;
        len = 23;
        Assertions.assertEquals((Object)this.linkStyle(pos, 23, COLOR_5TH_LINE), (Object)styles[12]);
        pos += len;
        len = 1;
        Assertions.assertEquals((Object)this.textStyle(pos, 1, COLOR_5TH_LINE), (Object)styles[13]);
        pos += len;
        len = 13;
        Assertions.assertEquals((Object)this.linkStyle(pos, 13, COLOR_6TH_LINE), (Object)styles[14]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.linkStyle(pos, 10, COLOR_7TH_LINE), (Object)styles[15]);
        pos += len;
        len = 1;
        Assertions.assertEquals((Object)this.textStyle(pos, 1, COLOR_7TH_LINE), (Object)styles[16]);
        pos += len;
        len = 9;
        Assertions.assertEquals((Object)this.textStyle(pos, 9, COLOR_8TH_LINE), (Object)styles[17]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_8TH_LINE), (Object)styles[18]);
        Assertions.assertEquals((Object)this.textStyle(pos += len, 9, COLOR_8TH_LINE), (Object)styles[19]);
    }

    @Test
    public void testClippedDocumentLinkReconciling() throws Exception {
        MockLanguageServer.INSTANCE.setDocumentLinks(CONTENT_LINKS);
        TextViewer viewer = (TextViewer)TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, CONTENT));
        IDocument doc = viewer.getDocument();
        int line5visibleLength = 21;
        int line3Start = doc.getLineOffset(2);
        int middleOfLink5 = doc.getLineOffset(4) + line5visibleLength;
        viewer.setVisibleRegion(line3Start, middleOfLink5 - line3Start);
        int pos = 0;
        int len = 0;
        StyleRange[] styleRangeArray = new StyleRange[3];
        pos += len;
        len = doc.getLineLength(2);
        styleRangeArray[0] = this.textStyle(pos, len, COLOR_3RD_LINE);
        pos += len;
        len = doc.getLineLength(3);
        styleRangeArray[1] = this.textStyle(pos, len, COLOR_4TH_LINE);
        styleRangeArray[2] = this.textStyle(pos += len, line5visibleLength, COLOR_5TH_LINE);
        viewer.getTextWidget().setStyleRanges(styleRangeArray);
        viewer.addTextPresentationListener(this::textPresentationListener);
        this.waitForAndAssertTextPresentations(doc);
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(0)));
        Assertions.assertEquals((int)2, (int)this.getStylesCount(this.textPresentations.get(1)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(2)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(3)));
        Assertions.assertEquals((int)2, (int)this.getStylesCount(this.textPresentations.get(4)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(5)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(6)));
        StyleRange[] styles = viewer.getTextWidget().getStyleRanges();
        Assertions.assertEquals((int)8, (int)styles.length);
        pos = 0;
        len = 0;
        len = 10;
        Assertions.assertEquals((Object)this.linkStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[0]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[1]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_3RD_LINE), (Object)styles[2]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[3]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_4TH_LINE), (Object)styles[4]);
        pos += len;
        len = 1;
        Assertions.assertEquals((Object)this.textStyle(pos, 1, COLOR_4TH_LINE), (Object)styles[5]);
        pos += len;
        len = 9;
        Assertions.assertEquals((Object)this.textStyle(pos, 9, COLOR_5TH_LINE), (Object)styles[6]);
        Assertions.assertEquals((Object)this.linkStyle(pos += len, 12, COLOR_5TH_LINE), (Object)styles[7]);
    }

    @Test
    public void testDocumentWithFoldingLinkReconciling() throws Exception {
        MockLanguageServer.INSTANCE.setDocumentLinks(CONTENT_LINKS);
        ProjectionViewer viewer = (ProjectionViewer)TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, CONTENT));
        IDocument doc = viewer.getDocument();
        this.foldLines(0, 1, viewer);
        this.foldLines(3, 4, viewer);
        this.foldLines(5, 6, viewer);
        int pos = 0;
        int len = 0;
        StyleRange[] styleRangeArray = new StyleRange[5];
        len = doc.getLineLength(0);
        styleRangeArray[0] = this.textStyle(pos, len, COLOR_1ST_LINE);
        pos += len;
        len = doc.getLineLength(2);
        styleRangeArray[1] = this.textStyle(pos, len, COLOR_3RD_LINE);
        pos += len;
        len = doc.getLineLength(3);
        styleRangeArray[2] = this.textStyle(pos, len, COLOR_4TH_LINE);
        pos += len;
        len = doc.getLineLength(5);
        styleRangeArray[3] = this.textStyle(pos, len, COLOR_6TH_LINE);
        styleRangeArray[4] = this.textStyle(pos += len, doc.getLineLength(7), COLOR_8TH_LINE);
        viewer.getTextWidget().setStyleRanges(styleRangeArray);
        viewer.addTextPresentationListener(this::textPresentationListener);
        this.waitForAndAssertTextPresentations(doc);
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(0)));
        Assertions.assertEquals((int)2, (int)this.getStylesCount(this.textPresentations.get(1)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(2)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(3)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(4)));
        Assertions.assertEquals((int)2, (int)this.getStylesCount(this.textPresentations.get(5)));
        Assertions.assertEquals((int)1, (int)this.getStylesCount(this.textPresentations.get(6)));
        StyleRange[] styles = viewer.getTextWidget().getStyleRanges();
        Assertions.assertEquals((int)13, (int)styles.length);
        pos = 0;
        len = 0;
        len = 9;
        Assertions.assertEquals((Object)this.textStyle(pos, 9, COLOR_1ST_LINE), (Object)styles[0]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_1ST_LINE), (Object)styles[1]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_1ST_LINE), (Object)styles[2]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.linkStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[3]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[4]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_3RD_LINE), (Object)styles[5]);
        pos += len;
        len = 10;
        Assertions.assertEquals((Object)this.textStyle(pos, 10, COLOR_3RD_LINE), (Object)styles[6]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_4TH_LINE), (Object)styles[7]);
        pos += len;
        len = 1;
        Assertions.assertEquals((Object)this.textStyle(pos, 1, COLOR_4TH_LINE), (Object)styles[8]);
        pos += len;
        len = 13;
        Assertions.assertEquals((Object)this.linkStyle(pos, 13, COLOR_6TH_LINE), (Object)styles[9]);
        pos += len;
        len = 9;
        Assertions.assertEquals((Object)this.textStyle(pos, 9, COLOR_8TH_LINE), (Object)styles[10]);
        pos += len;
        len = 6;
        Assertions.assertEquals((Object)this.linkStyle(pos, 6, COLOR_8TH_LINE), (Object)styles[11]);
        Assertions.assertEquals((Object)this.textStyle(pos += len, 9, COLOR_8TH_LINE), (Object)styles[12]);
    }

    private void waitForAndAssertTextPresentations(IDocument document) throws BadLocationException {
        TestUtils.waitForAndAssertCondition(1000, () -> this.textPresentations.size() == 7);
        Region linkRegion = this.linkRegion(0, document);
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(0).getExtent());
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(0).getCoverage());
        linkRegion = this.linkRegion(1, document);
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(1).getExtent());
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(1).getCoverage());
        linkRegion = this.linkRegion(2, document);
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(2).getExtent());
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(2).getCoverage());
        linkRegion = this.linkRegion(3, document);
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(3).getExtent());
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(3).getCoverage());
        linkRegion = this.linkRegion(4, document);
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(4).getExtent());
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(4).getCoverage());
        linkRegion = this.linkRegion(5, document);
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(5).getExtent());
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(5).getCoverage());
        linkRegion = this.linkRegion(6, document);
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(6).getExtent());
        Assertions.assertEquals((Object)linkRegion, (Object)this.textPresentations.get(6).getCoverage());
    }

    private int getStylesCount(TextPresentation presentation) {
        ArrayList list = new ArrayList(2);
        presentation.getAllStyleRangeIterator().forEachRemaining(list::add);
        return list.size();
    }

    private StyleRange textStyle(int start, int length, Color backgroundColor) {
        return new StyleRange(start, length, null, backgroundColor);
    }

    private StyleRange linkStyle(int start, int length, Color backgroundColor) {
        StyleRange retVal = new StyleRange(start, length, null, backgroundColor);
        retVal.underline = true;
        return retVal;
    }

    private Region linkRegion(int contentlinkPos, IDocument document) throws BadLocationException {
        DocumentLink link = CONTENT_LINKS.get(contentlinkPos);
        Position start = link.getRange().getStart();
        Position end = link.getRange().getEnd();
        int startOffset = document.getLineOffset(start.getLine()) + start.getCharacter();
        return new Region(startOffset, document.getLineOffset(end.getLine()) + end.getCharacter() - startOffset);
    }

    private void foldLines(int startLine, int endLine, ProjectionViewer viewer) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        int firstLineOffset = doc.getLineOffset(startLine);
        int lastLineEndOffset = doc.getLineOffset(endLine) + doc.getLineLength(endLine);
        viewer.getProjectionAnnotationModel().addAnnotation((Annotation)new ProjectionAnnotation(true), new org.eclipse.jface.text.Position(firstLineOffset, lastLineEndOffset - firstLineOffset));
    }

    private void textPresentationListener(TextPresentation textPresentation) {
        this.textPresentations.add(textPresentation);
    }
}

