/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import java.util.HashMap;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapter;

public class JSONUtility {
    private static final Gson LSP4J_GSON = new MessageJsonHandler(new HashMap()).getGson();
    private static final Gson EITHER_GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new EitherTypeAdapter.Factory()).create();

    private JSONUtility() {
    }

    public static <T> T toModel(Object object, Class<T> clazz) {
        return JSONUtility.toModel(JSONUtility.getLsp4jGson(), object, clazz);
    }

    public static <T> T toModel(Gson gson, Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class can not be null");
        }
        if (object instanceof JsonElement) {
            return (T)gson.fromJson((JsonElement)object, clazz);
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        return (T)gson.fromJson(gson.toJson(object), clazz);
    }

    public static Gson getLsp4jGson() {
        return LSP4J_GSON;
    }

    public static Gson getEitherGson() {
        return EITHER_GSON;
    }
}

