/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.security.RolesAllowed;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;

@RequestScoped
@Path(value="/endp")
public class AudienceValidationEndpoint {
    private static Logger log = Logger.getLogger("AudienceValidationEndpoint");
    @Inject
    @ConfigProperty(name="mp.jwt.verify.audiences")
    private Optional<String> audiences;
    @Inject
    @Claim(standard=Claims.aud)
    private ClaimValue<Optional<Set<String>>> aud;

    @PostConstruct
    private void init() {
        log.info(String.format("AudienceValidationEndpoint.init, aud: %s\n", this.aud));
    }

    @GET
    @Path(value="/verifyAudIsOk")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyAudIsOk() {
        String msg;
        boolean pass = false;
        if (!((Optional)this.aud.getValue()).isPresent()) {
            msg = "MP-JWT missing aud claim, or injection of claim failed";
        } else if (this.audiences.isPresent()) {
            Set claimAud = (Set)((Optional)this.aud.getValue()).get();
            Object[] configAud = this.audiences.get().split(",");
            boolean match = false;
            for (String oneAud : claimAud) {
                for (int j = 0; j < configAud.length; ++j) {
                    if (!oneAud.equals(configAud[j])) continue;
                    match = true;
                }
            }
            if (match) {
                msg = String.format("endpoint accessed with audiences(%s) = config.audiences(%s) as expected PASS", claimAud, Arrays.toString(configAud));
                pass = true;
            } else {
                msg = String.format("mp.jwt.verify.audiences(%s) != jwt.aud(%s)", Arrays.toString(configAud), claimAud);
            }
        } else {
            msg = "No mp.jwt.verify.audiences provided";
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }
}

