/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.logging.Logger;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckLRATypeTests
extends TckTestBase {
    private static final Logger LOGGER = Logger.getLogger(TckLRATypeTests.class.getName());

    @Deployment(name="lra-type-tck-tests")
    public static WebArchive deploy() {
        return TckLRATypeTests.deploy(TckLRATypeTests.class.getSimpleName().toLowerCase());
    }

    @Override
    @After
    public void after() {
        this.lraClient.cleanUp(LOGGER, this.testName.getMethodName());
    }

    @Test
    public void requiredWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/required", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void requiredWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/required", false, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void requiresNewWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/requires-new", true, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void requiresNewWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/requires-new", false, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void mandatoryWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/mandatory", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void mandatoryWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/mandatory", false, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void supportsWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/supports", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void supportsWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/supports", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedWithRA() {
        this.resourceRequest("lra-type-tck-resource", "/not-supported", true, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/not-supported", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/never", true, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithInvalidLRA() {
        this.neverWithInvalidLRA("lra-type-tck-resource", "/never");
    }

    @Test
    public void neverWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/never", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void requiredEndWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-required", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void requiredEndWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-required", false, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void requiresEndNewWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-requires-new", true, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void requiresEndNewWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-requires-new", false, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void mandatoryEndWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-mandatory", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void mandatoryEndWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-mandatory", false, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void supportsEndWithLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-supports", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void supportsEndWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-supports", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedEndWithRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-not-supported", true, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedEndWithoutLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-not-supported", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithEndLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-never", true, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithoutEndLRA() {
        this.resourceRequest("lra-type-tck-resource", "/end-never", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void requiredWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/required", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void requiredWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/required", false, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void requiresNewWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/requires-new", true, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void requiresNewWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/requires-new", false, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void mandatoryWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/mandatory", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void mandatoryWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/mandatory", false, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void supportsWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/supports", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void supportsWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/supports", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedWithRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/not-supported", true, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/not-supported", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/never", true, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithInvalidLRAAtInterface() {
        this.neverWithInvalidLRA("lra-type-tck-interface-resource", "/never");
    }

    @Test
    public void neverWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/never", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void requiredEndWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-required", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void requiredEndWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-required", false, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void requiresEndNewWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-requires-new", true, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void requiresEndNewWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-requires-new", false, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void mandatoryEndWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-mandatory", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void mandatoryEndWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-mandatory", false, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void supportsEndWithLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-supports", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void supportsEndWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-supports", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedEndWithRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-not-supported", true, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedEndWithoutLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-not-supported", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithEndLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-never", true, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithoutEndLRAAtInterface() {
        this.resourceRequest("lra-type-tck-interface-resource", "/end-never", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void requiredWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/required", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void requiredWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/required", false, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void requiresNewWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/requires-new", true, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void requiresNewWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/requires-new", false, 200, MethodLRACheck.NOT_EQUALS, false);
    }

    @Test
    public void mandatoryWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/mandatory", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void mandatoryWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/mandatory", false, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void supportsWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/supports", true, 200, MethodLRACheck.EQUALS, false);
    }

    @Test
    public void supportsWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/supports", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedWithRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/not-supported", true, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/not-supported", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/never", true, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithInvalidLRAAtSuperclass() {
        this.neverWithInvalidLRA("lra-type-tck-superclass-resource", "/never");
    }

    @Test
    public void neverWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/never", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void requiredEndWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-required", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void requiredEndWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-required", false, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void requiresEndNewWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-requires-new", true, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void requiresEndNewWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-requires-new", false, 200, MethodLRACheck.NOT_EQUALS, true);
    }

    @Test
    public void mandatoryEndWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-mandatory", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void mandatoryEndWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-mandatory", false, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void supportsEndWithLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-supports", true, 200, MethodLRACheck.EQUALS, true);
    }

    @Test
    public void supportsEndWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-supports", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedEndWithRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-not-supported", true, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void notSupportedEndWithoutLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-not-supported", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithEndLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-never", true, 412, MethodLRACheck.NOT_PRESENT, false);
    }

    @Test
    public void neverWithoutEndLRAAtSuperclass() {
        this.resourceRequest("lra-type-tck-superclass-resource", "/end-never", false, 200, MethodLRACheck.NOT_PRESENT, false);
    }

    private void neverWithInvalidLRA(String rootPath, String path) {
        this.resourceRequest(rootPath, path, true, 412, MethodLRACheck.NOT_PRESENT, false);
        Invocation.Builder target = this.tckSuiteTarget.path(rootPath).path(path).request();
        target = target.header("Long-Running-Action", (Object)"http://something/like/an/URI");
        Response response = target.get();
        Assert.assertEquals((String)(this.testName.getMethodName() + ": Unexpected status"), (long)412L, (long)response.getStatus());
        response.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resourceRequest(String rootPath, String path, boolean startLRA, int expectedStatus, MethodLRACheck lraCheckType, boolean methodLRAShouldBeActive) {
        URI lra;
        Invocation.Builder target = this.tckSuiteTarget.path(rootPath).path(path).request();
        URI uRI = lra = startLRA ? this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS) : null;
        if (lra != null) {
            target = target.header("Long-Running-Action", lra);
        }
        try (Response response = target.get();){
            String methodLraId;
            String incomingLraId = lra == null ? "" : lra.toASCIIString();
            Assert.assertEquals((String)(this.testName.getMethodName() + ": Unexpected status"), (long)expectedStatus, (long)response.getStatus());
            if (response.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                lraCheckType = MethodLRACheck.NONE;
                methodLRAShouldBeActive = false;
                methodLraId = "";
            } else {
                methodLraId = (String)response.readEntity(String.class);
            }
            switch (lraCheckType) {
                case NOT_PRESENT: {
                    Assert.assertEquals((String)(this.testName.getMethodName() + ": Resource method should not have run with an LRA: " + methodLraId), (long)0L, (long)methodLraId.length());
                    break;
                }
                case EQUALS: {
                    Assert.assertEquals((String)(this.testName.getMethodName() + ": Resource method should have ran with the incoming LRA"), (Object)incomingLraId, (Object)methodLraId);
                    break;
                }
                case NOT_EQUALS: {
                    Assert.assertNotEquals((String)(this.testName.getMethodName() + ": Resource method should not have run with the incoming LRA"), (Object)incomingLraId, (Object)methodLraId);
                    break;
                }
            }
            if (methodLRAShouldBeActive) {
                Assert.assertNotEquals((String)(this.testName.getMethodName() + ": Resource method should not have run with an LRA: " + methodLraId), (long)0L, (long)methodLraId.length());
                Assert.assertFalse((boolean)this.lraTestService.isLRAFinished(URI.create(methodLraId)));
                this.lraClient.closeLRA(methodLraId);
            } else if (methodLraId.length() != 0) {
                Assert.assertTrue((boolean)this.lraTestService.isLRAFinished(URI.create(methodLraId)));
            }
            if (lra != null) {
                this.lraClient.closeLRA(lra);
            }
            String string = methodLraId;
            return string;
        }
    }

    private static enum MethodLRACheck {
        NONE,
        NOT_PRESENT,
        EQUALS,
        NOT_EQUALS;

    }
}

