/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.participant.api.Scenario;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
@Path(value="lraUnknownStatusController")
public class LRAUnknownStatusResource {
    public static final String LRA_CONTROLLER_PATH = "lraUnknownStatusController";
    public static final String TRANSACTIONAL_WORK_PATH = "work";
    private static final Logger LOGGER = Logger.getLogger(LRAUnknownStatusResource.class.getName());
    private static final String AFTER_LRA = "/after";
    private Map<String, Scenario> scenarioMap = new HashMap<String, Scenario>();
    @Inject
    private LRAMetricService lraMetricService;

    @PUT
    @Path(value="work")
    @LRA
    public Response activityWithLRA(@HeaderParam(value="Long-Running-Action") URI lraId, @QueryParam(value="scenario") Scenario scenario) {
        this.scenarioMap.put(lraId.toASCIIString(), scenario);
        return Response.status((int)scenario.getPathResponseCode()).entity((Object)lraId).build();
    }

    @PUT
    @Path(value="/complete")
    @Produces(value={"application/json"})
    @Complete
    public Response completeWork(@HeaderParam(value="Long-Running-Action") URI lraId) throws NotFoundException {
        this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, LRAUnknownStatusResource.class);
        int responseCode = 410;
        Scenario scenario = this.scenarioMap.get(lraId.toASCIIString());
        if (scenario == Scenario.COMPLETE_RETRY) {
            responseCode = 202;
            this.scenarioMap.remove(lraId.toASCIIString());
        }
        LOGGER.info(String.format("LRA id '%s' was completed", lraId.toASCIIString()));
        return Response.status((int)responseCode).build();
    }

    @PUT
    @Path(value="/compensate")
    @Produces(value={"application/json"})
    @Compensate
    public Response compensateWork(@HeaderParam(value="Long-Running-Action") URI lraId) throws NotFoundException {
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, LRAUnknownStatusResource.class);
        int responseCode = 410;
        Scenario scenario = this.scenarioMap.get(lraId.toASCIIString());
        if (scenario == Scenario.COMPENSATE_RETRY) {
            responseCode = 202;
            this.scenarioMap.remove(lraId.toASCIIString());
        }
        LOGGER.info(String.format("LRA id '%s' was compensated", lraId));
        return Response.status((int)responseCode).build();
    }

    @GET
    @Path(value="/status")
    @Status
    public Response status(@HeaderParam(value="Long-Running-Action") URI lraId) {
        this.lraMetricService.incrementMetric(LRAMetricType.Status, lraId, LRAUnknownStatusResource.class);
        return Response.status((int)410).build();
    }

    @PUT
    @Path(value="/after")
    @AfterLRA
    public Response afterEnd(@HeaderParam(value="Long-Running-Action-Ended") URI lraId, LRAStatus status) {
        this.lraMetricService.incrementMetric(LRAMetricType.AfterLRA, lraId, LRAUnknownStatusResource.class);
        switch (status) {
            case Closed: 
            case Cancelled: 
            case FailedToCancel: 
            case FailedToClose: {
                this.lraMetricService.incrementMetric(LRAMetricType.valueOf(status.name()), lraId, LRAUnknownStatusResource.class);
                return Response.ok().build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }
}

