/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseToStringVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.AddStatement;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.BufferStatement;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.LoopParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatementPart;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.SpeculateStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.VariableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTimperativeToStringVisitor
extends QVTbaseToStringVisitor
implements QVTimperativeVisitor<String> {
    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ToStringVisitor.Factory FACTORY = new QVTimperativeToStringFactory();

    public QVTimperativeToStringVisitor(@NonNull StringBuilder s) {
        super(s);
    }

    @Override
    public @Nullable String visitAddStatement(@NonNull AddStatement asAddStatement) {
        this.append("add ");
        this.appendName((Nameable)asAddStatement.getTargetVariable());
        this.append(" += ");
        this.safeVisit((Visitable)asAddStatement.getOwnedExpression());
        return null;
    }

    @Override
    public @Nullable String visitAppendParameter(@NonNull AppendParameter asVariable) {
        this.append("append ");
        this.appendName((Nameable)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)asVariable);
        }
        return null;
    }

    @Override
    public @Nullable String visitAppendParameterBinding(@NonNull AppendParameterBinding object) {
        this.appendName((Nameable)object.getBoundVariable());
        this.append(" appendsTo ");
        this.appendName((Nameable)object.getValue());
        return null;
    }

    @Override
    public @Nullable String visitBufferStatement(@NonNull BufferStatement asVariable) {
        if (asVariable.isIsStrict()) {
            ((StringBuilder)this.context).append("\u00abstrict\u00bb");
        }
        this.append("buffer ");
        this.appendName((Nameable)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)asVariable);
        }
        return null;
    }

    @Override
    public @Nullable String visitCheckStatement(@NonNull CheckStatement object) {
        this.append("check ");
        this.safeVisit((Visitable)object.getOwnedExpression());
        return null;
    }

    @Override
    public @Nullable String visitConnectionVariable(@NonNull ConnectionVariable asVariable) {
        this.appendName((Nameable)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)asVariable);
        }
        return null;
    }

    @Override
    public @Nullable String visitDeclareStatement(@NonNull DeclareStatement asVariable) {
        OCLExpression asInit;
        if (asVariable.isIsCheck()) {
            this.append("check ");
        }
        this.append("var ");
        this.appendName((Nameable)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)asVariable);
        }
        if ((asInit = asVariable.getOwnedExpression()) != null) {
            this.append(" := ");
            this.safeVisit((Visitable)asInit);
        }
        return null;
    }

    @Override
    public @Nullable String visitEntryPoint(@NonNull EntryPoint asEntryPoint) {
        return this.visitMapping(asEntryPoint);
    }

    @Override
    public @Nullable String visitGuardParameter(@NonNull GuardParameter asVariable) {
        this.append("guard ");
        this.appendName((Nameable)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)asVariable);
        }
        return null;
    }

    @Override
    public @Nullable String visitGuardParameterBinding(@NonNull GuardParameterBinding object) {
        if (object.isIsCheck()) {
            this.append("check ");
        }
        this.appendName((Nameable)object.getBoundVariable());
        this.append(" consumes ");
        this.safeVisit((Visitable)object.getValue());
        return null;
    }

    @Override
    public @Nullable String visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visitModel((Model)object);
    }

    @Override
    public @Nullable String visitImperativeTransformation(@NonNull ImperativeTransformation object) {
        return this.visitTransformation(object);
    }

    @Override
    public @Nullable String visitLoopParameterBinding(@NonNull LoopParameterBinding object) {
        if (object.isIsCheck()) {
            this.append("check ");
        }
        this.appendName((Nameable)object.getBoundVariable());
        this.append(" iterates ");
        this.safeVisit((Visitable)object.getValue());
        return null;
    }

    @Override
    public @Nullable String visitLoopVariable(@NonNull LoopVariable asVariable) {
        this.appendName((Nameable)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)asVariable);
        }
        return null;
    }

    @Override
    public @Nullable String visitMapping(@NonNull Mapping asMapping) {
        if (asMapping.isIsStrict()) {
            ((StringBuilder)this.context).append("\u00abstrict\u00bb");
        }
        this.appendQualifiedName((NamedElement)asMapping);
        return null;
    }

    @Override
    public @Nullable String visitMappingCall(@NonNull MappingCall object) {
        if (object.isIsInstall()) {
            this.append("\u00abinstall\u00bb");
        }
        this.appendQualifiedName((NamedElement)object.getReferredMapping());
        this.append(" {");
        boolean isFirst = true;
        for (MappingParameterBinding binding : QVTimperativeUtil.getOwnedMappingParameterBindings(object)) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit((Visitable)binding);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public @Nullable String visitMappingLoop(@NonNull MappingLoop object) {
        boolean isFirst = true;
        for (LoopVariable iterator : object.getOwnedIterators()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.appendName((Nameable)iterator);
            isFirst = false;
        }
        this.append(" := ");
        this.safeVisit((Visitable)object.getOwnedExpression());
        return null;
    }

    @Override
    public @Nullable String visitMappingParameter(@NonNull MappingParameter object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable String visitMappingParameterBinding(@NonNull MappingParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable String visitMappingStatement(@NonNull MappingStatement object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public String visitNewStatement(@NonNull NewStatement newStatement) {
        OCLExpression initExpression;
        if (newStatement.isIsContained()) {
            ((StringBuilder)this.context).append("contained ");
        }
        this.append("new:");
        this.appendName((Nameable)newStatement.getReferredTypedModel());
        this.append(" ");
        this.appendName((Nameable)newStatement);
        Type type = newStatement.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)newStatement);
        }
        if (newStatement.eIsSet((EStructuralFeature)QVTimperativePackage.Literals.NEW_STATEMENT__OWNED_PARTS)) {
            this.append(" {");
            boolean isFirst = true;
            for (NewStatementPart part : newStatement.getOwnedParts()) {
                if (!isFirst) {
                    this.append(", ");
                }
                this.safeVisit((Visitable)part);
                isFirst = false;
            }
            this.append("}");
        }
        if ((initExpression = newStatement.getOwnedExpression()) != null) {
            this.append(" = ");
            this.safeVisit((Visitable)initExpression);
        }
        return null;
    }

    @Override
    public @Nullable String visitNewStatementPart(@NonNull NewStatementPart newStatementPart) {
        this.appendName((Nameable)newStatementPart.getReferredProperty());
        this.append(" = ");
        this.safeVisit((Visitable)newStatementPart.getOwnedExpression());
        return null;
    }

    @Override
    public @Nullable String visitObservableStatement(@NonNull ObservableStatement object) {
        return null;
    }

    @Override
    public String visitSetStatement(@NonNull SetStatement asSetStatement) {
        if (asSetStatement.isIsNotify()) {
            this.append("notify ");
        }
        this.append("set ");
        this.appendName((Nameable)asSetStatement.getTargetVariable());
        this.append(".");
        if (asSetStatement.isIsOpposite()) {
            this.append("~");
        }
        this.appendName((Nameable)asSetStatement.getTargetProperty());
        this.append(" := ");
        this.safeVisit((Visitable)asSetStatement.getOwnedExpression());
        return null;
    }

    @Override
    public @Nullable String visitSimpleParameter(@NonNull SimpleParameter asVariable) {
        this.append("in ");
        this.appendName((Nameable)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType((TypedElement)asVariable);
        }
        return null;
    }

    @Override
    public @Nullable String visitSimpleParameterBinding(@NonNull SimpleParameterBinding object) {
        if (object.isIsCheck()) {
            this.append("check ");
        }
        this.appendName((Nameable)object.getBoundVariable());
        this.append(" uses ");
        this.safeVisit((Visitable)object.getValue());
        return null;
    }

    @Override
    public @Nullable String visitSpeculateStatement(@NonNull SpeculateStatement object) {
        this.append("speculate ");
        boolean isFirst = true;
        for (OCLExpression expression : QVTimperativeUtil.getOwnedExpressions(object)) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit((Visitable)expression);
            isFirst = false;
        }
        return null;
    }

    @Override
    public @Nullable String visitStatement(@NonNull Statement object) {
        return null;
    }

    @Override
    public @Nullable String visitVariableStatement(@NonNull VariableStatement object) {
        return null;
    }

    protected static class QVTimperativeToStringFactory
    implements ToStringVisitor.Factory {
        protected QVTimperativeToStringFactory() {
            ToStringVisitor.addFactory((ToStringVisitor.Factory)this);
            QVTbaseToStringVisitor.FACTORY.getClass();
        }

        public @NonNull ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
            return new QVTimperativeToStringVisitor(s);
        }

        public @NonNull EPackage getEPackage() {
            QVTimperativePackage eInstance = QVTimperativePackage.eINSTANCE;
            assert (eInstance != null);
            return eInstance;
        }
    }
}

