/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.usage;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.usage.AbstractDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.CompoundTargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionBody;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.SimpleTargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Target;
import org.eclipse.qvtd.pivot.qvtbase.TargetElement;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.util.QVTbaseVisitor;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;

public abstract class AbstractBaseDomainUsageAnalysis
extends AbstractDomainUsageAnalysis
implements QVTbaseVisitor<DomainUsage> {
    protected AbstractBaseDomainUsageAnalysis(@NonNull EnvironmentFactory environmentFactory, @NonNull ProblemHandler problemHandler) {
        super(environmentFactory, problemHandler);
    }

    protected @NonNull DomainUsage getDomainUsage(@Nullable EObject object) {
        Domain domain = QVTbaseUtil.basicGetContainingDomain((EObject)object);
        if (domain != null) {
            return this.visit((Element)domain.getTypedModel());
        }
        return this.getRootAnalysis().getMiddleUsage();
    }

    public @NonNull DomainUsage visitBaseModel(@NonNull BaseModel object) {
        return (DomainUsage)this.visitModel((Model)object);
    }

    public @NonNull DomainUsage visitCompoundTargetElement(@NonNull CompoundTargetElement object) {
        return this.visitTargetElement((TargetElement)object);
    }

    public @NonNull DomainUsage visitDomain(@NonNull Domain object) {
        return (DomainUsage)this.visitNamedElement((NamedElement)object);
    }

    public @NonNull DomainUsage visitFunction(@NonNull Function object) {
        for (Parameter parameter : QVTbaseUtil.getOwnedParameters((Operation)object)) {
            this.visit((Element)parameter);
        }
        OCLExpression queryExpression = object.getQueryExpression();
        if (queryExpression != null) {
            return this.visit((Element)queryExpression);
        }
        return this.visit((Element)object.getType());
    }

    public @NonNull DomainUsage visitFunctionBody(@NonNull FunctionBody object) {
        return this.visitExpressionInOCL((ExpressionInOCL)object);
    }

    public @NonNull DomainUsage visitFunctionParameter(@NonNull FunctionParameter object) {
        return this.visitParameter((Parameter)object);
    }

    public @NonNull DomainUsage visitPattern(@NonNull Pattern object) {
        return (DomainUsage)this.visitElement((Element)object);
    }

    public @NonNull DomainUsage visitPredicate(@NonNull Predicate object) {
        return this.visit((Element)object.getConditionExpression());
    }

    public @NonNull DomainUsage visitRule(@NonNull Rule object) {
        RootDomainUsageAnalysis rootAnalysis = this.getRootAnalysis();
        DomainUsage ruleUsage = this.union((DomainUsage)rootAnalysis.getPrimitiveUsage(), (DomainUsage)rootAnalysis.getThisUsage());
        ruleUsage = this.union(ruleUsage, rootAnalysis.getMiddleUsage());
        for (Domain domain : QVTbaseUtil.getOwnedDomains((Rule)object)) {
            DomainUsage domainUsage = this.visit((Element)QVTbaseUtil.getTypedModel((Domain)domain));
            ruleUsage = this.union(ruleUsage, domainUsage);
        }
        this.setUsage((Element)object, ruleUsage);
        for (Domain domain : object.getDomain()) {
            this.visit((Element)domain);
        }
        return ruleUsage;
    }

    public @NonNull DomainUsage visitSimpleTargetElement(@NonNull SimpleTargetElement object) {
        return this.visitTargetElement((TargetElement)object);
    }

    public @NonNull DomainUsage visitTarget(@NonNull Target object) {
        return (DomainUsage)this.visitNamedElement((NamedElement)object);
    }

    public @NonNull DomainUsage visitTargetElement(@NonNull TargetElement object) {
        return (DomainUsage)this.visitElement((Element)object);
    }

    public @NonNull DomainUsage visitTransformation(@NonNull Transformation object) {
        return this.getRootAnalysis().getThisUsage();
    }

    public @NonNull DomainUsage visitTypedModel(@NonNull TypedModel object) {
        RootDomainUsageAnalysis rootAnalysis = this.getRootAnalysis();
        if (rootAnalysis != this) {
            return (DomainUsage)ClassUtil.nonNullState((Object)rootAnalysis.basicGetUsage((Element)object));
        }
        return (DomainUsage)ClassUtil.nonNullState((Object)((DomainUsage)this.element2usage.get(object)));
    }
}

