/*******************************************************************************
 * Copyright (c) 2019 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/**
 * generated by Xtext 2.16.0
 */
package org.eclipse.qvtd.doc.minioclcs;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.qvtd.doc.minioclcs.MinioclcsFactory
 * @model kind="package"
 * @generated
 */
public interface MinioclcsPackage extends EPackage
{
  /**
	 * The package name.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  String eNAME = "minioclcs";

  /**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  String eNS_URI = "http://www.eclipse.org/qvtd/doc/MiniOCLCS";

  /**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  String eNS_PREFIX = "minioclcs";

  /**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  MinioclcsPackage eINSTANCE = org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl.init();

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CSTraceImpl <em>CS Trace</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.CSTraceImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCSTrace()
	 * @generated
	 */
	int CS_TRACE = 34;

		/**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CS_TRACE__AST = 0;

		/**
	 * The number of structural features of the '<em>CS Trace</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CS_TRACE_FEATURE_COUNT = 1;

		/**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.RootCSImpl <em>Root CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.RootCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getRootCS()
	 * @generated
	 */
  int ROOT_CS = 0;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROOT_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Imports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ROOT_CS__IMPORTS = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Packages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ROOT_CS__PACKAGES = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ROOT_CS__CONSTRAINTS = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The number of structural features of the '<em>Root CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ROOT_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ImportCSImpl <em>Import CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.ImportCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getImportCS()
	 * @generated
	 */
  int IMPORT_CS = 1;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPORT_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int IMPORT_CS__ALIAS = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Uri</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int IMPORT_CS__URI = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Import CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int IMPORT_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PackageCSImpl <em>Package CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.PackageCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPackageCS()
	 * @generated
	 */
  int PACKAGE_CS = 2;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGE_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PACKAGE_CS__NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Packages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PACKAGE_CS__PACKAGES = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PACKAGE_CS__CLASSES = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The number of structural features of the '<em>Package CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PACKAGE_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ClassCSImpl <em>Class CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.ClassCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getClassCS()
	 * @generated
	 */
  int CLASS_CS = 3;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CLASS_CS__NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Extends</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CLASS_CS__EXTENDS = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CLASS_CS__PROPERTIES = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CLASS_CS__OPERATIONS = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The number of structural features of the '<em>Class CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CLASS_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 4;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PropertyCSImpl <em>Property CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.PropertyCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPropertyCS()
	 * @generated
	 */
  int PROPERTY_CS = 4;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROPERTY_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PROPERTY_CS__NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Type Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PROPERTY_CS__TYPE_REF = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Multiplicity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PROPERTY_CS__MULTIPLICITY = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The number of structural features of the '<em>Property CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PROPERTY_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.MultiplicityCSImpl <em>Multiplicity CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MultiplicityCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getMultiplicityCS()
	 * @generated
	 */
  int MULTIPLICITY_CS = 5;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Opt</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int MULTIPLICITY_CS__OPT = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Mult</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int MULTIPLICITY_CS__MULT = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Mandatory</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int MULTIPLICITY_CS__MANDATORY = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The feature id for the '<em><b>Lower Int</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int MULTIPLICITY_CS__LOWER_INT = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The feature id for the '<em><b>Upper Int</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int MULTIPLICITY_CS__UPPER_INT = CS_TRACE_FEATURE_COUNT + 4;

  /**
	 * The feature id for the '<em><b>Upper Mult</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int MULTIPLICITY_CS__UPPER_MULT = CS_TRACE_FEATURE_COUNT + 5;

  /**
	 * The number of structural features of the '<em>Multiplicity CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int MULTIPLICITY_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 6;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.OperationCSImpl <em>Operation CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.OperationCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getOperationCS()
	 * @generated
	 */
  int OPERATION_CS = 6;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int OPERATION_CS__NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Params</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int OPERATION_CS__PARAMS = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Result Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int OPERATION_CS__RESULT_REF = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int OPERATION_CS__BODY = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The number of structural features of the '<em>Operation CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int OPERATION_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 4;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ParameterCSImpl <em>Parameter CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.ParameterCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getParameterCS()
	 * @generated
	 */
  int PARAMETER_CS = 7;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PARAMETER_CS__NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Type Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PARAMETER_CS__TYPE_REF = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Parameter CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PARAMETER_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ConstraintsDefCSImpl <em>Constraints Def CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.ConstraintsDefCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getConstraintsDefCS()
	 * @generated
	 */
  int CONSTRAINTS_DEF_CS = 8;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINTS_DEF_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Type Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CONSTRAINTS_DEF_CS__TYPE_REF = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Invariants</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CONSTRAINTS_DEF_CS__INVARIANTS = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Constraints Def CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CONSTRAINTS_DEF_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.InvariantCSImpl <em>Invariant CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.InvariantCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getInvariantCS()
	 * @generated
	 */
  int INVARIANT_CS = 9;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INVARIANT_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INVARIANT_CS__EXP = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The number of structural features of the '<em>Invariant CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INVARIANT_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ExpCSImpl <em>Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.ExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getExpCS()
	 * @generated
	 */
  int EXP_CS = 10;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXP_CS__AST = CS_TRACE__AST;

		/**
	 * The number of structural features of the '<em>Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int EXP_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.EqualityExpCSImpl <em>Equality Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.EqualityExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getEqualityExpCS()
	 * @generated
	 */
  int EQUALITY_EXP_CS = 11;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUALITY_EXP_CS__AST = EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int EQUALITY_EXP_CS__LEFT = EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int EQUALITY_EXP_CS__OP_NAME = EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int EQUALITY_EXP_CS__RIGHT = EXP_CS_FEATURE_COUNT + 2;

  /**
	 * The number of structural features of the '<em>Equality Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int EQUALITY_EXP_CS_FEATURE_COUNT = EXP_CS_FEATURE_COUNT + 3;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CallExpCSImpl <em>Call Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.CallExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCallExpCS()
	 * @generated
	 */
  int CALL_EXP_CS = 12;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CALL_EXP_CS__AST = EQUALITY_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CALL_EXP_CS__LEFT = EQUALITY_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CALL_EXP_CS__OP_NAME = EQUALITY_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CALL_EXP_CS__RIGHT = EQUALITY_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CALL_EXP_CS__SOURCE = EQUALITY_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CALL_EXP_CS__NAV_EXP = EQUALITY_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Call Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int CALL_EXP_CS_FEATURE_COUNT = EQUALITY_EXP_CS_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PrimaryExpCSImpl <em>Primary Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.PrimaryExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPrimaryExpCS()
	 * @generated
	 */
  int PRIMARY_EXP_CS = 13;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMARY_EXP_CS__AST = CALL_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PRIMARY_EXP_CS__LEFT = CALL_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PRIMARY_EXP_CS__OP_NAME = CALL_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PRIMARY_EXP_CS__RIGHT = CALL_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PRIMARY_EXP_CS__SOURCE = CALL_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PRIMARY_EXP_CS__NAV_EXP = CALL_EXP_CS__NAV_EXP;

  /**
	 * The number of structural features of the '<em>Primary Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PRIMARY_EXP_CS_FEATURE_COUNT = CALL_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.SelfExpCSImpl <em>Self Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.SelfExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getSelfExpCS()
	 * @generated
	 */
  int SELF_EXP_CS = 14;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SELF_EXP_CS__AST = PRIMARY_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int SELF_EXP_CS__LEFT = PRIMARY_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int SELF_EXP_CS__OP_NAME = PRIMARY_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int SELF_EXP_CS__RIGHT = PRIMARY_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int SELF_EXP_CS__SOURCE = PRIMARY_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int SELF_EXP_CS__NAV_EXP = PRIMARY_EXP_CS__NAV_EXP;

  /**
	 * The number of structural features of the '<em>Self Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int SELF_EXP_CS_FEATURE_COUNT = PRIMARY_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.NavigationExpCSImpl <em>Navigation Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.NavigationExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getNavigationExpCS()
	 * @generated
	 */
  int NAVIGATION_EXP_CS = 15;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAVIGATION_EXP_CS__AST = CS_TRACE__AST;

		/**
	 * The number of structural features of the '<em>Navigation Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAVIGATION_EXP_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LoopExpCSImpl <em>Loop Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.LoopExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLoopExpCS()
	 * @generated
	 */
  int LOOP_EXP_CS = 16;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_EXP_CS__AST = NAVIGATION_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>It Var</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LOOP_EXP_CS__IT_VAR = NAVIGATION_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LOOP_EXP_CS__EXP = NAVIGATION_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Loop Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LOOP_EXP_CS_FEATURE_COUNT = NAVIGATION_EXP_CS_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CollectExpCSImpl <em>Collect Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.CollectExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectExpCS()
	 * @generated
	 */
  int COLLECT_EXP_CS = 17;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECT_EXP_CS__AST = LOOP_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>It Var</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECT_EXP_CS__IT_VAR = LOOP_EXP_CS__IT_VAR;

  /**
	 * The feature id for the '<em><b>Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECT_EXP_CS__EXP = LOOP_EXP_CS__EXP;

  /**
	 * The number of structural features of the '<em>Collect Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECT_EXP_CS_FEATURE_COUNT = LOOP_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.IteratorVarCSImpl <em>Iterator Var CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.IteratorVarCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getIteratorVarCS()
	 * @generated
	 */
  int ITERATOR_VAR_CS = 18;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATOR_VAR_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>It Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ITERATOR_VAR_CS__IT_NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>It Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ITERATOR_VAR_CS__IT_TYPE = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Iterator Var CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ITERATOR_VAR_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.IterateExpCSImpl <em>Iterate Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.IterateExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getIterateExpCS()
	 * @generated
	 */
  int ITERATE_EXP_CS = 19;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ITERATE_EXP_CS__AST = LOOP_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>It Var</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ITERATE_EXP_CS__IT_VAR = LOOP_EXP_CS__IT_VAR;

  /**
	 * The feature id for the '<em><b>Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ITERATE_EXP_CS__EXP = LOOP_EXP_CS__EXP;

  /**
	 * The feature id for the '<em><b>Acc Var</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ITERATE_EXP_CS__ACC_VAR = LOOP_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The number of structural features of the '<em>Iterate Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ITERATE_EXP_CS_FEATURE_COUNT = LOOP_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.AccVarCSImpl <em>Acc Var CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.AccVarCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getAccVarCS()
	 * @generated
	 */
  int ACC_VAR_CS = 20;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACC_VAR_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Acc Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ACC_VAR_CS__ACC_NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Acc Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ACC_VAR_CS__ACC_TYPE = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Acc Init Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ACC_VAR_CS__ACC_INIT_EXP = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The number of structural features of the '<em>Acc Var CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ACC_VAR_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.NameExpCSImpl <em>Name Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.NameExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getNameExpCS()
	 * @generated
	 */
  int NAME_EXP_CS = 21;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAME_EXP_CS__AST = PRIMARY_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS__LEFT = PRIMARY_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS__OP_NAME = PRIMARY_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS__RIGHT = PRIMARY_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS__SOURCE = PRIMARY_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS__NAV_EXP = PRIMARY_EXP_CS__NAV_EXP;

  /**
	 * The feature id for the '<em><b>Exp Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS__EXP_NAME = PRIMARY_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Rounded Brackets</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS__ROUNDED_BRACKETS = PRIMARY_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Name Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NAME_EXP_CS_FEATURE_COUNT = PRIMARY_EXP_CS_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.RoundedBracketClauseCSImpl <em>Rounded Bracket Clause CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.RoundedBracketClauseCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getRoundedBracketClauseCS()
	 * @generated
	 */
  int ROUNDED_BRACKET_CLAUSE_CS = 22;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROUNDED_BRACKET_CLAUSE_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Args</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ROUNDED_BRACKET_CLAUSE_CS__ARGS = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The number of structural features of the '<em>Rounded Bracket Clause CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int ROUNDED_BRACKET_CLAUSE_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LiteralExpCSImpl <em>Literal Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.LiteralExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLiteralExpCS()
	 * @generated
	 */
  int LITERAL_EXP_CS = 23;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LITERAL_EXP_CS__AST = PRIMARY_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LITERAL_EXP_CS__LEFT = PRIMARY_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LITERAL_EXP_CS__OP_NAME = PRIMARY_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LITERAL_EXP_CS__RIGHT = PRIMARY_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LITERAL_EXP_CS__SOURCE = PRIMARY_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LITERAL_EXP_CS__NAV_EXP = PRIMARY_EXP_CS__NAV_EXP;

  /**
	 * The number of structural features of the '<em>Literal Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LITERAL_EXP_CS_FEATURE_COUNT = PRIMARY_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.IntLiteralExpCSImpl <em>Int Literal Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.IntLiteralExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getIntLiteralExpCS()
	 * @generated
	 */
  int INT_LITERAL_EXP_CS = 24;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LITERAL_EXP_CS__AST = LITERAL_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INT_LITERAL_EXP_CS__LEFT = LITERAL_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INT_LITERAL_EXP_CS__OP_NAME = LITERAL_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INT_LITERAL_EXP_CS__RIGHT = LITERAL_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INT_LITERAL_EXP_CS__SOURCE = LITERAL_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INT_LITERAL_EXP_CS__NAV_EXP = LITERAL_EXP_CS__NAV_EXP;

  /**
	 * The feature id for the '<em><b>Int Symbol</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INT_LITERAL_EXP_CS__INT_SYMBOL = LITERAL_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The number of structural features of the '<em>Int Literal Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int INT_LITERAL_EXP_CS_FEATURE_COUNT = LITERAL_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.BooleanLiteralExpCSImpl <em>Boolean Literal Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.BooleanLiteralExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getBooleanLiteralExpCS()
	 * @generated
	 */
  int BOOLEAN_LITERAL_EXP_CS = 25;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_LITERAL_EXP_CS__AST = LITERAL_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_LITERAL_EXP_CS__LEFT = LITERAL_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_LITERAL_EXP_CS__OP_NAME = LITERAL_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_LITERAL_EXP_CS__RIGHT = LITERAL_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_LITERAL_EXP_CS__SOURCE = LITERAL_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_LITERAL_EXP_CS__NAV_EXP = LITERAL_EXP_CS__NAV_EXP;

  /**
	 * The number of structural features of the '<em>Boolean Literal Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_LITERAL_EXP_CS_FEATURE_COUNT = LITERAL_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.NullLiteralExpCSImpl <em>Null Literal Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.NullLiteralExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getNullLiteralExpCS()
	 * @generated
	 */
  int NULL_LITERAL_EXP_CS = 26;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NULL_LITERAL_EXP_CS__AST = LITERAL_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NULL_LITERAL_EXP_CS__LEFT = LITERAL_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NULL_LITERAL_EXP_CS__OP_NAME = LITERAL_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NULL_LITERAL_EXP_CS__RIGHT = LITERAL_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NULL_LITERAL_EXP_CS__SOURCE = LITERAL_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NULL_LITERAL_EXP_CS__NAV_EXP = LITERAL_EXP_CS__NAV_EXP;

  /**
	 * The number of structural features of the '<em>Null Literal Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int NULL_LITERAL_EXP_CS_FEATURE_COUNT = LITERAL_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralExpCSImpl <em>Collection Literal Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectionLiteralExpCS()
	 * @generated
	 */
  int COLLECTION_LITERAL_EXP_CS = 27;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_LITERAL_EXP_CS__AST = LITERAL_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS__LEFT = LITERAL_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS__OP_NAME = LITERAL_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS__RIGHT = LITERAL_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS__SOURCE = LITERAL_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS__NAV_EXP = LITERAL_EXP_CS__NAV_EXP;

  /**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS__KIND = LITERAL_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Parts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS__PARTS = LITERAL_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Collection Literal Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_EXP_CS_FEATURE_COUNT = LITERAL_EXP_CS_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralPartCSImpl <em>Collection Literal Part CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralPartCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectionLiteralPartCS()
	 * @generated
	 */
  int COLLECTION_LITERAL_PART_CS = 28;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLLECTION_LITERAL_PART_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>First</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_PART_CS__FIRST = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Last</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_PART_CS__LAST = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Collection Literal Part CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int COLLECTION_LITERAL_PART_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LetExpCSImpl <em>Let Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.LetExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLetExpCS()
	 * @generated
	 */
  int LET_EXP_CS = 29;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LET_EXP_CS__AST = PRIMARY_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS__LEFT = PRIMARY_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS__OP_NAME = PRIMARY_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS__RIGHT = PRIMARY_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS__SOURCE = PRIMARY_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS__NAV_EXP = PRIMARY_EXP_CS__NAV_EXP;

  /**
	 * The feature id for the '<em><b>Let Vars</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS__LET_VARS = PRIMARY_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>In Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS__IN_EXP = PRIMARY_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The number of structural features of the '<em>Let Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_EXP_CS_FEATURE_COUNT = PRIMARY_EXP_CS_FEATURE_COUNT + 2;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LetVarCSImpl <em>Let Var CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.LetVarCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLetVarCS()
	 * @generated
	 */
  int LET_VAR_CS = 30;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LET_VAR_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_VAR_CS__NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The feature id for the '<em><b>Type Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_VAR_CS__TYPE_REF = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The feature id for the '<em><b>Init Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_VAR_CS__INIT_EXP = CS_TRACE_FEATURE_COUNT + 2;

  /**
	 * The number of structural features of the '<em>Let Var CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int LET_VAR_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 3;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PathNameCSImpl <em>Path Name CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.PathNameCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPathNameCS()
	 * @generated
	 */
  int PATH_NAME_CS = 31;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_NAME_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Path Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PATH_NAME_CS__PATH_ELEMENTS = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The number of structural features of the '<em>Path Name CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PATH_NAME_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PathElementCSImpl <em>Path Element CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.PathElementCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPathElementCS()
	 * @generated
	 */
  int PATH_ELEMENT_CS = 32;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_ELEMENT_CS__AST = CS_TRACE__AST;

		/**
	 * The feature id for the '<em><b>Element Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PATH_ELEMENT_CS__ELEMENT_NAME = CS_TRACE_FEATURE_COUNT + 0;

  /**
	 * The number of structural features of the '<em>Path Element CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int PATH_ELEMENT_CS_FEATURE_COUNT = CS_TRACE_FEATURE_COUNT + 1;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.BooleanExpCSImpl <em>Boolean Exp CS</em>}' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.BooleanExpCSImpl
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getBooleanExpCS()
	 * @generated
	 */
  int BOOLEAN_EXP_CS = 33;

  /**
	 * The feature id for the '<em><b>Ast</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_EXP_CS__AST = BOOLEAN_LITERAL_EXP_CS__AST;

		/**
	 * The feature id for the '<em><b>Left</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_EXP_CS__LEFT = BOOLEAN_LITERAL_EXP_CS__LEFT;

  /**
	 * The feature id for the '<em><b>Op Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_EXP_CS__OP_NAME = BOOLEAN_LITERAL_EXP_CS__OP_NAME;

  /**
	 * The feature id for the '<em><b>Right</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_EXP_CS__RIGHT = BOOLEAN_LITERAL_EXP_CS__RIGHT;

  /**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_EXP_CS__SOURCE = BOOLEAN_LITERAL_EXP_CS__SOURCE;

  /**
	 * The feature id for the '<em><b>Nav Exp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_EXP_CS__NAV_EXP = BOOLEAN_LITERAL_EXP_CS__NAV_EXP;

  /**
	 * The feature id for the '<em><b>Bool Symbol</b></em>' attribute.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_EXP_CS__BOOL_SYMBOL = BOOLEAN_LITERAL_EXP_CS_FEATURE_COUNT + 0;

  /**
	 * The number of structural features of the '<em>Boolean Exp CS</em>' class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
  int BOOLEAN_EXP_CS_FEATURE_COUNT = BOOLEAN_LITERAL_EXP_CS_FEATURE_COUNT + 1;

  /**
	 * The meta object id for the '{@link org.eclipse.qvtd.doc.minioclcs.CollectionKindCS <em>Collection Kind CS</em>}' enum.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionKindCS
	 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectionKindCS()
	 * @generated
	 */
  int COLLECTION_KIND_CS = 35;


  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.RootCS <em>Root CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Root CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.RootCS
	 * @generated
	 */
  EClass getRootCS();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.RootCS#getImports <em>Imports</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Imports</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.RootCS#getImports()
	 * @see #getRootCS()
	 * @generated
	 */
  EReference getRootCS_Imports();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.RootCS#getPackages <em>Packages</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Packages</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.RootCS#getPackages()
	 * @see #getRootCS()
	 * @generated
	 */
  EReference getRootCS_Packages();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.RootCS#getConstraints <em>Constraints</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constraints</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.RootCS#getConstraints()
	 * @see #getRootCS()
	 * @generated
	 */
  EReference getRootCS_Constraints();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.ImportCS <em>Import CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Import CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ImportCS
	 * @generated
	 */
  EClass getImportCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.ImportCS#getAlias <em>Alias</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alias</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ImportCS#getAlias()
	 * @see #getImportCS()
	 * @generated
	 */
  EAttribute getImportCS_Alias();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.ImportCS#getUri <em>Uri</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uri</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ImportCS#getUri()
	 * @see #getImportCS()
	 * @generated
	 */
  EAttribute getImportCS_Uri();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.PackageCS <em>Package CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Package CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PackageCS
	 * @generated
	 */
  EClass getPackageCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.PackageCS#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PackageCS#getName()
	 * @see #getPackageCS()
	 * @generated
	 */
  EAttribute getPackageCS_Name();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.PackageCS#getPackages <em>Packages</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Packages</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PackageCS#getPackages()
	 * @see #getPackageCS()
	 * @generated
	 */
  EReference getPackageCS_Packages();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.PackageCS#getClasses <em>Classes</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Classes</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PackageCS#getClasses()
	 * @see #getPackageCS()
	 * @generated
	 */
  EReference getPackageCS_Classes();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.ClassCS <em>Class CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ClassCS
	 * @generated
	 */
  EClass getClassCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.ClassCS#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ClassCS#getName()
	 * @see #getClassCS()
	 * @generated
	 */
  EAttribute getClassCS_Name();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.ClassCS#getExtends <em>Extends</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Extends</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ClassCS#getExtends()
	 * @see #getClassCS()
	 * @generated
	 */
  EReference getClassCS_Extends();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.ClassCS#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Properties</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ClassCS#getProperties()
	 * @see #getClassCS()
	 * @generated
	 */
  EReference getClassCS_Properties();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.ClassCS#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operations</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ClassCS#getOperations()
	 * @see #getClassCS()
	 * @generated
	 */
  EReference getClassCS_Operations();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.PropertyCS <em>Property CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Property CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PropertyCS
	 * @generated
	 */
  EClass getPropertyCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.PropertyCS#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PropertyCS#getName()
	 * @see #getPropertyCS()
	 * @generated
	 */
  EAttribute getPropertyCS_Name();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.PropertyCS#getTypeRef <em>Type Ref</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Ref</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PropertyCS#getTypeRef()
	 * @see #getPropertyCS()
	 * @generated
	 */
  EReference getPropertyCS_TypeRef();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.PropertyCS#getMultiplicity <em>Multiplicity</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Multiplicity</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PropertyCS#getMultiplicity()
	 * @see #getPropertyCS()
	 * @generated
	 */
  EReference getPropertyCS_Multiplicity();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.MultiplicityCS <em>Multiplicity CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Multiplicity CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.MultiplicityCS
	 * @generated
	 */
  EClass getMultiplicityCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#isOpt <em>Opt</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Opt</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#isOpt()
	 * @see #getMultiplicityCS()
	 * @generated
	 */
  EAttribute getMultiplicityCS_Opt();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#isMult <em>Mult</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mult</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#isMult()
	 * @see #getMultiplicityCS()
	 * @generated
	 */
  EAttribute getMultiplicityCS_Mult();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#getMandatory <em>Mandatory</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mandatory</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#getMandatory()
	 * @see #getMultiplicityCS()
	 * @generated
	 */
  EAttribute getMultiplicityCS_Mandatory();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#getLowerInt <em>Lower Int</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lower Int</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#getLowerInt()
	 * @see #getMultiplicityCS()
	 * @generated
	 */
  EAttribute getMultiplicityCS_LowerInt();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#getUpperInt <em>Upper Int</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Upper Int</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#getUpperInt()
	 * @see #getMultiplicityCS()
	 * @generated
	 */
  EAttribute getMultiplicityCS_UpperInt();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#isUpperMult <em>Upper Mult</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Upper Mult</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.MultiplicityCS#isUpperMult()
	 * @see #getMultiplicityCS()
	 * @generated
	 */
  EAttribute getMultiplicityCS_UpperMult();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.OperationCS <em>Operation CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.OperationCS
	 * @generated
	 */
  EClass getOperationCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.OperationCS#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.OperationCS#getName()
	 * @see #getOperationCS()
	 * @generated
	 */
  EAttribute getOperationCS_Name();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.OperationCS#getParams <em>Params</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Params</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.OperationCS#getParams()
	 * @see #getOperationCS()
	 * @generated
	 */
  EReference getOperationCS_Params();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.OperationCS#getResultRef <em>Result Ref</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Result Ref</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.OperationCS#getResultRef()
	 * @see #getOperationCS()
	 * @generated
	 */
  EReference getOperationCS_ResultRef();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.OperationCS#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Body</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.OperationCS#getBody()
	 * @see #getOperationCS()
	 * @generated
	 */
  EReference getOperationCS_Body();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.ParameterCS <em>Parameter CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ParameterCS
	 * @generated
	 */
  EClass getParameterCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.ParameterCS#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ParameterCS#getName()
	 * @see #getParameterCS()
	 * @generated
	 */
  EAttribute getParameterCS_Name();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.ParameterCS#getTypeRef <em>Type Ref</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Ref</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ParameterCS#getTypeRef()
	 * @see #getParameterCS()
	 * @generated
	 */
  EReference getParameterCS_TypeRef();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.ConstraintsDefCS <em>Constraints Def CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constraints Def CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ConstraintsDefCS
	 * @generated
	 */
  EClass getConstraintsDefCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.ConstraintsDefCS#getTypeRef <em>Type Ref</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Ref</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ConstraintsDefCS#getTypeRef()
	 * @see #getConstraintsDefCS()
	 * @generated
	 */
  EReference getConstraintsDefCS_TypeRef();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.ConstraintsDefCS#getInvariants <em>Invariants</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Invariants</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ConstraintsDefCS#getInvariants()
	 * @see #getConstraintsDefCS()
	 * @generated
	 */
  EReference getConstraintsDefCS_Invariants();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.InvariantCS <em>Invariant CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Invariant CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.InvariantCS
	 * @generated
	 */
  EClass getInvariantCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.InvariantCS#getExp <em>Exp</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Exp</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.InvariantCS#getExp()
	 * @see #getInvariantCS()
	 * @generated
	 */
  EReference getInvariantCS_Exp();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.ExpCS <em>Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.ExpCS
	 * @generated
	 */
  EClass getExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.EqualityExpCS <em>Equality Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Equality Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.EqualityExpCS
	 * @generated
	 */
  EClass getEqualityExpCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.EqualityExpCS#getLeft <em>Left</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Left</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.EqualityExpCS#getLeft()
	 * @see #getEqualityExpCS()
	 * @generated
	 */
  EReference getEqualityExpCS_Left();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.EqualityExpCS#getOpName <em>Op Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Op Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.EqualityExpCS#getOpName()
	 * @see #getEqualityExpCS()
	 * @generated
	 */
  EAttribute getEqualityExpCS_OpName();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.EqualityExpCS#getRight <em>Right</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Right</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.EqualityExpCS#getRight()
	 * @see #getEqualityExpCS()
	 * @generated
	 */
  EReference getEqualityExpCS_Right();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.CallExpCS <em>Call Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Call Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CallExpCS
	 * @generated
	 */
  EClass getCallExpCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.CallExpCS#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Source</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CallExpCS#getSource()
	 * @see #getCallExpCS()
	 * @generated
	 */
  EReference getCallExpCS_Source();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.CallExpCS#getNavExp <em>Nav Exp</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Nav Exp</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CallExpCS#getNavExp()
	 * @see #getCallExpCS()
	 * @generated
	 */
  EReference getCallExpCS_NavExp();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.PrimaryExpCS <em>Primary Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Primary Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PrimaryExpCS
	 * @generated
	 */
  EClass getPrimaryExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.SelfExpCS <em>Self Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Self Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.SelfExpCS
	 * @generated
	 */
  EClass getSelfExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.NavigationExpCS <em>Navigation Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Navigation Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.NavigationExpCS
	 * @generated
	 */
  EClass getNavigationExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.LoopExpCS <em>Loop Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Loop Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LoopExpCS
	 * @generated
	 */
  EClass getLoopExpCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.LoopExpCS#getItVar <em>It Var</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>It Var</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LoopExpCS#getItVar()
	 * @see #getLoopExpCS()
	 * @generated
	 */
  EReference getLoopExpCS_ItVar();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.LoopExpCS#getExp <em>Exp</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Exp</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LoopExpCS#getExp()
	 * @see #getLoopExpCS()
	 * @generated
	 */
  EReference getLoopExpCS_Exp();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.CollectExpCS <em>Collect Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collect Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectExpCS
	 * @generated
	 */
  EClass getCollectExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.IteratorVarCS <em>Iterator Var CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Iterator Var CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.IteratorVarCS
	 * @generated
	 */
  EClass getIteratorVarCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.IteratorVarCS#getItName <em>It Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>It Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.IteratorVarCS#getItName()
	 * @see #getIteratorVarCS()
	 * @generated
	 */
  EAttribute getIteratorVarCS_ItName();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.IteratorVarCS#getItType <em>It Type</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>It Type</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.IteratorVarCS#getItType()
	 * @see #getIteratorVarCS()
	 * @generated
	 */
  EReference getIteratorVarCS_ItType();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.IterateExpCS <em>Iterate Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Iterate Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.IterateExpCS
	 * @generated
	 */
  EClass getIterateExpCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.IterateExpCS#getAccVar <em>Acc Var</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Acc Var</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.IterateExpCS#getAccVar()
	 * @see #getIterateExpCS()
	 * @generated
	 */
  EReference getIterateExpCS_AccVar();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.AccVarCS <em>Acc Var CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Acc Var CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.AccVarCS
	 * @generated
	 */
  EClass getAccVarCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.AccVarCS#getAccName <em>Acc Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Acc Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.AccVarCS#getAccName()
	 * @see #getAccVarCS()
	 * @generated
	 */
  EAttribute getAccVarCS_AccName();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.AccVarCS#getAccType <em>Acc Type</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Acc Type</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.AccVarCS#getAccType()
	 * @see #getAccVarCS()
	 * @generated
	 */
  EReference getAccVarCS_AccType();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.AccVarCS#getAccInitExp <em>Acc Init Exp</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Acc Init Exp</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.AccVarCS#getAccInitExp()
	 * @see #getAccVarCS()
	 * @generated
	 */
  EReference getAccVarCS_AccInitExp();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.NameExpCS <em>Name Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Name Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.NameExpCS
	 * @generated
	 */
  EClass getNameExpCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.NameExpCS#getExpName <em>Exp Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Exp Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.NameExpCS#getExpName()
	 * @see #getNameExpCS()
	 * @generated
	 */
  EReference getNameExpCS_ExpName();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.NameExpCS#getRoundedBrackets <em>Rounded Brackets</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Rounded Brackets</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.NameExpCS#getRoundedBrackets()
	 * @see #getNameExpCS()
	 * @generated
	 */
  EReference getNameExpCS_RoundedBrackets();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.RoundedBracketClauseCS <em>Rounded Bracket Clause CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rounded Bracket Clause CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.RoundedBracketClauseCS
	 * @generated
	 */
  EClass getRoundedBracketClauseCS();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.RoundedBracketClauseCS#getArgs <em>Args</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Args</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.RoundedBracketClauseCS#getArgs()
	 * @see #getRoundedBracketClauseCS()
	 * @generated
	 */
  EReference getRoundedBracketClauseCS_Args();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.LiteralExpCS <em>Literal Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Literal Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LiteralExpCS
	 * @generated
	 */
  EClass getLiteralExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.IntLiteralExpCS <em>Int Literal Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Literal Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.IntLiteralExpCS
	 * @generated
	 */
  EClass getIntLiteralExpCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.IntLiteralExpCS#getIntSymbol <em>Int Symbol</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Int Symbol</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.IntLiteralExpCS#getIntSymbol()
	 * @see #getIntLiteralExpCS()
	 * @generated
	 */
  EAttribute getIntLiteralExpCS_IntSymbol();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.BooleanLiteralExpCS <em>Boolean Literal Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Literal Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.BooleanLiteralExpCS
	 * @generated
	 */
  EClass getBooleanLiteralExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.NullLiteralExpCS <em>Null Literal Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Null Literal Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.NullLiteralExpCS
	 * @generated
	 */
  EClass getNullLiteralExpCS();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.CollectionLiteralExpCS <em>Collection Literal Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Literal Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionLiteralExpCS
	 * @generated
	 */
  EClass getCollectionLiteralExpCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.CollectionLiteralExpCS#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionLiteralExpCS#getKind()
	 * @see #getCollectionLiteralExpCS()
	 * @generated
	 */
  EAttribute getCollectionLiteralExpCS_Kind();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.CollectionLiteralExpCS#getParts <em>Parts</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parts</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionLiteralExpCS#getParts()
	 * @see #getCollectionLiteralExpCS()
	 * @generated
	 */
  EReference getCollectionLiteralExpCS_Parts();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.CollectionLiteralPartCS <em>Collection Literal Part CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Collection Literal Part CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionLiteralPartCS
	 * @generated
	 */
  EClass getCollectionLiteralPartCS();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.CollectionLiteralPartCS#getFirst <em>First</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>First</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionLiteralPartCS#getFirst()
	 * @see #getCollectionLiteralPartCS()
	 * @generated
	 */
  EReference getCollectionLiteralPartCS_First();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.CollectionLiteralPartCS#getLast <em>Last</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Last</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionLiteralPartCS#getLast()
	 * @see #getCollectionLiteralPartCS()
	 * @generated
	 */
  EReference getCollectionLiteralPartCS_Last();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.LetExpCS <em>Let Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Let Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LetExpCS
	 * @generated
	 */
  EClass getLetExpCS();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.LetExpCS#getLetVars <em>Let Vars</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Let Vars</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LetExpCS#getLetVars()
	 * @see #getLetExpCS()
	 * @generated
	 */
  EReference getLetExpCS_LetVars();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.LetExpCS#getInExp <em>In Exp</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>In Exp</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LetExpCS#getInExp()
	 * @see #getLetExpCS()
	 * @generated
	 */
  EReference getLetExpCS_InExp();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.LetVarCS <em>Let Var CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Let Var CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LetVarCS
	 * @generated
	 */
  EClass getLetVarCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.LetVarCS#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LetVarCS#getName()
	 * @see #getLetVarCS()
	 * @generated
	 */
  EAttribute getLetVarCS_Name();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.LetVarCS#getTypeRef <em>Type Ref</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Type Ref</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LetVarCS#getTypeRef()
	 * @see #getLetVarCS()
	 * @generated
	 */
  EReference getLetVarCS_TypeRef();

  /**
	 * Returns the meta object for the containment reference '{@link org.eclipse.qvtd.doc.minioclcs.LetVarCS#getInitExp <em>Init Exp</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Init Exp</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.LetVarCS#getInitExp()
	 * @see #getLetVarCS()
	 * @generated
	 */
  EReference getLetVarCS_InitExp();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.PathNameCS <em>Path Name CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Path Name CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PathNameCS
	 * @generated
	 */
  EClass getPathNameCS();

  /**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.qvtd.doc.minioclcs.PathNameCS#getPathElements <em>Path Elements</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Path Elements</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PathNameCS#getPathElements()
	 * @see #getPathNameCS()
	 * @generated
	 */
  EReference getPathNameCS_PathElements();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.PathElementCS <em>Path Element CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Path Element CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PathElementCS
	 * @generated
	 */
  EClass getPathElementCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.PathElementCS#getElementName <em>Element Name</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Element Name</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.PathElementCS#getElementName()
	 * @see #getPathElementCS()
	 * @generated
	 */
  EAttribute getPathElementCS_ElementName();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.BooleanExpCS <em>Boolean Exp CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Exp CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.BooleanExpCS
	 * @generated
	 */
  EClass getBooleanExpCS();

  /**
	 * Returns the meta object for the attribute '{@link org.eclipse.qvtd.doc.minioclcs.BooleanExpCS#isBoolSymbol <em>Bool Symbol</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bool Symbol</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.BooleanExpCS#isBoolSymbol()
	 * @see #getBooleanExpCS()
	 * @generated
	 */
  EAttribute getBooleanExpCS_BoolSymbol();

  /**
	 * Returns the meta object for class '{@link org.eclipse.qvtd.doc.minioclcs.CSTrace <em>CS Trace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CS Trace</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CSTrace
	 * @generated
	 */
	EClass getCSTrace();

		/**
	 * Returns the meta object for the reference '{@link org.eclipse.qvtd.doc.minioclcs.CSTrace#getAst <em>Ast</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Ast</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CSTrace#getAst()
	 * @see #getCSTrace()
	 * @generated
	 */
	EReference getCSTrace_Ast();

		/**
	 * Returns the meta object for enum '{@link org.eclipse.qvtd.doc.minioclcs.CollectionKindCS <em>Collection Kind CS</em>}'.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Collection Kind CS</em>'.
	 * @see org.eclipse.qvtd.doc.minioclcs.CollectionKindCS
	 * @generated
	 */
  EEnum getCollectionKindCS();

  /**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
  MinioclcsFactory getMinioclcsFactory();

  /**
	 * <!-- begin-user-doc -->
   * Defines literals for the meta objects that represent
   * <ul>
   *   <li>each class,</li>
   *   <li>each feature of each class,</li>
   *   <li>each enum,</li>
   *   <li>and each data type</li>
   * </ul>
   * <!-- end-user-doc -->
	 * @generated
	 */
  interface Literals
  {
    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.RootCSImpl <em>Root CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.RootCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getRootCS()
		 * @generated
		 */
    EClass ROOT_CS = eINSTANCE.getRootCS();

    /**
		 * The meta object literal for the '<em><b>Imports</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ROOT_CS__IMPORTS = eINSTANCE.getRootCS_Imports();

    /**
		 * The meta object literal for the '<em><b>Packages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ROOT_CS__PACKAGES = eINSTANCE.getRootCS_Packages();

    /**
		 * The meta object literal for the '<em><b>Constraints</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ROOT_CS__CONSTRAINTS = eINSTANCE.getRootCS_Constraints();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ImportCSImpl <em>Import CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.ImportCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getImportCS()
		 * @generated
		 */
    EClass IMPORT_CS = eINSTANCE.getImportCS();

    /**
		 * The meta object literal for the '<em><b>Alias</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute IMPORT_CS__ALIAS = eINSTANCE.getImportCS_Alias();

    /**
		 * The meta object literal for the '<em><b>Uri</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute IMPORT_CS__URI = eINSTANCE.getImportCS_Uri();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PackageCSImpl <em>Package CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.PackageCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPackageCS()
		 * @generated
		 */
    EClass PACKAGE_CS = eINSTANCE.getPackageCS();

    /**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute PACKAGE_CS__NAME = eINSTANCE.getPackageCS_Name();

    /**
		 * The meta object literal for the '<em><b>Packages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference PACKAGE_CS__PACKAGES = eINSTANCE.getPackageCS_Packages();

    /**
		 * The meta object literal for the '<em><b>Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference PACKAGE_CS__CLASSES = eINSTANCE.getPackageCS_Classes();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ClassCSImpl <em>Class CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.ClassCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getClassCS()
		 * @generated
		 */
    EClass CLASS_CS = eINSTANCE.getClassCS();

    /**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute CLASS_CS__NAME = eINSTANCE.getClassCS_Name();

    /**
		 * The meta object literal for the '<em><b>Extends</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference CLASS_CS__EXTENDS = eINSTANCE.getClassCS_Extends();

    /**
		 * The meta object literal for the '<em><b>Properties</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference CLASS_CS__PROPERTIES = eINSTANCE.getClassCS_Properties();

    /**
		 * The meta object literal for the '<em><b>Operations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference CLASS_CS__OPERATIONS = eINSTANCE.getClassCS_Operations();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PropertyCSImpl <em>Property CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.PropertyCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPropertyCS()
		 * @generated
		 */
    EClass PROPERTY_CS = eINSTANCE.getPropertyCS();

    /**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute PROPERTY_CS__NAME = eINSTANCE.getPropertyCS_Name();

    /**
		 * The meta object literal for the '<em><b>Type Ref</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference PROPERTY_CS__TYPE_REF = eINSTANCE.getPropertyCS_TypeRef();

    /**
		 * The meta object literal for the '<em><b>Multiplicity</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference PROPERTY_CS__MULTIPLICITY = eINSTANCE.getPropertyCS_Multiplicity();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.MultiplicityCSImpl <em>Multiplicity CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MultiplicityCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getMultiplicityCS()
		 * @generated
		 */
    EClass MULTIPLICITY_CS = eINSTANCE.getMultiplicityCS();

    /**
		 * The meta object literal for the '<em><b>Opt</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute MULTIPLICITY_CS__OPT = eINSTANCE.getMultiplicityCS_Opt();

    /**
		 * The meta object literal for the '<em><b>Mult</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute MULTIPLICITY_CS__MULT = eINSTANCE.getMultiplicityCS_Mult();

    /**
		 * The meta object literal for the '<em><b>Mandatory</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute MULTIPLICITY_CS__MANDATORY = eINSTANCE.getMultiplicityCS_Mandatory();

    /**
		 * The meta object literal for the '<em><b>Lower Int</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute MULTIPLICITY_CS__LOWER_INT = eINSTANCE.getMultiplicityCS_LowerInt();

    /**
		 * The meta object literal for the '<em><b>Upper Int</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute MULTIPLICITY_CS__UPPER_INT = eINSTANCE.getMultiplicityCS_UpperInt();

    /**
		 * The meta object literal for the '<em><b>Upper Mult</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute MULTIPLICITY_CS__UPPER_MULT = eINSTANCE.getMultiplicityCS_UpperMult();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.OperationCSImpl <em>Operation CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.OperationCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getOperationCS()
		 * @generated
		 */
    EClass OPERATION_CS = eINSTANCE.getOperationCS();

    /**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute OPERATION_CS__NAME = eINSTANCE.getOperationCS_Name();

    /**
		 * The meta object literal for the '<em><b>Params</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference OPERATION_CS__PARAMS = eINSTANCE.getOperationCS_Params();

    /**
		 * The meta object literal for the '<em><b>Result Ref</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference OPERATION_CS__RESULT_REF = eINSTANCE.getOperationCS_ResultRef();

    /**
		 * The meta object literal for the '<em><b>Body</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference OPERATION_CS__BODY = eINSTANCE.getOperationCS_Body();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ParameterCSImpl <em>Parameter CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.ParameterCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getParameterCS()
		 * @generated
		 */
    EClass PARAMETER_CS = eINSTANCE.getParameterCS();

    /**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute PARAMETER_CS__NAME = eINSTANCE.getParameterCS_Name();

    /**
		 * The meta object literal for the '<em><b>Type Ref</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference PARAMETER_CS__TYPE_REF = eINSTANCE.getParameterCS_TypeRef();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ConstraintsDefCSImpl <em>Constraints Def CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.ConstraintsDefCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getConstraintsDefCS()
		 * @generated
		 */
    EClass CONSTRAINTS_DEF_CS = eINSTANCE.getConstraintsDefCS();

    /**
		 * The meta object literal for the '<em><b>Type Ref</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference CONSTRAINTS_DEF_CS__TYPE_REF = eINSTANCE.getConstraintsDefCS_TypeRef();

    /**
		 * The meta object literal for the '<em><b>Invariants</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference CONSTRAINTS_DEF_CS__INVARIANTS = eINSTANCE.getConstraintsDefCS_Invariants();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.InvariantCSImpl <em>Invariant CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.InvariantCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getInvariantCS()
		 * @generated
		 */
    EClass INVARIANT_CS = eINSTANCE.getInvariantCS();

    /**
		 * The meta object literal for the '<em><b>Exp</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference INVARIANT_CS__EXP = eINSTANCE.getInvariantCS_Exp();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.ExpCSImpl <em>Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.ExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getExpCS()
		 * @generated
		 */
    EClass EXP_CS = eINSTANCE.getExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.EqualityExpCSImpl <em>Equality Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.EqualityExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getEqualityExpCS()
		 * @generated
		 */
    EClass EQUALITY_EXP_CS = eINSTANCE.getEqualityExpCS();

    /**
		 * The meta object literal for the '<em><b>Left</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference EQUALITY_EXP_CS__LEFT = eINSTANCE.getEqualityExpCS_Left();

    /**
		 * The meta object literal for the '<em><b>Op Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute EQUALITY_EXP_CS__OP_NAME = eINSTANCE.getEqualityExpCS_OpName();

    /**
		 * The meta object literal for the '<em><b>Right</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference EQUALITY_EXP_CS__RIGHT = eINSTANCE.getEqualityExpCS_Right();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CallExpCSImpl <em>Call Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.CallExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCallExpCS()
		 * @generated
		 */
    EClass CALL_EXP_CS = eINSTANCE.getCallExpCS();

    /**
		 * The meta object literal for the '<em><b>Source</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference CALL_EXP_CS__SOURCE = eINSTANCE.getCallExpCS_Source();

    /**
		 * The meta object literal for the '<em><b>Nav Exp</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference CALL_EXP_CS__NAV_EXP = eINSTANCE.getCallExpCS_NavExp();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PrimaryExpCSImpl <em>Primary Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.PrimaryExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPrimaryExpCS()
		 * @generated
		 */
    EClass PRIMARY_EXP_CS = eINSTANCE.getPrimaryExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.SelfExpCSImpl <em>Self Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.SelfExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getSelfExpCS()
		 * @generated
		 */
    EClass SELF_EXP_CS = eINSTANCE.getSelfExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.NavigationExpCSImpl <em>Navigation Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.NavigationExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getNavigationExpCS()
		 * @generated
		 */
    EClass NAVIGATION_EXP_CS = eINSTANCE.getNavigationExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LoopExpCSImpl <em>Loop Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.LoopExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLoopExpCS()
		 * @generated
		 */
    EClass LOOP_EXP_CS = eINSTANCE.getLoopExpCS();

    /**
		 * The meta object literal for the '<em><b>It Var</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference LOOP_EXP_CS__IT_VAR = eINSTANCE.getLoopExpCS_ItVar();

    /**
		 * The meta object literal for the '<em><b>Exp</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference LOOP_EXP_CS__EXP = eINSTANCE.getLoopExpCS_Exp();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CollectExpCSImpl <em>Collect Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.CollectExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectExpCS()
		 * @generated
		 */
    EClass COLLECT_EXP_CS = eINSTANCE.getCollectExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.IteratorVarCSImpl <em>Iterator Var CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.IteratorVarCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getIteratorVarCS()
		 * @generated
		 */
    EClass ITERATOR_VAR_CS = eINSTANCE.getIteratorVarCS();

    /**
		 * The meta object literal for the '<em><b>It Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute ITERATOR_VAR_CS__IT_NAME = eINSTANCE.getIteratorVarCS_ItName();

    /**
		 * The meta object literal for the '<em><b>It Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ITERATOR_VAR_CS__IT_TYPE = eINSTANCE.getIteratorVarCS_ItType();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.IterateExpCSImpl <em>Iterate Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.IterateExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getIterateExpCS()
		 * @generated
		 */
    EClass ITERATE_EXP_CS = eINSTANCE.getIterateExpCS();

    /**
		 * The meta object literal for the '<em><b>Acc Var</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ITERATE_EXP_CS__ACC_VAR = eINSTANCE.getIterateExpCS_AccVar();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.AccVarCSImpl <em>Acc Var CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.AccVarCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getAccVarCS()
		 * @generated
		 */
    EClass ACC_VAR_CS = eINSTANCE.getAccVarCS();

    /**
		 * The meta object literal for the '<em><b>Acc Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute ACC_VAR_CS__ACC_NAME = eINSTANCE.getAccVarCS_AccName();

    /**
		 * The meta object literal for the '<em><b>Acc Type</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ACC_VAR_CS__ACC_TYPE = eINSTANCE.getAccVarCS_AccType();

    /**
		 * The meta object literal for the '<em><b>Acc Init Exp</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ACC_VAR_CS__ACC_INIT_EXP = eINSTANCE.getAccVarCS_AccInitExp();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.NameExpCSImpl <em>Name Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.NameExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getNameExpCS()
		 * @generated
		 */
    EClass NAME_EXP_CS = eINSTANCE.getNameExpCS();

    /**
		 * The meta object literal for the '<em><b>Exp Name</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference NAME_EXP_CS__EXP_NAME = eINSTANCE.getNameExpCS_ExpName();

    /**
		 * The meta object literal for the '<em><b>Rounded Brackets</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference NAME_EXP_CS__ROUNDED_BRACKETS = eINSTANCE.getNameExpCS_RoundedBrackets();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.RoundedBracketClauseCSImpl <em>Rounded Bracket Clause CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.RoundedBracketClauseCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getRoundedBracketClauseCS()
		 * @generated
		 */
    EClass ROUNDED_BRACKET_CLAUSE_CS = eINSTANCE.getRoundedBracketClauseCS();

    /**
		 * The meta object literal for the '<em><b>Args</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference ROUNDED_BRACKET_CLAUSE_CS__ARGS = eINSTANCE.getRoundedBracketClauseCS_Args();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LiteralExpCSImpl <em>Literal Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.LiteralExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLiteralExpCS()
		 * @generated
		 */
    EClass LITERAL_EXP_CS = eINSTANCE.getLiteralExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.IntLiteralExpCSImpl <em>Int Literal Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.IntLiteralExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getIntLiteralExpCS()
		 * @generated
		 */
    EClass INT_LITERAL_EXP_CS = eINSTANCE.getIntLiteralExpCS();

    /**
		 * The meta object literal for the '<em><b>Int Symbol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute INT_LITERAL_EXP_CS__INT_SYMBOL = eINSTANCE.getIntLiteralExpCS_IntSymbol();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.BooleanLiteralExpCSImpl <em>Boolean Literal Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.BooleanLiteralExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getBooleanLiteralExpCS()
		 * @generated
		 */
    EClass BOOLEAN_LITERAL_EXP_CS = eINSTANCE.getBooleanLiteralExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.NullLiteralExpCSImpl <em>Null Literal Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.NullLiteralExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getNullLiteralExpCS()
		 * @generated
		 */
    EClass NULL_LITERAL_EXP_CS = eINSTANCE.getNullLiteralExpCS();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralExpCSImpl <em>Collection Literal Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectionLiteralExpCS()
		 * @generated
		 */
    EClass COLLECTION_LITERAL_EXP_CS = eINSTANCE.getCollectionLiteralExpCS();

    /**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute COLLECTION_LITERAL_EXP_CS__KIND = eINSTANCE.getCollectionLiteralExpCS_Kind();

    /**
		 * The meta object literal for the '<em><b>Parts</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference COLLECTION_LITERAL_EXP_CS__PARTS = eINSTANCE.getCollectionLiteralExpCS_Parts();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralPartCSImpl <em>Collection Literal Part CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.CollectionLiteralPartCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectionLiteralPartCS()
		 * @generated
		 */
    EClass COLLECTION_LITERAL_PART_CS = eINSTANCE.getCollectionLiteralPartCS();

    /**
		 * The meta object literal for the '<em><b>First</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference COLLECTION_LITERAL_PART_CS__FIRST = eINSTANCE.getCollectionLiteralPartCS_First();

    /**
		 * The meta object literal for the '<em><b>Last</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference COLLECTION_LITERAL_PART_CS__LAST = eINSTANCE.getCollectionLiteralPartCS_Last();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LetExpCSImpl <em>Let Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.LetExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLetExpCS()
		 * @generated
		 */
    EClass LET_EXP_CS = eINSTANCE.getLetExpCS();

    /**
		 * The meta object literal for the '<em><b>Let Vars</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference LET_EXP_CS__LET_VARS = eINSTANCE.getLetExpCS_LetVars();

    /**
		 * The meta object literal for the '<em><b>In Exp</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference LET_EXP_CS__IN_EXP = eINSTANCE.getLetExpCS_InExp();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.LetVarCSImpl <em>Let Var CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.LetVarCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getLetVarCS()
		 * @generated
		 */
    EClass LET_VAR_CS = eINSTANCE.getLetVarCS();

    /**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute LET_VAR_CS__NAME = eINSTANCE.getLetVarCS_Name();

    /**
		 * The meta object literal for the '<em><b>Type Ref</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference LET_VAR_CS__TYPE_REF = eINSTANCE.getLetVarCS_TypeRef();

    /**
		 * The meta object literal for the '<em><b>Init Exp</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference LET_VAR_CS__INIT_EXP = eINSTANCE.getLetVarCS_InitExp();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PathNameCSImpl <em>Path Name CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.PathNameCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPathNameCS()
		 * @generated
		 */
    EClass PATH_NAME_CS = eINSTANCE.getPathNameCS();

    /**
		 * The meta object literal for the '<em><b>Path Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EReference PATH_NAME_CS__PATH_ELEMENTS = eINSTANCE.getPathNameCS_PathElements();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.PathElementCSImpl <em>Path Element CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.PathElementCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getPathElementCS()
		 * @generated
		 */
    EClass PATH_ELEMENT_CS = eINSTANCE.getPathElementCS();

    /**
		 * The meta object literal for the '<em><b>Element Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute PATH_ELEMENT_CS__ELEMENT_NAME = eINSTANCE.getPathElementCS_ElementName();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.BooleanExpCSImpl <em>Boolean Exp CS</em>}' class.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.BooleanExpCSImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getBooleanExpCS()
		 * @generated
		 */
    EClass BOOLEAN_EXP_CS = eINSTANCE.getBooleanExpCS();

    /**
		 * The meta object literal for the '<em><b>Bool Symbol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @generated
		 */
    EAttribute BOOLEAN_EXP_CS__BOOL_SYMBOL = eINSTANCE.getBooleanExpCS_BoolSymbol();

    /**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.impl.CSTraceImpl <em>CS Trace</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.CSTraceImpl
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCSTrace()
		 * @generated
		 */
		EClass CS_TRACE = eINSTANCE.getCSTrace();

				/**
		 * The meta object literal for the '<em><b>Ast</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CS_TRACE__AST = eINSTANCE.getCSTrace_Ast();

				/**
		 * The meta object literal for the '{@link org.eclipse.qvtd.doc.minioclcs.CollectionKindCS <em>Collection Kind CS</em>}' enum.
		 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
		 * @see org.eclipse.qvtd.doc.minioclcs.CollectionKindCS
		 * @see org.eclipse.qvtd.doc.minioclcs.impl.MinioclcsPackageImpl#getCollectionKindCS()
		 * @generated
		 */
    EEnum COLLECTION_KIND_CS = eINSTANCE.getCollectionKindCS();

  }

} //MinioclcsPackage
