/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTTemplate.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.Visitor;
import org.eclipse.qvt.declarative.ecore.QVTBase.util.QVTBaseToStringVisitor;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.CollectionTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.ObjectTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.util.QVTTemplateVisitor;
import org.eclipse.qvt.declarative.ecore.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTTemplateToStringVisitor
extends QVTBaseToStringVisitor
implements QVTTemplateVisitor<String> {
    public static QVTTemplateToStringVisitor getInstance(Environment<?, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, ?, ?> env) {
        return new QVTTemplateToStringVisitor(env);
    }

    public static QVTTemplateToStringVisitor getInstance(TypedElement<EClassifier> element) {
        Environment env = (Environment)ClassUtils.asClassUnchecked((Object)Environment.Registry.INSTANCE.getEnvironmentFor(element));
        return new QVTTemplateToStringVisitor(env);
    }

    public QVTTemplateToStringVisitor(Environment<?, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, ?, ?> env) {
        super(env);
    }

    @Override
    public String visitCollectionTemplateExp(CollectionTemplateExp collectionTemplateExp) {
        if (collectionTemplateExp == null) {
            return "null 'CollectionTemplateExp'";
        }
        StringBuffer result = new StringBuffer();
        Variable variable = collectionTemplateExp.getBindsTo();
        if (variable != null) {
            result.append((String)variable.accept((Visitor)this));
        } else {
            result.append(collectionTemplateExp.getName());
            result.append(" : ");
            EClassifier type = (EClassifier)collectionTemplateExp.getType();
            if (type != null) {
                result.append(type.getName());
            }
        }
        EList<OCLExpression> parts = collectionTemplateExp.getMember();
        result.append(" {");
        if (parts.size() > 0) {
            boolean isFirst = true;
            for (OCLExpression part : parts) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    result.append(", ");
                }
                result.append((String)part.accept((Visitor)this));
            }
            result.append(" ++ ");
            Variable rest = collectionTemplateExp.getRest();
            if (rest != null) {
                result.append((String)rest.accept((Visitor)this));
            }
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public String visitObjectTemplateExp(ObjectTemplateExp objectTemplateExp) {
        if (objectTemplateExp == null) {
            return "null 'ObjectTemplateExp'";
        }
        StringBuffer result = new StringBuffer();
        Variable variable = objectTemplateExp.getBindsTo();
        if (variable != null) {
            result.append((String)variable.accept((Visitor)this));
        } else {
            result.append(objectTemplateExp.getName());
            result.append(" : ");
            EClassifier type = (EClassifier)objectTemplateExp.getType();
            if (type != null) {
                result.append(type.getName());
            }
        }
        EList<PropertyTemplateItem> parts = objectTemplateExp.getPart();
        if (parts.size() > 0) {
            result.append(" {");
            boolean first = true;
            for (PropertyTemplateItem part : parts) {
                if (!first) {
                    result.append(",");
                }
                result.append(this.visitPropertyTemplateItem(part));
                first = false;
            }
            result.append("}");
        } else {
            result.append(" {}");
        }
        return result.toString();
    }

    @Override
    public String visitPropertyTemplateItem(PropertyTemplateItem propertyTemplateItem) {
        StringBuffer result = new StringBuffer();
        EStructuralFeature property = propertyTemplateItem.getReferredProperty();
        if (property != null) {
            result.append(property.getName());
        }
        result.append(" = ");
        OCLExpression value = propertyTemplateItem.getValue();
        if (value != null) {
            result.append((String)value.accept((Visitor)this));
        }
        return result.toString();
    }
}

