/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.tree;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.qvt.declarative.editor.ui.IPageManager;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TreePageEditor
extends EditorPart
implements IEditingDomainProvider,
IMenuListener,
IViewerProvider {
    public static final String ECORE_FILE_EXTENSION = "ecore";
    public static final String EMOF_FILE_EXTENSION = "emof";
    protected TreeViewer selectionViewer;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected final IPageManager pageManager;
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = TreePageEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            TreePageEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                            break;
                        }
                        TreePageEditor.this.resourceToDiagnosticMap.remove(resource);
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };

    private static String getString(String key) {
        return QVTEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return QVTEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public TreePageEditor(IPageManager pageManager) {
        this.pageManager = pageManager;
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.ecore.editor", 0, TreePageEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore.editor", 0, TreePageEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        this.createContextMenuForGen(viewer);
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (event.button == 1) {
                    try {
                        TreePageEditor.this.getEditorSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                    }
                    catch (PartInitException exception) {
                        QVTEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        });
    }

    protected void createContextMenuForGen(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.getEditingDomain(), (Viewer)viewer));
    }

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        this.selectionViewer = new TreeViewer(tree);
        this.getPagedEditor().initializeTreeViewer(this.selectionViewer);
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : TreePageEditor.this.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !TreePageEditor.this.isPersisted(resource) || TreePageEditor.this.getEditingDomain().isReadOnly(resource)) continue;
                    try {
                        TreePageEditor.this.savedResources.add(resource);
                        resource.save(saveOptions);
                    }
                    catch (Exception exception) {
                        TreePageEditor.this.resourceToDiagnosticMap.put(resource, TreePageEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.getEditingDomain().getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            QVTEditorPlugin.INSTANCE.log(exception);
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            ResourceSet resourceSet = this.getResourceSet();
            Resource currentResource = (Resource)resourceSet.getResources().get(0);
            String currentExtension = currentResource.getURI().fileExtension();
            URI newURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            String newExtension = newURI.fileExtension();
            if (currentExtension.equals(ECORE_FILE_EXTENSION) && newExtension.equals(EMOF_FILE_EXTENSION) || currentExtension.equals(EMOF_FILE_EXTENSION) && newExtension.equals(ECORE_FILE_EXTENSION)) {
                Resource newResource = resourceSet.createResource(newURI);
                newResource.getContents().addAll((Collection)currentResource.getContents());
                resourceSet.getResources().remove(0);
                resourceSet.getResources().move(0, (Object)newResource);
            } else {
                currentResource.setURI(newURI);
            }
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInputWithNotify((IEditorInput)modelFile);
            this.setPartName(file.getName());
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPageManager.class)) {
            return this.pageManager;
        }
        if (key.equals(IUndoContext.class)) {
            return this.getPagedEditor().getUndoContext();
        }
        return super.getAdapter(key);
    }

    public AdapterFactory getAdapterFactory() {
        return this.getPagedEditor().getAdapterFactory();
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.getPagedEditor().getAdapterFactoryEditingDomain();
    }

    public PagedEditor getPagedEditor() {
        return this.pageManager.getPagedEditor();
    }

    public ResourceSet getResourceSet() {
        return this.getPagedEditor().getResourceSet();
    }

    public Viewer getViewer() {
        return this.selectionViewer;
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.getEditingDomain().getCommandStack().flush();
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)TreePageEditor.getString("_UI_FileConflict_label"), (String)TreePageEditor.getString("_WARN_FileConflict"));
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.getPagedEditor().getActionBarContributor().menuAboutToShow(menuManager);
    }

    public void setFocus() {
        this.selectionViewer.getControl().setFocus();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " " + String.valueOf(((IFileEditorInput)this.getEditorInput()).getFile());
    }
}

