/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTRelation.DomainPattern;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.AbstractQVTRelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.QVTRelationMessages;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.RelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.TemplateExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainPatternOperations
extends AbstractQVTRelationOperations {
    public static DomainPatternOperations INSTANCE = new DomainPatternOperations();

    public boolean checkEveryVariableIsDefinedByRelation(DomainPattern domainPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Relation relation = this.getRelation(domainPattern);
        if (relation == null) {
            return true;
        }
        boolean allOk = true;
        for (Variable variable : domainPattern.getBindsTo()) {
            if (RelationOperations.INSTANCE.definesVariable(relation, variable)) continue;
            allOk = false;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)variable, context), this.getObjectLabel((EObject)relation, context)};
            this.appendError(diagnostics, variable, QVTRelationMessages._UI_DomainPattern_VariableIsNotDefinedByRelation, messageSubstitutions);
        }
        return allOk;
    }

    public boolean checkRootTemplateExpressionIsBoundToRootVariable(DomainPattern domainPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        RelationDomain relationDomain = this.getRelationDomain(domainPattern);
        if (relationDomain == null) {
            return true;
        }
        DomainPattern pattern = relationDomain.getPattern();
        if (pattern == null) {
            return true;
        }
        TemplateExp templateExp = pattern.getTemplateExpression();
        if (templateExp == null) {
            return true;
        }
        Variable variable = templateExp.getBindsTo();
        if (variable == null) {
            return true;
        }
        Variable rootVariable = relationDomain.getRootVariable();
        if (rootVariable == null) {
            return true;
        }
        if (rootVariable == variable) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)rootVariable, context), this.getObjectLabel((EObject)variable, context)};
        this.appendError(diagnostics, relationDomain, QVTRelationMessages._UI_DomainPattern_RootTemplateExpressionIsNotBoundToRootVariable, messageSubstitutions);
        return false;
    }

    public boolean checkRootTemplateExpressionTypeIsRootVariableType(DomainPattern domainPattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        RelationDomain relationDomain = this.getRelationDomain(domainPattern);
        if (relationDomain == null) {
            return true;
        }
        DomainPattern pattern = relationDomain.getPattern();
        if (pattern == null) {
            return true;
        }
        TemplateExp templateExp = pattern.getTemplateExpression();
        if (templateExp == null) {
            return true;
        }
        Variable rootVariable = relationDomain.getRootVariable();
        if (rootVariable == null) {
            return true;
        }
        if (rootVariable.getEType() == templateExp.getEType()) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)rootVariable.getEType(), context), this.getObjectLabel((EObject)rootVariable, context), this.getObjectLabel((EObject)templateExp.getEType(), context)};
        this.appendError(diagnostics, relationDomain, QVTRelationMessages._UI_DomainPattern_RootTemplateExpressionTypeIsNotRootVariableType, messageSubstitutions);
        return false;
    }

    public Relation getRelation(DomainPattern domainPattern) {
        EObject container = domainPattern.eContainer();
        if (!(container instanceof RelationDomain)) {
            return null;
        }
        Rule rule = ((Domain)container).getRule();
        if (!(rule instanceof Relation)) {
            return null;
        }
        return (Relation)rule;
    }

    public RelationDomain getRelationDomain(DomainPattern domainPattern) {
        EObject container = domainPattern.eContainer();
        if (!(container instanceof RelationDomain)) {
            return null;
        }
        return (RelationDomain)container;
    }
}

