/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.commands;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyAllNonConflictingCommand
extends ChangeCommand {
    private final List<? extends Diff> differences;
    private final boolean leftToRight;

    public CopyAllNonConflictingCommand(ChangeRecorder changeRecorder, Collection<Notifier> notifiers, List<? extends Diff> differences, boolean leftToRight) {
        super(changeRecorder, notifiers);
        this.differences = differences;
        this.leftToRight = leftToRight;
    }

    public boolean canExecute() {
        return super.canExecute() && Iterables.any(this.differences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
    }

    protected void doExecute() {
        if (this.leftToRight) {
            for (Diff diff : this.differences) {
                if (diff.getSource() != DifferenceSource.LEFT || diff.getConflict() != null) continue;
                diff.copyLeftToRight();
            }
        } else {
            for (Diff diff : this.differences) {
                if (diff.getSource() != DifferenceSource.RIGHT || diff.getConflict() != null) continue;
                diff.copyRightToLeft();
            }
        }
    }
}

