/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.diagram.provider.IViewLabelProvider;
import org.eclipse.emf.compare.diagram.provider.ViewLabelProviderExtensionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewLabelProviderExtensionRegistry {
    private static final List<ViewLabelProviderExtensionDescriptor> VIEW_LABEL_PROVIDERS = new ArrayList<ViewLabelProviderExtensionDescriptor>();

    private ViewLabelProviderExtensionRegistry() {
    }

    public static void addViewLabelProvider(ViewLabelProviderExtensionDescriptor extension) {
        VIEW_LABEL_PROVIDERS.add(extension);
    }

    public static void clearRegistry() {
        VIEW_LABEL_PROVIDERS.clear();
    }

    public static List<ViewLabelProviderExtensionDescriptor> getRegisteredViewLabelProviders() {
        return new ArrayList<ViewLabelProviderExtensionDescriptor>(VIEW_LABEL_PROVIDERS);
    }

    public static void removeExtension(String extensionClassName) {
        for (ViewLabelProviderExtensionDescriptor extension : ViewLabelProviderExtensionRegistry.getRegisteredViewLabelProviders()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            VIEW_LABEL_PROVIDERS.remove(extension);
        }
    }

    public static IViewLabelProvider getExtensionForType(String diagramType) {
        if (diagramType == null || "".equals(diagramType.trim())) {
            throw new IllegalArgumentException("nsURI");
        }
        List<ViewLabelProviderExtensionDescriptor> registeredExtensions = ViewLabelProviderExtensionRegistry.getRegisteredViewLabelProviders();
        for (ViewLabelProviderExtensionDescriptor viewLabelTypeProviderExtensionDescriptor : registeredExtensions) {
            if (!diagramType.equals(viewLabelTypeProviderExtensionDescriptor.getDiagramType())) continue;
            return viewLabelTypeProviderExtensionDescriptor.getExtension();
        }
        return null;
    }
}

