/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.impl.ReferenceChangeImpl;
import org.eclipse.emf.compare.internal.spec.EObjectUtil;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeSpec
extends ReferenceChangeImpl {
    private static final boolean DEBUG_MERGE = false;

    @Override
    public void copyLeftToRight() {
        boolean continueMerge;
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null && !(continueMerge = this.handleEquivalences(false))) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(false);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getLeft() != null) {
                        EObject leftValue = (EObject)this.getMatch().getLeft().eGet((EStructuralFeature)this.getReference(), false);
                        if (leftValue == null) {
                            this.removeFromTarget(false);
                            break;
                        }
                        this.addInTarget(false);
                        break;
                    }
                    this.removeFromTarget(false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(false);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(false);
                    break;
                }
                case MOVE: {
                    this.moveElement(false);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getRight() != null) {
                        EObject rightValue = (EObject)this.getMatch().getRight().eGet((EStructuralFeature)this.getReference(), false);
                        if (rightValue == null) {
                            this.addInTarget(false);
                            break;
                        }
                        this.resetInTarget(false);
                        break;
                    }
                    this.addInTarget(false);
                    break;
                }
            }
        }
    }

    @Override
    public void copyRightToLeft() {
        boolean continueMerge;
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null && !(continueMerge = this.handleEquivalences(true))) {
            return;
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(true);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getLeft() != null) {
                        EObject leftValue = (EObject)this.getMatch().getLeft().eGet((EStructuralFeature)this.getReference(), false);
                        if (leftValue == null) {
                            this.addInTarget(true);
                            break;
                        }
                        this.resetInTarget(true);
                        break;
                    }
                    this.addInTarget(true);
                    break;
                }
            }
        } else {
            this.mergeRequires(true);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(true);
                    break;
                }
                case MOVE: {
                    this.moveElement(true);
                    break;
                }
                case CHANGE: {
                    if (this.getMatch().getRight() != null) {
                        EObject rightValue = (EObject)this.getMatch().getRight().eGet((EStructuralFeature)this.getReference(), false);
                        if (rightValue == null) {
                            this.removeFromTarget(true);
                            break;
                        }
                        this.addInTarget(true);
                        break;
                    }
                    this.removeFromTarget(true);
                    break;
                }
            }
        }
    }

    @Override
    public void discard() {
        this.setState(DifferenceState.DISCARDED);
    }

    protected void mergeRequiredBy(boolean rightToLeft) {
        for (Diff dependency : this.getRequiredBy()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void mergeRequires(boolean rightToLeft) {
        for (Diff dependency : this.getRequires()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void moveElement(boolean rightToLeft) {
        EObject expectedValue;
        EObject expectedContainer;
        Comparison comparison = this.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        if (this.getReference().isContainment()) {
            Match targetContainerMatch = rightToLeft && valueMatch.getRight() != null ? comparison.getMatch(valueMatch.getRight().eContainer()) : (!rightToLeft && valueMatch.getLeft() != null ? comparison.getMatch(valueMatch.getLeft().eContainer()) : comparison.getMatch(valueMatch.getOrigin().eContainer()));
            expectedContainer = rightToLeft ? targetContainerMatch.getLeft() : targetContainerMatch.getRight();
        } else {
            expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        }
        if (expectedContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (this.getReference().isMany()) {
                List targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference());
                expectedValue = this.findMatchIn(targetList, this.getValue());
            } else {
                expectedValue = (EObject)expectedContainer.eGet((EStructuralFeature)this.getReference());
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        this.doMove(comparison, expectedContainer, expectedValue, rightToLeft);
    }

    protected void doMove(Comparison comparison, EObject expectedContainer, EObject expectedValue, boolean rightToLeft) {
        if (this.getReference().isMany()) {
            List targetList;
            int currentIndex;
            int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
            if (insertionIndex > (currentIndex = (targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference())).indexOf(expectedValue)) && currentIndex >= 0) {
                --insertionIndex;
            }
            if (currentIndex == -1) {
                if (!this.getReference().isContainment()) {
                    targetList.remove(expectedValue);
                }
                if (insertionIndex >= 0) {
                    targetList.add(insertionIndex, expectedValue);
                } else {
                    targetList.add(expectedValue);
                }
            } else if (targetList instanceof EList) {
                ((EList)targetList).move(insertionIndex, (Object)expectedValue);
            } else {
                targetList.remove(expectedValue);
                targetList.add(insertionIndex, expectedValue);
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
    }

    protected void addInTarget(boolean rightToLeft) {
        EObject expectedValue;
        EObject expectedContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        if (expectedContainer == null) {
            return;
        }
        Match valueMatch = comparison.getMatch(this.getValue());
        if (valueMatch == null) {
            expectedValue = this.getValue().eIsProxy() ? EcoreUtil.copy((EObject)this.getValue()) : this.getValue();
        } else if (rightToLeft) {
            if (this.getReference().isContainment()) {
                expectedValue = this.createTarget(this.getValue());
                valueMatch.setLeft(expectedValue);
            } else {
                expectedValue = valueMatch.getLeft();
            }
        } else if (this.getReference().isContainment()) {
            expectedValue = this.createTarget(this.getValue());
            valueMatch.setRight(expectedValue);
        } else {
            expectedValue = valueMatch.getRight();
        }
        if (this.getReference().isMany()) {
            int insertionIndex = DiffUtil.findInsertionIndex(comparison, this, rightToLeft);
            List targetList = (List)expectedContainer.eGet((EStructuralFeature)this.getReference());
            if (targetList instanceof InternalEList) {
                ((InternalEList)targetList).addUnique(insertionIndex, (Object)expectedValue);
            } else {
                targetList.add(insertionIndex, expectedValue);
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
        if (this.getReference().isContainment()) {
            Resource initialResource = this.getValue().eResource();
            Resource targetResource = expectedValue.eResource();
            if (initialResource instanceof XMIResource && targetResource instanceof XMIResource) {
                ((XMIResource)targetResource).setID(expectedValue, ((XMIResource)initialResource).getID(this.getValue()));
            }
        }
    }

    protected EObject createTarget(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected void removeFromTarget(boolean rightToLeft) {
        EObject expectedValue;
        List targetList;
        EObject currentContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        Comparison comparison = this.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        if (currentContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (this.getReference().isMany()) {
                targetList = (List)currentContainer.eGet((EStructuralFeature)this.getReference());
                expectedValue = this.findMatchIn(targetList, this.getValue());
            } else {
                expectedValue = null;
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        if (this.getReference().isContainment() && expectedValue != null) {
            EcoreUtil.remove((EObject)expectedValue);
            if (rightToLeft && valueMatch != null) {
                valueMatch.setLeft(null);
            } else if (valueMatch != null) {
                valueMatch.setRight(null);
            }
        } else if (this.getReference().isMany()) {
            targetList = (List)currentContainer.eGet((EStructuralFeature)this.getReference());
            targetList.remove(expectedValue);
        } else {
            currentContainer.eUnset((EStructuralFeature)this.getReference());
        }
    }

    protected void resetInTarget(boolean rightToLeft) {
        EObject targetContainer = rightToLeft ? this.getMatch().getLeft() : this.getMatch().getRight();
        EObject originContainer = this.getMatch().getComparison().isThreeWay() ? this.getMatch().getOrigin() : (rightToLeft ? this.getMatch().getRight() : this.getMatch().getLeft());
        if (originContainer == null || !ReferenceUtil.safeEIsSet(targetContainer, (EStructuralFeature)this.getReference()) || !ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)this.getReference())) {
            targetContainer.eUnset((EStructuralFeature)this.getReference());
        } else {
            EObject originalValue = (EObject)originContainer.eGet((EStructuralFeature)this.getReference());
            Match valueMatch = this.getMatch().getComparison().getMatch(originalValue);
            EObject expectedValue = valueMatch == null ? originalValue : (rightToLeft ? valueMatch.getLeft() : valueMatch.getRight());
            targetContainer.eSet((EStructuralFeature)this.getReference(), (Object)expectedValue);
        }
    }

    protected boolean handleEquivalences(boolean rightToLeft) {
        boolean continueMerge = true;
        for (Diff equivalent : this.getEquivalence().getDifferences()) {
            if (equivalent instanceof ReferenceChange && this.getReference().getEOpposite() == ((ReferenceChange)equivalent).getReference() && equivalent.getState() == DifferenceState.UNRESOLVED) {
                boolean mergeEquivalence;
                boolean bl = mergeEquivalence = !this.getReference().isMany() && ((ReferenceChange)equivalent).getReference().isMany();
                if (mergeEquivalence && rightToLeft) {
                    equivalent.copyRightToLeft();
                    continueMerge = false;
                } else if (mergeEquivalence) {
                    equivalent.copyLeftToRight();
                    continueMerge = false;
                }
            } else if (this.getSource() == DifferenceSource.LEFT) {
                if (rightToLeft && this.getRequiredBy().contains((Object)equivalent)) {
                    equivalent.copyRightToLeft();
                    continueMerge = false;
                } else if (!rightToLeft && this.getRequires().contains((Object)equivalent)) {
                    equivalent.copyLeftToRight();
                    continueMerge = false;
                }
            } else if (this.getSource() == DifferenceSource.RIGHT) {
                if (rightToLeft && this.getRequires().contains((Object)equivalent)) {
                    equivalent.copyRightToLeft();
                    continueMerge = false;
                } else if (!rightToLeft && this.getRequiredBy().contains((Object)equivalent)) {
                    equivalent.copyLeftToRight();
                    continueMerge = false;
                }
            }
            equivalent.setState(DifferenceState.MERGED);
        }
        return continueMerge;
    }

    private EObject findMatchIn(List<EObject> list, EObject element) {
        Comparison comparison = this.getMatch().getComparison();
        IEqualityHelper helper = comparison.getEqualityHelper();
        for (EObject next : list) {
            if (!helper.matchingValues(next, element)) continue;
            return next;
        }
        return null;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("reference", (Object)(String.valueOf(this.getReference().getEContainingClass().getName()) + "." + this.getReference().getName())).add("value", (Object)EObjectUtil.getLabel(this.getValue())).add("parentMatch", (Object)this.getMatch().toString()).add("match of value", (Object)this.getMatch().getComparison().getMatch(this.getValue())).add("kind", (Object)this.getKind()).add("source", (Object)this.getSource()).add("state", (Object)this.getState()).toString();
    }

    private void checkMergeState(boolean rightToLeft) {
        boolean wasDeleteMerge;
        Match containerMatch = this.getMatch();
        Comparison comparison = containerMatch.getComparison();
        Match valueMatch = comparison.getMatch(this.getValue());
        Object leftValue = null;
        if (containerMatch.getLeft() != null) {
            leftValue = containerMatch.getLeft().eGet((EStructuralFeature)this.getReference());
        }
        Object rightValue = null;
        if (containerMatch.getRight() != null) {
            rightValue = containerMatch.getRight().eGet((EStructuralFeature)this.getReference());
        }
        boolean mergeTowardsSource = rightToLeft && this.getSource() == DifferenceSource.LEFT || !rightToLeft && this.getSource() == DifferenceSource.RIGHT;
        boolean bl = wasDeleteMerge = this.getKind() == DifferenceKind.ADD && mergeTowardsSource || this.getKind() == DifferenceKind.DELETE && !mergeTowardsSource;
        assert (this.getState() == DifferenceState.MERGED) : "Difference has not been set as MERGED.";
        if (mergeTowardsSource) {
            for (Diff diff : this.getRequiredBy()) {
                assert (diff.getState() == DifferenceState.MERGED) : "Requirement has not been merged.";
            }
        } else {
            for (Diff diff : this.getRequires()) {
                assert (diff.getState() == DifferenceState.MERGED) : "Requirement has not been merged.";
            }
        }
        if (this.getEquivalence() != null) {
            for (Diff diff : this.getEquivalence().getDifferences()) {
                assert (diff.getState() == DifferenceState.MERGED) : "Equivalence has not been set as MERGED.";
            }
        }
        assert (this.getReference() != null) : "Cannot have an empty reference";
        if (this.getReference().isContainment()) {
            if (valueMatch == null) {
                if (this.getReference().isMany()) {
                    if (wasDeleteMerge) {
                        if (leftValue != null) {
                            assert (leftValue instanceof List);
                            assert (!((List)leftValue).contains(this.getValue())) : "None of the sides should contain the value";
                        }
                        if (rightValue != null) {
                            assert (rightValue instanceof List);
                            assert (!((List)rightValue).contains(this.getValue())) : "None of the sides should contain the value";
                        }
                    } else {
                        if (leftValue != null) {
                            assert (leftValue instanceof List);
                            assert (((List)leftValue).contains(this.getValue())) : "Both sides shoulds point towards the same instance";
                        }
                        if (rightValue != null) {
                            assert (rightValue instanceof List);
                            assert (((List)rightValue).contains(this.getValue())) : "Both sides shoulds point towards the same instance";
                        }
                    }
                } else assert (leftValue == rightValue) : "Both sides should point towards the same instance";
            } else {
                if (this.getKind() == DifferenceKind.MOVE && valueMatch.getLeft() != null && valueMatch.getRight() != null) {
                    EObject leftContainer = valueMatch.getLeft().eContainer();
                    EObject rightContainer = valueMatch.getRight().eContainer();
                    leftValue = leftContainer.eGet((EStructuralFeature)this.getReference());
                    rightValue = rightContainer.eGet((EStructuralFeature)this.getReference());
                }
                if (this.getReference().isMany()) {
                    if (wasDeleteMerge) {
                        if (leftValue != null) {
                            assert (leftValue instanceof List);
                            assert (!((List)leftValue).contains(valueMatch.getLeft())) : "None of the sides should contain the matched value";
                        }
                        if (rightValue != null) {
                            assert (rightValue instanceof List);
                            assert (!((List)rightValue).contains(valueMatch.getRight())) : "None of the sides should contain the matched value";
                        }
                    } else {
                        if (leftValue != null) {
                            assert (leftValue instanceof List);
                            assert (((List)leftValue).contains(valueMatch.getLeft())) : "Both sides shoulds point towards the matched value";
                        }
                        if (rightValue != null) {
                            assert (rightValue instanceof List);
                            assert (((List)rightValue).contains(valueMatch.getRight())) : "Both sides shoulds point towards the matchedValue";
                        }
                    }
                } else if (wasDeleteMerge) {
                    assert (leftValue == null && rightValue == null) : "Both values should be 'null'.";
                } else assert (leftValue == valueMatch.getLeft() && rightValue == valueMatch.getRight()) : "The value should be the matched one on both sides.";
            }
        } else if (leftValue instanceof EObject) {
            Match leftValueMatch = comparison.getMatch((EObject)leftValue);
            if (leftValueMatch == null) {
                assert (leftValue == rightValue) : "Merging an out-of-scope element should leave both sides pointing towards the instance.";
            } else assert (leftValueMatch.getRight() == rightValue) : "Merging should leave both sides pointing towards the same matched value";
        } else if (valueMatch == null) {
            if (wasDeleteMerge) {
                if (leftValue instanceof List) assert (!((List)leftValue).contains(this.getValue())) : "Value should have been deleted from both sides.";
                if (rightValue instanceof List) assert (!((List)rightValue).contains(this.getValue())) : "Value should have been deleted from both sides.";
            } else {
                if (leftValue instanceof List) assert (((List)leftValue).contains(this.getValue())) : "Merging an out-of-scope element should leave both sides pointing towards the instance.";
                if (rightValue instanceof List) assert (((List)rightValue).contains(this.getValue())) : "Merging an out-of-scope element should leave both sides pointing towards the instance.";
            }
        } else if (wasDeleteMerge) {
            if (leftValue instanceof List) assert (!((List)leftValue).contains(valueMatch.getLeft())) : "None of the sides should contain the matched value";
            if (rightValue instanceof List) assert (!((List)rightValue).contains(valueMatch.getRight())) : "None of the sides should contain the matched value";
        } else {
            if (leftValue instanceof List) assert (((List)leftValue).contains(valueMatch.getLeft())) : "Both sides shoulds point towards the matched value";
            if (rightValue instanceof List) assert (((List)rightValue).contains(valueMatch.getRight())) : "Both sides shoulds point towards the matchedValue";
        }
    }
}

