/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.internal.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.AbstractDifferenceFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLRefinedElementsFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            EObject data;
            if (input instanceof TreeNode && (data = ((TreeNode)input).getData()) instanceof Diff) {
                Diff diff = (Diff)data;
                return Iterables.any((Iterable)diff.getRefines(), (Predicate)Predicates.instanceOf(UMLDiff.class));
            }
            return false;
        }
    };
    private static final Predicate<? super EObject> PREDICATE_WHEN_UNSELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            EPackage p;
            EObject data;
            if (input instanceof TreeNode && (data = ((TreeNode)input).getData()) != null && (p = data.eClass().getEPackage()) != null) {
                return p.getNsURI().startsWith("http://www.eclipse.org/emf/compare/uml2");
            }
            return false;
        }
    };

    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        if (scope != null) {
            for (String nsURI : scope.getNsURIs()) {
                if (!nsURI.matches("http://www\\.eclipse\\.org/uml2/.*/UML")) continue;
                return true;
            }
        }
        return false;
    }

    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }

    public Predicate<? super EObject> getPredicateWhenUnselected() {
        return PREDICATE_WHEN_UNSELECTED;
    }
}

