/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class MatchItemProviderSpec
extends MatchItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private final OverlayImageProvider overlayProvider = new OverlayImageProvider(this.getResourceLocator());

    public MatchItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getImage(Object object) {
        Match match = (Match)object;
        Object ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage(match, ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    public String getText(Object object) {
        Match match = (Match)object;
        String ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getText(object);
        }
        return ret;
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        Match match = (Match)object;
        ComposedStyledString styledString = new ComposedStyledString();
        if (Iterables.any((Iterable)match.getAllDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}))) {
            styledString.append("> ", IStyledString.Style.DECORATIONS_STYLER);
        }
        styledString.append(this.getText(object));
        return styledString;
    }

    public String getDescription(Object object) {
        return this.getText(object);
    }
}

