/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeWayComparisonGroupProvider
extends AbstractDifferenceGroupProvider
implements IDifferenceGroupProvider {
    private String label;
    private boolean activeByDefault;
    private ImmutableList<IDifferenceGroup> differenceGroups;
    private Comparison comp;

    public boolean isAdapterForType(Object type) {
        return type == IDifferenceGroupProvider.class;
    }

    @Override
    public Collection<? extends IDifferenceGroup> getGroups(Comparison comparison) {
        if (this.differenceGroups == null || !comparison.equals(this.comp)) {
            this.comp = comparison;
            ConflictsGroupImpl conflicts = new ConflictsGroupImpl(comparison, (Predicate<? super Diff>)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}), "Conflicts", this.getCrossReferenceAdapter());
            BasicDifferenceGroupImpl leftSide = new BasicDifferenceGroupImpl(comparison, (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}))), "Left side", this.getCrossReferenceAdapter());
            BasicDifferenceGroupImpl rightSide = new BasicDifferenceGroupImpl(comparison, (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}))), "Right side", this.getCrossReferenceAdapter());
            this.differenceGroups = ImmutableList.of((Object)conflicts, (Object)leftSide, (Object)rightSide);
        }
        return this.differenceGroups;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean defaultSelected() {
        return this.activeByDefault;
    }

    @Override
    public void setDefaultSelected(boolean active) {
        this.activeByDefault = active;
    }

    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return comparison != null && comparison.isThreeWay();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConflictsGroupImpl
    extends BasicDifferenceGroupImpl {
        public ConflictsGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, filter, name, crossReferenceAdapter);
        }

        @Override
        public IStyledString.IComposedStyledString getStyledName() {
            ComposedStyledString ret = new ComposedStyledString();
            Iterator eAllContents = Iterators.concat((Iterator)Iterators.transform(this.getGroupTree().iterator(), (Function)E_ALL_CONTENTS));
            Iterator eAllData = Iterators.transform((Iterator)eAllContents, (Function)TREE_NODE_DATA);
            UnmodifiableIterator eAllDiffData = Iterators.filter((Iterator)eAllData, Diff.class);
            HashSet diffs = Sets.newHashSet((Iterator)eAllDiffData);
            boolean unresolvedDiffs = Iterables.any((Iterable)diffs, (Predicate)Predicates.and((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO})));
            if (unresolvedDiffs) {
                ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
            }
            ret.append(this.getName());
            return ret;
        }

        @Override
        public List<? extends TreeNode> getGroupTree() {
            if (this.children == null) {
                this.children = Lists.newArrayList();
                for (Conflict conflict : this.comparison.getConflicts()) {
                    TreeNode buildSubTree = this.buildSubTree(conflict);
                    if (buildSubTree == null) continue;
                    this.children.add(buildSubTree);
                }
            }
            return this.children;
        }

        protected TreeNode buildSubTree(Conflict conflict) {
            TreeNode ret = this.wrap((EObject)conflict);
            for (Match match : this.comparison.getMatches()) {
                this.buildSubTree(ret, conflict, match);
            }
            return ret;
        }

        protected void buildSubTree(TreeNode parentNode, Conflict conflict, Match match) {
            Sets.SetView setView = Sets.intersection((Set)Sets.newHashSet((Iterable)match.getDifferences()), (Set)Sets.newHashSet((Iterable)conflict.getDifferences()));
            for (Diff diff : setView) {
                if (this.isParentPseudoConflictFromOtherSide(diff, parentNode.getData())) continue;
                TreeNode wrap = this.wrap((EObject)diff);
                parentNode.getChildren().add((Object)wrap);
                if (!this.isContainment(diff)) continue;
                Match diffMatch = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue());
                this.buildSubTree(wrap, conflict, diffMatch);
            }
            for (Match subMatch : match.getSubmatches()) {
                if (this.isMatchOfConflictContainmentDiff(conflict, subMatch)) continue;
                this.buildSubTree(parentNode, conflict, subMatch);
            }
        }

        private boolean isParentPseudoConflictFromOtherSide(Diff diff, EObject parent) {
            Conflict conflict;
            boolean ret = false;
            if (parent instanceof Diff && (conflict = ((Diff)parent).getConflict()) != null && ConflictKind.PSEUDO == conflict.getKind()) {
                ret = !EMFComparePredicates.fromSide((DifferenceSource)((Diff)parent).getSource()).apply((Object)diff);
            }
            return ret;
        }

        protected boolean isMatchOfConflictContainmentDiff(Conflict conflict, Match subMatch) {
            if (subMatch != null) {
                for (Diff diff : conflict.getDifferences()) {
                    Match realMatch;
                    if (!this.isContainment(diff) || !subMatch.equals(realMatch = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue()))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isContainment(Diff diff) {
            return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment();
        }
    }
}

