/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EMFCompareContentMergeViewer
extends ContentMergeViewer
implements ISelectionChangedListener,
ICompareColor.Provider,
IAdaptable,
IPropertyChangeListener,
CommandStackListener {
    private static final String HANDLER_SERVICE = "fHandlerService";
    protected static final int CENTER_WIDTH = 34;
    private IMergeViewer fAncestor;
    private IMergeViewer fLeft;
    private IMergeViewer fRight;
    private final AtomicBoolean fSyncingSelections = new AtomicBoolean(false);
    private EMFCompareColor fColors;
    private final DynamicObject fDynamicObject = new DynamicObject((Object)this);
    private UndoAction undoAction;
    private RedoAction redoAction;
    private IDifferenceGroupProvider selectedGroup;
    private Collection<IDifferenceFilter> selectedFilters;
    private CompareConfiguration configuration;
    private final AdapterFactoryContentProvider fAdapterFactoryContentProvider;

    protected EMFCompareContentMergeViewer(int style, ResourceBundle bundle, CompareConfiguration cc) {
        super(style, bundle, cc);
        this.editingDomainChange(null, this.getEditingDomain());
        this.setSelectedGroup((IDifferenceGroupProvider)cc.getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP"));
        this.setSelectedFilters((Collection)cc.getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS"));
        this.configuration = cc;
        this.configuration.addPropertyChangeListener((IPropertyChangeListener)this);
        ComposedAdapterFactory adapterFactory = (ComposedAdapterFactory)this.configuration.getProperty("org.eclipse.emf.compare.rcp.ui.COMPOSED_ADAPTER_FACTORY");
        this.fAdapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object newValue;
        if ("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN".equals(event.getProperty())) {
            this.editingDomainChange((ICompareEditingDomain)event.getOldValue(), (ICompareEditingDomain)event.getNewValue());
        } else if ("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS".equals(event.getProperty())) {
            Object newValue2 = event.getNewValue();
            if (newValue2 != null) {
                this.setSelectedFilters((Collection)newValue2);
                this.fLeft.setSelectedFilters((Collection)newValue2);
                this.fRight.setSelectedFilters((Collection)newValue2);
                this.fAncestor.setSelectedFilters((Collection)newValue2);
                IDifferenceGroupProvider group = this.getSelectedGroup();
                if (group != null) {
                    if (this.fLeft.getSelectedGroup() == null) {
                        this.fLeft.setSelectedGroup(group);
                    }
                    if (this.fRight.getSelectedGroup() == null) {
                        this.fRight.setSelectedGroup(group);
                    }
                    if (this.fAncestor.getSelectedGroup() == null) {
                        this.fAncestor.setSelectedGroup(group);
                    }
                }
                this.fLeft.refresh();
                this.fRight.refresh();
                this.fAncestor.refresh();
                this.getCenterControl().redraw();
            }
        } else if ("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP".equals(event.getProperty()) && (newValue = event.getNewValue()) != null) {
            this.setSelectedGroup((IDifferenceGroupProvider)newValue);
            this.fLeft.setSelectedGroup((IDifferenceGroupProvider)newValue);
            this.fRight.setSelectedGroup((IDifferenceGroupProvider)newValue);
            this.fAncestor.setSelectedGroup((IDifferenceGroupProvider)newValue);
        }
    }

    protected void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (oldValue != null) {
            oldValue.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        }
        if (newValue != oldValue) {
            if (newValue != null) {
                newValue.getCommandStack().addCommandStackListener((CommandStackListener)this);
                this.setLeftDirty(newValue.getCommandStack().isLeftSaveNeeded());
                this.setRightDirty(newValue.getCommandStack().isRightSaveNeeded());
            }
            if (this.undoAction != null) {
                this.undoAction.setEditingDomain(newValue);
            }
            if (this.redoAction != null) {
                this.redoAction.setEditingDomain(newValue);
            }
        }
    }

    public ICompareColor getCompareColor() {
        return this.fColors;
    }

    protected final ICompareEditingDomain getEditingDomain() {
        return (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
    }

    protected final Comparison getComparison() {
        return (Comparison)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT");
    }

    public boolean isThreeWay() {
        return super.isThreeWay();
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fAncestor.setInput(ancestor);
        this.fLeft.setInput(left);
        this.fRight.setInput(right);
        this.updateSelection(left);
    }

    protected void updateSelection(Object left) {
        IMergeViewerItem leftInitialItem = null;
        if (left instanceof ICompareAccessor) {
            leftInitialItem = ((ICompareAccessor)left).getInitialItem();
        }
        ISelection leftSelection = this.createSelectionOrEmpty(leftInitialItem);
        this.fLeft.setSelection(leftSelection, true);
        this.getCenterControl().redraw();
    }

    private ISelection createSelectionOrEmpty(Object o) {
        StructuredSelection selection = o != null ? new StructuredSelection(o) : StructuredSelection.EMPTY;
        return selection;
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected void createControls(Composite composite) {
        this.fAncestor = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.ANCESTOR);
        this.fAncestor.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLeft = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.LEFT);
        this.fLeft.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fRight = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.RIGHT);
        this.fRight.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fColors = new EMFCompareColor(this, null, this.getCompareConfiguration());
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)toolBarManager, "toolbar:org.eclipse.emf.compare.contentmergeviewer.toolbar");
        }
        this.undoAction = new UndoAction(this.getEditingDomain());
        this.redoAction = new RedoAction(this.getEditingDomain());
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void commandStackChanged(EventObject event) {
        if (this.undoAction != null) {
            this.undoAction.update();
        }
        if (this.redoAction != null) {
            this.redoAction.update();
        }
        if (this.getEditingDomain() != null) {
            this.setLeftDirty(this.getEditingDomain().getCommandStack().isLeftSaveNeeded());
            this.setRightDirty(this.getEditingDomain().getCommandStack().isRightSaveNeeded());
        }
        SWTUtil.safeAsyncExec(new Runnable(){

            public void run() {
                EMFCompareContentMergeViewer.this.refresh();
            }
        });
    }

    protected void copy(final boolean leftToRight) {
        ImmutableList differences = this.getComparison().isThreeWay() ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                boolean fromRightToLeft;
                boolean unresolved = diff.getState() == DifferenceState.UNRESOLVED;
                boolean nonConflictual = diff.getConflict() == null;
                boolean fromLeftToRight = leftToRight && diff.getSource() == DifferenceSource.LEFT;
                boolean bl = fromRightToLeft = !leftToRight && diff.getSource() == DifferenceSource.RIGHT;
                return unresolved && nonConflictual && (fromLeftToRight || fromRightToLeft);
            }
        })) : ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
        if (differences.size() > 0) {
            Command copyCommand = this.getEditingDomain().createCopyCommand((List)differences, leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            this.getEditingDomain().getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.getAncestorMergeViewer().getControl().setVisible(true);
            this.getAncestorMergeViewer().getControl().setBounds(x, y, width, height);
        } else {
            this.getAncestorMergeViewer().getControl().setVisible(false);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeft.getControl().setBounds(x, y, width1, height);
        this.fRight.getControl().setBounds(x + width1 + centerWidth, y, width2, height);
    }

    protected abstract IMergeViewer createMergeViewer(Composite var1, IMergeViewer.MergeViewerSide var2);

    protected final int getCenterWidth() {
        return 34;
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.fDynamicObject.get(HANDLER_SERVICE);
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected Control createCenterControl(Composite parent) {
        final Control ret = super.createCenterControl(parent);
        final PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                EMFCompareContentMergeViewer.this.paintCenter(e.gc);
            }
        };
        ret.addPaintListener(paintListener);
        ret.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ret.removePaintListener(paintListener);
            }
        });
        return ret;
    }

    protected abstract void paintCenter(GC var1);

    public Object getAdapter(Class adapter) {
        if (adapter == CompareHandlerService.class) {
            return this.getHandlerService();
        }
        if (adapter == CompareHandlerService[].class) {
            return new CompareHandlerService[]{this.getHandlerService()};
        }
        return null;
    }

    protected IMergeViewer getAncestorMergeViewer() {
        return this.fAncestor;
    }

    protected IMergeViewer getLeftMergeViewer() {
        return this.fLeft;
    }

    protected IMergeViewer getRightMergeViewer() {
        return this.fRight;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.synchronizeSelection(event);
        this.updateToolItems();
    }

    private void synchronizeSelection(SelectionChangedEvent event) {
        if (this.fSyncingSelections.compareAndSet(false, true)) {
            try {
                ISelection selection = event.getSelection();
                this.updatePropertiesView(selection);
                this.fLeft.setSelection(selection, true);
                this.fRight.setSelection(selection, true);
                this.fAncestor.setSelection(selection, true);
            }
            finally {
                this.fSyncingSelections.set(false);
            }
        }
    }

    private void updatePropertiesView(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ExtendedPropertySheetPage propertySheetPage = this.getExtendedPropertySheetPage(page);
            if (propertySheetPage != null) {
                StructuredSelection selectionForPropertySheet = null;
                IWorkbenchPart activePart = page.getActivePart();
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof MergeViewerItem) {
                    MergeViewerItem mergeViewerItem = (MergeViewerItem)firstElement;
                    IMergeViewer.MergeViewerSide side = mergeViewerItem.getSide();
                    Object newSelectedObject = mergeViewerItem.getSideValue(side);
                    propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)this.fAdapterFactoryContentProvider);
                    if (newSelectedObject != null) {
                        if (newSelectedObject instanceof EObject) {
                            this.manageReadOnly((EObject)newSelectedObject, side);
                        }
                        selectionForPropertySheet = new StructuredSelection(newSelectedObject);
                        propertySheetPage.selectionChanged(activePart, (ISelection)selectionForPropertySheet);
                    }
                }
                if (selectionForPropertySheet == null) {
                    selectionForPropertySheet = new StructuredSelection(new Object());
                    propertySheetPage.selectionChanged(activePart, (ISelection)selectionForPropertySheet);
                }
            }
        }
    }

    private ExtendedPropertySheetPage getExtendedPropertySheetPage(IWorkbenchPage activePage) {
        IViewPart view;
        ExtendedPropertySheetPage propertyPage = null;
        if (activePage != null && (view = activePage.findView("org.eclipse.ui.views.PropertySheet")) != null && view instanceof PropertySheet) {
            PropertySheet propertySheet = (PropertySheet)view;
            IPage currentPage = propertySheet.getCurrentPage();
            if (currentPage instanceof ExtendedPropertySheetPage) {
                propertyPage = (ExtendedPropertySheetPage)currentPage;
            } else {
                IEditorPart activeEditor = activePage.getActiveEditor();
                if (activeEditor != null && Platform.getAdapterManager().hasAdapter((Object)activeEditor, "org.eclipse.ui.views.properties.IPropertySheetPage")) {
                    propertySheet.partActivated(activePage.getActivePart());
                }
            }
        }
        return propertyPage;
    }

    private void manageReadOnly(EObject selectedObject, IMergeViewer.MergeViewerSide side) {
        if (IMergeViewer.MergeViewerSide.LEFT == side) {
            if (!this.configuration.isLeftEditable()) {
                this.setToReadOnly(selectedObject);
            }
        } else if (IMergeViewer.MergeViewerSide.RIGHT == side) {
            if (!this.configuration.isRightEditable()) {
                this.setToReadOnly(selectedObject);
            }
        } else if (IMergeViewer.MergeViewerSide.ANCESTOR == side) {
            this.setToReadOnly(selectedObject);
        }
    }

    private void setToReadOnly(EObject selectedObject) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)selectedObject);
        if (editingDomain instanceof AdapterFactoryEditingDomain) {
            Resource r = selectedObject.eResource();
            Map resourceToReadOnlyMap = ((AdapterFactoryEditingDomain)editingDomain).getResourceToReadOnlyMap();
            if (!resourceToReadOnlyMap.containsKey(r)) {
                resourceToReadOnlyMap.put(r, Boolean.TRUE);
            }
        }
    }

    protected Diff getDiffFrom(IMergeViewer viewer) {
        Diff diff = null;
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator selectedElements = ((IStructuredSelection)selection).iterator();
            while (diff == null && selectedElements.hasNext()) {
                Object element = selectedElements.next();
                if (!(element instanceof IMergeViewerItem)) continue;
                diff = ((IMergeViewerItem)element).getDiff();
            }
        }
        return diff;
    }

    protected void handleDispose(DisposeEvent event) {
        this.getCompareConfiguration().removePropertyChangeListener((IPropertyChangeListener)this);
        this.editingDomainChange(this.getEditingDomain(), null);
        super.handleDispose(event);
    }

    protected boolean isSubDiffFilterActive() {
        Object property = this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS");
        if (property == null) {
            return false;
        }
        Collection filters = (Collection)property;
        for (IDifferenceFilter iDifferenceFilter : filters) {
            if (!(iDifferenceFilter instanceof CascadingDifferencesFilter)) continue;
            return true;
        }
        return false;
    }

    public IDifferenceGroupProvider getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(IDifferenceGroupProvider group) {
        this.selectedGroup = group;
    }

    public Collection<IDifferenceFilter> getSelectedFilters() {
        return this.selectedFilters;
    }

    public void setSelectedFilters(Collection<IDifferenceFilter> selectedFilters) {
        this.selectedFilters = selectedFilters;
    }
}

