/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import com.google.common.base.Predicate;
import com.google.common.eventbus.Subscribe;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilterChange;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProviderChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergeViewer
extends ContentViewer
implements IMergeViewer {
    private final IMergeViewer.MergeViewerSide fSide;
    private final IEMFCompareConfiguration compareConfiguration;
    private Predicate<? super EObject> differenceFilter;
    private IDifferenceGroupProvider differenceGroupProvider;

    public AbstractMergeViewer(IMergeViewer.MergeViewerSide side, IEMFCompareConfiguration compareConfiguration) {
        this.fSide = side;
        this.compareConfiguration = compareConfiguration;
        this.getCompareConfiguration().getEventBus().register((Object)this);
    }

    @Override
    public IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    protected IEMFCompareConfiguration getCompareConfiguration() {
        return this.compareConfiguration;
    }

    protected void handleDispose(DisposeEvent event) {
        this.getCompareConfiguration().getEventBus().unregister((Object)this);
        super.handleDispose(event);
    }

    @Subscribe
    public void handleDifferenceGroupProviderChange(IDifferenceGroupProviderChange event) {
        this.differenceGroupProvider = event.getDifferenceGroupProvider();
        SWTUtil.safeRefresh((Viewer)this, true);
    }

    public IDifferenceGroupProvider getDifferenceGroupProvider() {
        if (this.differenceGroupProvider == null) {
            return this.getCompareConfiguration().getStructureMergeViewerGrouper().getProvider();
        }
        return this.differenceGroupProvider;
    }

    @Subscribe
    public void handleDifferenceFilterChange(IDifferenceFilterChange event) {
        this.differenceFilter = event.getPredicate();
        SWTUtil.safeRefresh((Viewer)this, true);
    }

    protected final Predicate<? super EObject> getDifferenceFilter() {
        if (this.differenceFilter == null) {
            return this.getCompareConfiguration().getStructureMergeViewerFilter().getAggregatedPredicate();
        }
        return this.differenceFilter;
    }
}

