/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import com.google.common.base.Objects;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractStructuredMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractTableOrTreeItemWrapper;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;

public abstract class AbstractTableOrTreeMergeViewer
extends AbstractStructuredMergeViewer {
    static final int IMAGE_GAP = 5;
    static final int DELTA_IMAGE_GAP = 2;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;
    private final ICompareColor.Provider fColorProvider;
    private Listener fEraseItemListener;
    private Listener fPaintItemListener;
    private MesureItemListener fMesureItemListener;

    public AbstractTableOrTreeMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side, ICompareColor.Provider colorProvider, IEMFCompareConfiguration compareConfiguration) {
        super(parent, side, compareConfiguration);
        this.getStructuredViewer().setUseHashlookup(true);
        this.getStructuredViewer().setComparer((IElementComparer)new ElementComparer());
        this.fColorProvider = colorProvider;
        this.fEraseItemListener = new Listener(){

            public void handleEvent(Event event) {
                AbstractTableOrTreeMergeViewer.this.handleEraseItemEvent(event);
            }
        };
        this.getStructuredViewer().getControl().addListener(40, this.fEraseItemListener);
        this.fPaintItemListener = new Listener(){

            public void handleEvent(Event event) {
                AbstractTableOrTreeMergeViewer.this.handlePaintItemEvent(event);
            }
        };
        this.getStructuredViewer().getControl().addListener(42, this.fPaintItemListener);
        this.fMesureItemListener = new MesureItemListener();
        this.getStructuredViewer().getControl().addListener(41, (Listener)this.fMesureItemListener);
    }

    protected void handlePaintItemEvent(Event event) {
        AbstractTableOrTreeItemWrapper itemWrapper = AbstractTableOrTreeItemWrapper.create((Item)event.item);
        String text = itemWrapper.getText(event.index);
        Image image = itemWrapper.getImage(event.index);
        Point size = event.gc.textExtent(text);
        int yOffset = Math.max(0, (event.height - size.y) / 2);
        int xOffset = event.x;
        if (image != null) {
            int imageYOffset = Math.max(0, (event.height - image.getBounds().height) / 2);
            event.gc.drawImage(image, event.x + 5, event.y + imageYOffset);
            xOffset += 5 + image.getBounds().width;
        }
        event.gc.drawText(text, xOffset + 2, event.y + yOffset, true);
        event.width += 2;
    }

    protected void handleEraseItemEvent(Event event) {
        IMergeViewerItem mergeViewerItem;
        Diff diff;
        event.detail &= 0xFFFFFFEF;
        Item item = (Item)event.item;
        AbstractTableOrTreeItemWrapper itemWrapper = AbstractTableOrTreeItemWrapper.create(item);
        Object data = itemWrapper.getData();
        if (data instanceof IMergeViewerItem && (diff = (mergeViewerItem = (IMergeViewerItem)data).getDiff()) != null && MergeViewerUtil.isVisibleInMergeViewer(diff, this.getDifferenceGroupProvider(), this.getDifferenceFilter())) {
            if (mergeViewerItem.isInsertionPoint()) {
                this.paintItemDiffBox(event, itemWrapper, diff, AbstractTableOrTreeMergeViewer.getBoundsForInsertionPoint(event, itemWrapper));
            } else {
                this.paintItemDiffBox(event, itemWrapper, diff, AbstractTableOrTreeMergeViewer.getBounds(event, itemWrapper));
            }
        }
    }

    private void paintItemDiffBox(Event event, AbstractTableOrTreeItemWrapper itemWrapper, Diff diff, Rectangle bounds) {
        event.detail &= 0xFFFFFFDF;
        GC g = event.gc;
        Color oldBackground = g.getBackground();
        Color oldForeground = g.getForeground();
        this.setGCStyleForDiff(g, diff, AbstractTableOrTreeMergeViewer.isSelected(event));
        g.fillRectangle(bounds);
        g.drawRectangle(bounds);
        if (diff.getKind() == DifferenceKind.MOVE) {
            g.setLineStyle(1);
        }
        switch (this.getSide()) {
            case LEFT: {
                this.drawLineFromBoxToCenter(itemWrapper, bounds, g);
                break;
            }
            case RIGHT: {
                this.drawLineFromCenterToBox(itemWrapper, bounds, g);
                break;
            }
        }
        if (AbstractTableOrTreeMergeViewer.isSelected(event)) {
            g.setForeground(event.display.getSystemColor(24));
            g.setBackground(event.display.getSystemColor(25));
            event.detail &= 0xFFFFFFFD;
        } else {
            g.setBackground(oldBackground);
            g.setForeground(oldForeground);
        }
    }

    private void drawLineFromCenterToBox(AbstractTableOrTreeItemWrapper itemWrapper, Rectangle boxBounds, GC g) {
        boolean hasChildren;
        AbstractTableOrTreeItemWrapper parent = itemWrapper.getParentItem();
        int xOffset = this.getContentProvider() instanceof ITreeContentProvider ? ((hasChildren = ((ITreeContentProvider)this.getContentProvider()).hasChildren(itemWrapper.getData())) ? (parent != null ? parent.getImageBounds((int)0).x : 0) : boxBounds.x) : boxBounds.x;
        Rectangle itemBounds = itemWrapper.getBounds();
        Point from = new Point(0, 0);
        from.y = itemBounds.y + itemBounds.height / 2;
        Point to = new Point(xOffset, from.y);
        g.drawLine(from.x, from.y, to.x, to.y);
    }

    private void drawLineFromBoxToCenter(AbstractTableOrTreeItemWrapper itemWrapper, Rectangle boxBounds, GC g) {
        Rectangle itemBounds = itemWrapper.getBounds();
        Rectangle clientArea = itemWrapper.getParent().getClientArea();
        Point from = new Point(0, 0);
        from.x = boxBounds.x + boxBounds.width;
        from.y = itemBounds.y + itemBounds.height / 2;
        Point to = new Point(0, from.y);
        to.x = clientArea.x + clientArea.width;
        g.drawLine(from.x, from.y, to.x, to.y);
    }

    private static Rectangle getBoundsForInsertionPoint(Event event, AbstractTableOrTreeItemWrapper itemWrapper) {
        Rectangle fill = AbstractTableOrTreeMergeViewer.getBounds(event, itemWrapper);
        Rectangle treeBounds = itemWrapper.getParent().getClientArea();
        Rectangle itemBounds = itemWrapper.getBounds();
        fill.x = itemWrapper.getImageBounds((int)0).x + 2;
        fill.y += itemBounds.height / 3;
        fill.width = treeBounds.width / 4;
        fill.height = itemBounds.height / 3;
        return fill;
    }

    private void setGCStyleForDiff(GC g, Diff diff, boolean selected) {
        Comparison comparison = diff.getMatch().getComparison();
        boolean isThreeWay = comparison.isThreeWay();
        if (diff.getKind() == DifferenceKind.MOVE) {
            g.setLineStyle(3);
        }
        g.setForeground(this.fColorProvider.getCompareColor().getStrokeColor(diff, isThreeWay, false, selected));
        g.setBackground(this.fColorProvider.getCompareColor().getFillColor(diff, isThreeWay, false, selected));
    }

    private static Rectangle getBounds(Event event, AbstractTableOrTreeItemWrapper itemWrapper) {
        int width;
        Scrollable tree = itemWrapper.getParent();
        Rectangle treeBounds = tree.getClientArea();
        Rectangle itemBounds = itemWrapper.getBounds();
        Rectangle imageBounds = itemWrapper.getImageBounds(0);
        Rectangle fill = new Rectangle(0, 0, 0, 0);
        fill.x = itemBounds.x - imageBounds.width;
        fill.y = itemBounds.y;
        if (!"cocoa".equals(SWT.getPlatform())) {
            ++fill.y;
        }
        fill.width = itemBounds.width + imageBounds.width + 2;
        fill.height = itemBounds.height - 1;
        if (!"cocoa".equals(SWT.getPlatform())) {
            fill.height -= 3;
        }
        GC g = event.gc;
        int columnCount = itemWrapper.getParentColumnCount();
        if ((event.index == columnCount - 1 || columnCount == 0) && (width = treeBounds.x + treeBounds.width - event.x) > 0) {
            Region region = new Region();
            g.getClipping(region);
            region.add(event.x, event.y, width, event.height);
            g.setClipping(region);
            region.dispose();
        }
        g.setAdvanced(true);
        return fill;
    }

    private static boolean isSelected(Event event) {
        return (event.detail & 2) != 0;
    }

    protected void handleDispose(DisposeEvent event) {
        this.getStructuredViewer().getControl().removeListener(41, (Listener)this.fMesureItemListener);
        this.getStructuredViewer().getControl().removeListener(40, this.fEraseItemListener);
        this.getStructuredViewer().getControl().removeListener(42, this.fPaintItemListener);
        super.handleDispose(event);
    }

    public static final class ElementComparer
    implements IElementComparer {
        public int hashCode(Object element) {
            IMergeViewerItem item;
            Diff diff;
            int hashCode = element instanceof IMergeViewerItem ? ((diff = (item = (IMergeViewerItem)element).getDiff()) != null && diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.PSEUDO ? Objects.hashCode((Object[])new Object[]{item.getAncestor(), diff.getConflict()}) : (diff != null && item.getLeft() == null && item.getRight() == null ? Objects.hashCode((Object[])new Object[]{item.getAncestor(), diff}) : Objects.hashCode((Object[])new Object[]{item.getLeft(), item.getRight(), item.getAncestor(), diff}))) : element.hashCode();
            return hashCode;
        }

        public boolean equals(Object a, Object b) {
            boolean ret;
            if (a != b && a instanceof IMergeViewerItem && b instanceof IMergeViewerItem) {
                IMergeViewerItem itemA = (IMergeViewerItem)a;
                IMergeViewerItem itemB = (IMergeViewerItem)b;
                Diff diffA = itemA.getDiff();
                Diff diffB = itemB.getDiff();
                ret = diffA != null && diffA.getConflict() != null && diffA.getConflict().getKind() == ConflictKind.PSEUDO && diffB != null && diffB.getConflict() != null && diffB.getConflict().getKind() == ConflictKind.PSEUDO ? Objects.equal((Object)itemA.getAncestor(), (Object)itemB.getAncestor()) && Objects.equal((Object)diffA.getConflict(), (Object)diffB.getConflict()) : (diffA != null && diffB != null && itemA.getLeft() == null && itemA.getRight() == null && itemB.getLeft() == null && itemB.getRight() == null ? Objects.equal((Object)diffA, (Object)diffB) : Objects.equal((Object)itemA.getLeft(), (Object)itemB.getLeft()) && Objects.equal((Object)itemA.getRight(), (Object)itemB.getRight()) && Objects.equal((Object)itemA.getAncestor(), (Object)itemB.getAncestor()) && Objects.equal((Object)diffA, (Object)diffB));
            } else {
                ret = Objects.equal((Object)a, (Object)b);
            }
            return ret;
        }
    }

    public static class MesureItemListener
    implements Listener {
        private int fHeight = Integer.MIN_VALUE;

        public void handleEvent(Event event) {
            if (this.fHeight == Integer.MIN_VALUE) {
                AbstractTableOrTreeItemWrapper itemWrapper = AbstractTableOrTreeItemWrapper.create((Item)event.item);
                Rectangle imageBounds = itemWrapper.getImageBounds(0);
                this.fHeight = imageBounds.height + 3;
            }
            event.height = this.fHeight;
        }
    }
}

