/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.Graph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.compare.ide.ui.logical.AbstractModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedModelResolver
extends AbstractModelResolver {
    private static final Function<IStorage, URI> AS_URI = new Function<IStorage, URI>(){

        public URI apply(IStorage input) {
            if (input != null) {
                return ResourceUtil.createURIFor((IStorage)input);
            }
            return null;
        }
    };
    private final Graph<URI> dependencyGraph;
    private Set<URI> resolvedResources;
    private BasicDiagnostic diagnostic;
    private final Set<URI> currentlyResolving;
    private ListeningExecutorService resolvingPool;
    private ListeningExecutorService unloadingPool;
    private ListeningExecutorService terminator;
    private final AtomicBoolean shutdownInProgress;
    private final ReentrantLock lock;
    private final Condition notResolving;
    private final Condition resolutionEnd;
    private ModelResourceListener resourceListener;
    private volatile CrossReferenceResolutionScope resolutionScope = CrossReferenceResolutionScope.CONTAINER;

    public ThreadedModelResolver() {
        this.dependencyGraph = new Graph();
        this.lock = new ReentrantLock(true);
        this.notResolving = this.lock.newCondition();
        this.resolutionEnd = this.lock.newCondition();
        this.currentlyResolving = new HashSet<URI>();
        this.shutdownInProgress = new AtomicBoolean(false);
    }

    private void createThreadPools() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ThreadFactory resolvingThreadFactory = new ThreadFactoryBuilder().setNameFormat("EMFCompare-ResolvingThread-%d").build();
        this.resolvingPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(availableProcessors, resolvingThreadFactory));
        ThreadFactory unloadingThreadFactory = new ThreadFactoryBuilder().setNameFormat("EMFCompare-UnloadingThread-%d").build();
        this.unloadingPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(availableProcessors, unloadingThreadFactory));
    }

    @Override
    public void initialize() {
        this.resourceListener = new ModelResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.terminator = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("EMFCompare-ThreadPoolShutdowner-%d").setPriority(10).build()));
    }

    @Override
    public void dispose() {
        this.terminator.shutdown();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        super.dispose();
    }

    private void shutdownPools() {
        if (!ThreadedModelResolver.shutdownAndAwaitTermination((ExecutorService)this.resolvingPool) || !ThreadedModelResolver.shutdownAndAwaitTermination((ExecutorService)this.unloadingPool)) {
            EMFCompareIDEUIPlugin.getDefault().log(2, "Thread pools have not been properly stopped");
        }
        this.resolvingPool = null;
        this.unloadingPool = null;
    }

    private static boolean shutdownAndAwaitTermination(ExecutorService pool) {
        boolean ret = true;
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    ret = false;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean canResolve(IStorage sourceStorage) {
        return true;
    }

    @Override
    public StorageTraversal resolveLocalModel(IResource start, IProgressMonitor monitor) throws InterruptedException {
        if (!(start instanceof IFile)) {
            return new StorageTraversal(new LinkedHashSet());
        }
        ThreadSafeProgressMonitor subMonitor = null;
        this.lock.lockInterruptibly();
        try {
            StorageTraversal traversal;
            subMonitor = new ThreadSafeProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
            while (!this.currentlyResolving.isEmpty()) {
                this.notResolving.await();
            }
            this.setupResolving();
            if (this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
                this.updateDependencies(resourceSet, (IFile)start, subMonitor);
                this.updateChangedResources(resourceSet, subMonitor);
            }
            while (!this.currentlyResolving.isEmpty()) {
                this.resolutionEnd.await();
            }
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Set<IStorage> traversalSet = this.resolveTraversal((IFile)start, Collections.<URI>emptySet());
            StorageTraversal storageTraversal = traversal = new StorageTraversal(traversalSet, (Diagnostic)this.diagnostic);
            return storageTraversal;
        }
        finally {
            try {
                this.finalizeResolving();
                if (subMonitor != null) {
                    subMonitor.setWorkRemaining(0);
                }
            }
            finally {
                this.notResolving.signal();
                this.lock.unlock();
            }
        }
    }

    @Override
    public SynchronizationModel resolveLocalModels(IResource left, IResource right, IResource origin, IProgressMonitor monitor) throws InterruptedException {
        ThreadSafeProgressMonitor subMonitor = new ThreadSafeProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
        try {
            if (!(left instanceof IFile) || !(right instanceof IFile) || origin != null && !(origin instanceof IFile)) {
                SynchronizationModel synchronizationModel = this.resolveNonFileLocalModels(left, right, origin, subMonitor);
                return synchronizationModel;
            }
            SynchronizationModel synchronizationModel = this.resolveFileLocalModel(left, right, origin, subMonitor);
            return synchronizationModel;
        }
        finally {
            subMonitor.setWorkRemaining(0);
        }
    }

    private SynchronizationModel resolveNonFileLocalModels(IResource left, IResource right, IResource origin, ThreadSafeProgressMonitor subMonitor) throws InterruptedException {
        StorageTraversal leftTraversal = this.resolveLocalModel(left, (IProgressMonitor)subMonitor);
        StorageTraversal rightTraversal = this.resolveLocalModel(right, (IProgressMonitor)subMonitor);
        StorageTraversal originTraversal = origin != null ? this.resolveLocalModel(origin, (IProgressMonitor)subMonitor) : new StorageTraversal((Set)Sets.newLinkedHashSet());
        return new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    private SynchronizationModel resolveFileLocalModel(IResource left, IResource right, IResource origin, ThreadSafeProgressMonitor monitor) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            SynchronizationModel synchronizationModel;
            Set<Object> originTraversal;
            Set<IStorage> rightTraversal;
            Set<IStorage> leftTraversal;
            URI originURI;
            ImmutableSet startingPoints;
            while (!this.currentlyResolving.isEmpty()) {
                this.notResolving.await();
            }
            this.setupResolving();
            if (this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
                this.updateDependencies(resourceSet, (IFile)left, monitor);
                this.updateDependencies(resourceSet, (IFile)right, monitor);
                if (origin instanceof IFile) {
                    this.updateDependencies(resourceSet, (IFile)origin, monitor);
                }
                this.updateChangedResources(resourceSet, monitor);
            }
            URI leftURI = ResourceUtil.createURIFor((IFile)((IFile)left));
            URI rightURI = ResourceUtil.createURIFor((IFile)((IFile)right));
            if (origin instanceof IFile) {
                startingPoints = ImmutableSet.of((Object)((IFile)left), (Object)((IFile)right), (Object)((IFile)origin));
                originURI = ResourceUtil.createURIFor((IFile)((IFile)origin));
            } else {
                startingPoints = ImmutableSet.of((Object)((IFile)left), (Object)((IFile)right));
                originURI = null;
            }
            while (!this.currentlyResolving.isEmpty()) {
                this.resolutionEnd.await();
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (origin instanceof IFile) {
                leftTraversal = this.resolveTraversal((IFile)left, (Set<URI>)ImmutableSet.of((Object)rightURI, (Object)originURI));
                rightTraversal = this.resolveTraversal((IFile)right, (Set<URI>)ImmutableSet.of((Object)leftURI, (Object)originURI));
                originTraversal = this.resolveTraversal((IFile)origin, (Set<URI>)ImmutableSet.of((Object)leftURI, (Object)rightURI));
            } else {
                leftTraversal = this.resolveTraversal((IFile)left, Collections.singleton(rightURI));
                rightTraversal = this.resolveTraversal((IFile)right, Collections.singleton(leftURI));
                originTraversal = Collections.emptySet();
            }
            Sets.SetView intersection = Sets.intersection(leftTraversal, rightTraversal);
            if (!originTraversal.isEmpty()) {
                intersection = Sets.intersection((Set)intersection, originTraversal);
            }
            this.logCoherenceThreats(Iterables.transform((Iterable)startingPoints, AS_URI), Iterables.transform((Iterable)intersection, AS_URI));
            LinkedHashSet actualLeft = new LinkedHashSet(Sets.difference(leftTraversal, (Set)intersection));
            LinkedHashSet actualRight = new LinkedHashSet(Sets.difference(rightTraversal, (Set)intersection));
            LinkedHashSet actualOrigin = new LinkedHashSet(Sets.difference(originTraversal, (Set)intersection));
            SynchronizationModel synchronizationModel2 = synchronizationModel = new SynchronizationModel(new StorageTraversal(actualLeft), new StorageTraversal(actualRight), new StorageTraversal(actualOrigin), (Diagnostic)this.diagnostic);
            return synchronizationModel2;
        }
        finally {
            try {
                this.finalizeResolving();
            }
            finally {
                this.notResolving.signal();
                this.lock.unlock();
            }
        }
    }

    @Override
    public SynchronizationModel resolveModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) throws InterruptedException {
        ThreadSafeProgressMonitor subMonitor = null;
        this.lock.lockInterruptibly();
        try {
            subMonitor = new ThreadSafeProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
            while (!this.currentlyResolving.isEmpty()) {
                this.notResolving.await();
            }
            this.setupResolving();
            IFile leftFile = PlatformElementUtil.adaptAs(left, IFile.class);
            SynchronizationModel synchronizationModel = leftFile != null ? this.resolveModelsWithLocal(storageAccessor, leftFile, right, origin, subMonitor) : this.resolveRemoteModels(storageAccessor, left, right, origin, subMonitor);
            SynchronizationModel synchronizationModel2 = synchronizationModel;
            return synchronizationModel2;
        }
        finally {
            try {
                this.finalizeResolving();
                if (subMonitor != null) {
                    subMonitor.setWorkRemaining(0);
                }
            }
            finally {
                this.notResolving.signal();
                this.lock.unlock();
            }
        }
    }

    private void setupResolving() {
        this.createThreadPools();
        this.resolvedResources = new LinkedHashSet<URI>();
        this.diagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
    }

    private void finalizeResolving() {
        if (!this.shutdownInProgress.get()) {
            this.shutdownPools();
        }
        if (this.diagnostic.getSeverity() >= 4) {
            this.dependencyGraph.clear();
        }
        this.resolvedResources = null;
        this.diagnostic = null;
    }

    private SynchronizationModel resolveModelsWithLocal(IStorageProviderAccessor storageAccessor, IFile left, IStorage right, IStorage origin, ThreadSafeProgressMonitor monitor) throws InterruptedException {
        if (this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
            SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
            this.updateDependencies(resourceSet, left, monitor);
            this.updateChangedResources(resourceSet, monitor);
        }
        while (!this.currentlyResolving.isEmpty()) {
            this.resolutionEnd.await();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Set<IStorage> leftTraversal = this.resolveTraversal(left, Collections.<URI>emptySet());
        Set<IStorage> rightTraversal = this.resolveRemoteTraversal(storageAccessor, right, leftTraversal, IStorageProviderAccessor.DiffSide.REMOTE, monitor);
        Set<Object> originTraversal = origin != null ? this.resolveRemoteTraversal(storageAccessor, origin, leftTraversal, IStorageProviderAccessor.DiffSide.ORIGIN, monitor) : Collections.emptySet();
        SynchronizationModel synchronizationModel = new SynchronizationModel(new StorageTraversal(leftTraversal), new StorageTraversal(rightTraversal), new StorageTraversal(originTraversal), (Diagnostic)this.diagnostic);
        return synchronizationModel;
    }

    private SynchronizationModel resolveRemoteModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, ThreadSafeProgressMonitor monitor) throws InterruptedException {
        Set<IStorage> leftTraversal = this.resolveRemoteTraversal(storageAccessor, left, Collections.<IStorage>emptySet(), IStorageProviderAccessor.DiffSide.SOURCE, monitor);
        Set<IStorage> rightTraversal = this.resolveRemoteTraversal(storageAccessor, right, Collections.<IStorage>emptySet(), IStorageProviderAccessor.DiffSide.REMOTE, monitor);
        Set<Object> originTraversal = origin != null ? this.resolveRemoteTraversal(storageAccessor, origin, Collections.<IStorage>emptySet(), IStorageProviderAccessor.DiffSide.ORIGIN, monitor) : Collections.emptySet();
        SynchronizationModel synchronizationModel = new SynchronizationModel(new StorageTraversal(leftTraversal), new StorageTraversal(rightTraversal), new StorageTraversal(originTraversal), (Diagnostic)this.diagnostic);
        return synchronizationModel;
    }

    private void updateChangedResources(SynchronizedResourceSet resourceSet, ThreadSafeProgressMonitor monitor) {
        Sets.SetView removedURIs = Sets.difference(this.resourceListener.popRemovedURIs(), this.resolvedResources);
        Sets.SetView changedURIs = Sets.difference(this.resourceListener.popChangedURIs(), this.resolvedResources);
        this.dependencyGraph.removeAll((Collection<URI>)removedURIs);
        LinkedHashSet<URI> recompute = new LinkedHashSet<URI>((Collection<URI>)changedURIs);
        for (URI changed : changedURIs) {
            if (!this.dependencyGraph.contains(changed)) continue;
            recompute.addAll(this.dependencyGraph.getDirectParents(changed));
        }
        this.dependencyGraph.removeAll(recompute);
        for (URI changed : recompute) {
            this.demandResolve(resourceSet, changed, monitor);
        }
    }

    private void updateDependencies(SynchronizedResourceSet resourceSet, IFile file, ThreadSafeProgressMonitor monitor) {
        URI expectedURI = ResourceUtil.createURIFor((IFile)file);
        if (!this.dependencyGraph.contains(expectedURI)) {
            IResource startingPoint = this.getResolutionStartingPoint(file);
            ModelResourceVisitor modelVisitor = new ModelResourceVisitor(resourceSet, monitor);
            try {
                startingPoint.accept((IResourceVisitor)modelVisitor);
            }
            catch (CoreException e) {
                this.safeMergeDiagnostic(BasicDiagnostic.toDiagnostic((Throwable)e));
            }
        }
    }

    private IResource getResolutionStartingPoint(IFile file) {
        IFile startingPoint;
        switch (this.getResolutionScope()) {
            case WORKSPACE: {
                startingPoint = ResourcesPlugin.getWorkspace().getRoot();
                break;
            }
            case PROJECT: {
                startingPoint = file.getProject();
                break;
            }
            case CONTAINER: {
                startingPoint = file.getParent();
                break;
            }
            default: {
                startingPoint = file;
            }
        }
        return startingPoint;
    }

    private CrossReferenceResolutionScope getResolutionScope() {
        return this.resolutionScope;
    }

    public void setResolutionScope(CrossReferenceResolutionScope resolutionScope) {
        this.resolutionScope = resolutionScope;
    }

    private Set<IStorage> resolveTraversal(IFile file, Set<URI> bounds) {
        LinkedHashSet<IStorage> traversal = new LinkedHashSet<IStorage>();
        Iterable<URI> dependencies = this.getDependenciesOf(file, bounds);
        for (URI uri : dependencies) {
            traversal.add((IStorage)this.getFileAt(uri));
        }
        return traversal;
    }

    private Set<IStorage> resolveRemoteTraversal(IStorageProviderAccessor storageAccessor, IStorage start, Set<IStorage> localVariants, IStorageProviderAccessor.DiffSide side, ThreadSafeProgressMonitor monitor) throws InterruptedException {
        SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), storageAccessor, side);
        resourceSet.setURIConverter((URIConverter)converter);
        this.resolvedResources = new LinkedHashSet<URI>();
        for (IStorage local : localVariants) {
            URI expectedURI = ResourceUtil.createURIFor((IStorage)local);
            this.demandRemoteResolve(resourceSet, expectedURI, monitor);
        }
        URI startURI = ResourceUtil.createURIFor((IStorage)start);
        this.demandRemoteResolve(resourceSet, startURI, monitor);
        while (!this.currentlyResolving.isEmpty()) {
            this.resolutionEnd.await();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.resolvedResources = null;
        return converter.getLoadedRevisions();
    }

    private Iterable<URI> getDependenciesOf(IFile file, Set<URI> bounds) {
        Iterable<Object> dependencies;
        URI expectedURI = ResourceUtil.createURIFor((IFile)file);
        switch (this.getResolutionScope()) {
            case WORKSPACE: {
                dependencies = this.dependencyGraph.getSubgraphContaining(expectedURI, bounds);
                break;
            }
            case PROJECT: {
                Set<URI> allDependencies = this.dependencyGraph.getSubgraphContaining(expectedURI, bounds);
                IProject project = file.getProject();
                dependencies = Iterables.filter(allDependencies, this.isInContainer((IResource)project));
                break;
            }
            case CONTAINER: {
                Set<URI> allDependencies1 = this.dependencyGraph.getSubgraphContaining(expectedURI, bounds);
                IContainer container = file.getParent();
                dependencies = Iterables.filter(allDependencies1, this.isInContainer((IResource)container));
                break;
            }
            case OUTGOING: {
                dependencies = this.dependencyGraph.getTreeFrom(expectedURI, bounds);
                break;
            }
            default: {
                dependencies = Collections.singleton(expectedURI);
            }
        }
        return dependencies;
    }

    private IFile getFileAt(URI uri) {
        StringBuilder path = new StringBuilder();
        List segments = uri.segmentsList();
        if (uri.isPlatformResource()) {
            segments = segments.subList(1, segments.size());
        }
        for (String segment : segments) {
            path.append(URI.decode((String)segment)).append('/');
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path.toString()));
    }

    private Predicate<URI> isInContainer(final IResource container) {
        return new Predicate<URI>(){

            public boolean apply(URI input) {
                IFile pointedFile;
                if (input != null && (pointedFile = ThreadedModelResolver.this.getFileAt(input)) != null) {
                    return container.getLocation().isPrefixOf(pointedFile.getLocation());
                }
                return false;
            }
        };
    }

    private void logCoherenceThreats(Iterable<URI> startingPoints, Iterable<URI> removedFromModel) {
        LinkedHashSet<URI> coherenceThreats = new LinkedHashSet<URI>();
        for (URI start : startingPoints) {
            for (URI removed : removedFromModel) {
                if (!this.dependencyGraph.hasChild(removed, start)) continue;
                coherenceThreats.add(removed);
            }
        }
        if (!coherenceThreats.isEmpty()) {
            String message = EMFCompareIDEUIMessages.getString("ModelResolver.coherenceWarning");
            String details = Iterables.toString(coherenceThreats);
            EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", String.valueOf(message) + '\n' + details));
        }
    }

    protected void demandResolve(SynchronizedResourceSet resourceSet, URI uri, ThreadSafeProgressMonitor monitor) {
        if (this.isInterruptedOrCanceled((IProgressMonitor)monitor)) {
            this.demandResolvingAndUnloadingPoolShutdown();
            return;
        }
        this.lock.lock();
        try {
            if (this.resolvedResources.add(uri) && this.currentlyResolving.add(uri)) {
                monitor.setWorkRemaining(1000);
                ListenableFuture future = this.resolvingPool.submit((Runnable)new ResourceResolver(resourceSet, uri, monitor));
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new ResolvingFutureCallback((IProgressMonitor)monitor, uri));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void demandRemoteResolve(SynchronizedResourceSet resourceSet, URI uri, ThreadSafeProgressMonitor monitor) {
        if (this.isInterruptedOrCanceled((IProgressMonitor)monitor)) {
            this.demandResolvingAndUnloadingPoolShutdown();
            return;
        }
        this.lock.lock();
        try {
            if (this.resolvedResources.add(uri) && this.currentlyResolving.add(uri)) {
                monitor.setWorkRemaining(1000);
                ListenableFuture future = this.resolvingPool.submit((Runnable)new RemoteResourceResolver(resourceSet, uri, monitor));
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new ResolvingFutureCallback((IProgressMonitor)monitor, uri));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void demandUnload(SynchronizedResourceSet resourceSet, Resource resource, final ThreadSafeProgressMonitor monitor) {
        monitor.setWorkRemaining(1000);
        ListenableFuture future = this.unloadingPool.submit((Runnable)new ResourceUnloader(resourceSet, resource, (IProgressMonitor)monitor));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                if (!ThreadedModelResolver.this.isInterruptedOrCanceled((IProgressMonitor)monitor)) {
                    monitor.worked(1);
                }
            }

            public void onFailure(Throwable t) {
                if (!ThreadedModelResolver.this.isInterruptedOrCanceled((IProgressMonitor)monitor)) {
                    monitor.worked(1);
                    ThreadedModelResolver.this.safeMergeDiagnostic(BasicDiagnostic.toDiagnostic((Throwable)t));
                }
            }
        });
    }

    private void safeMergeDiagnostic(Diagnostic resourceDiagnostic) {
        this.lock.lock();
        try {
            this.diagnostic.merge(resourceDiagnostic);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isInterruptedOrCanceled(IProgressMonitor monitor) {
        return Thread.currentThread().isInterrupted() || monitor.isCanceled();
    }

    private void demandResolvingAndUnloadingPoolShutdown() {
        if (!Thread.currentThread().isInterrupted() && this.shutdownInProgress.compareAndSet(false, true)) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ThreadedModelResolver.this.shutdownPools();
                }
            };
            ListenableFuture listenableFuture = this.terminator.submit(runnable);
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    ThreadedModelResolver.this.shutdownInProgress.set(false);
                }

                public void onFailure(Throwable t) {
                    ThreadedModelResolver.this.shutdownInProgress.set(false);
                    EMFCompareIDEUIPlugin.getDefault().log(t);
                }
            });
        }
    }

    private void finalizeResolvingTask(URI uri) {
        this.lock.lock();
        try {
            this.currentlyResolving.remove(uri);
            if (this.currentlyResolving.isEmpty()) {
                this.resolutionEnd.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelResourceListener
    implements IResourceChangeListener {
        protected final Set<URI> changedURIs = new LinkedHashSet<URI>();
        protected final Set<URI> removedURIs = new LinkedHashSet<URI>();
        protected final ReentrantLock internalLock = new ReentrantLock();

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            this.internalLock.lock();
            try {
                try {
                    delta.accept((IResourceDeltaVisitor)new ModelResourceDeltaVisitor());
                }
                catch (CoreException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                    this.internalLock.unlock();
                }
            }
            finally {
                this.internalLock.unlock();
            }
        }

        public Set<URI> popChangedURIs() {
            ImmutableSet changed;
            this.internalLock.lock();
            try {
                changed = ImmutableSet.copyOf(this.changedURIs);
                this.changedURIs.clear();
            }
            finally {
                this.internalLock.unlock();
            }
            return changed;
        }

        public Set<URI> popRemovedURIs() {
            ImmutableSet removed;
            this.internalLock.lock();
            try {
                removed = ImmutableSet.copyOf(this.removedURIs);
                this.removedURIs.clear();
            }
            finally {
                this.internalLock.unlock();
            }
            return removed;
        }

        private class ModelResourceDeltaVisitor
        implements IResourceDeltaVisitor {
            private ModelResourceDeltaVisitor() {
            }

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (delta.getFlags() == 131072 || delta.getResource().getType() != 1) {
                    return true;
                }
                IFile file = (IFile)delta.getResource();
                URI fileURI = ResourceUtil.createURIFor((IFile)file);
                if (delta.getKind() == 2) {
                    ModelResourceListener.this.removedURIs.add(fileURI);
                    ModelResourceListener.this.changedURIs.remove(fileURI);
                } else if (ResourceUtil.hasModelType((IFile)file)) {
                    if ((delta.getKind() & 4) != 0) {
                        ModelResourceListener.this.changedURIs.add(fileURI);
                        ModelResourceListener.this.removedURIs.remove(fileURI);
                    } else if ((delta.getKind() & 1) != 0 && ModelResourceListener.this.removedURIs.remove(fileURI)) {
                        ModelResourceListener.this.changedURIs.add(fileURI);
                    }
                }
                return true;
            }
        }
    }

    private class ModelResourceVisitor
    implements IResourceVisitor {
        private final SynchronizedResourceSet resourceSet;
        private final ThreadSafeProgressMonitor monitor;

        public ModelResourceVisitor(SynchronizedResourceSet resourceSet, ThreadSafeProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (ThreadedModelResolver.this.isInterruptedOrCanceled((IProgressMonitor)this.monitor)) {
                ThreadedModelResolver.this.demandResolvingAndUnloadingPoolShutdown();
                throw new OperationCanceledException();
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (ResourceUtil.hasModelType((IFile)file)) {
                    URI expectedURI = ResourceUtil.createURIFor((IFile)file);
                    ThreadedModelResolver.this.demandResolve(this.resourceSet, expectedURI, this.monitor);
                }
                return false;
            }
            return true;
        }
    }

    private class RemoteResourceResolver
    implements Runnable {
        private final SynchronizedResourceSet resourceSet;
        private final URI uri;
        private final ThreadSafeProgressMonitor monitor;

        public RemoteResourceResolver(SynchronizedResourceSet resourceSet, URI uri, ThreadSafeProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.uri = uri;
            this.monitor = monitor;
        }

        public void run() {
            if (ThreadedModelResolver.this.isInterruptedOrCanceled((IProgressMonitor)this.monitor)) {
                ThreadedModelResolver.this.demandResolvingAndUnloadingPoolShutdown();
                return;
            }
            Resource resource = this.resourceSet.loadResource(this.uri);
            Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
            if (resourceDiagnostic.getSeverity() >= 2) {
                ThreadedModelResolver.this.safeMergeDiagnostic(resourceDiagnostic);
            }
            if (ThreadedModelResolver.this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                Set<URI> crossReferencedResources = this.resourceSet.discoverCrossReferences(resource, (IProgressMonitor)this.monitor);
                for (URI crossRef : crossReferencedResources) {
                    if (ThreadedModelResolver.this.isInterruptedOrCanceled((IProgressMonitor)this.monitor)) {
                        ThreadedModelResolver.this.demandResolvingAndUnloadingPoolShutdown();
                        break;
                    }
                    ThreadedModelResolver.this.demandRemoteResolve(this.resourceSet, crossRef, this.monitor);
                }
            }
            ThreadedModelResolver.this.demandUnload(this.resourceSet, resource, this.monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResolvingFutureCallback
    implements FutureCallback<Object> {
        private final IProgressMonitor monitor;
        private final URI uri;

        private ResolvingFutureCallback(IProgressMonitor monitor, URI uri) {
            this.monitor = monitor;
            this.uri = uri;
        }

        public void onSuccess(Object result) {
            try {
                if (!ThreadedModelResolver.this.isInterruptedOrCanceled(this.monitor)) {
                    this.monitor.worked(1);
                }
            }
            finally {
                ThreadedModelResolver.this.finalizeResolvingTask(this.uri);
            }
        }

        public void onFailure(Throwable t) {
            try {
                if (!ThreadedModelResolver.this.isInterruptedOrCanceled(this.monitor)) {
                    this.monitor.worked(1);
                    ThreadedModelResolver.this.safeMergeDiagnostic(BasicDiagnostic.toDiagnostic((Throwable)t));
                }
            }
            finally {
                ThreadedModelResolver.this.finalizeResolvingTask(this.uri);
            }
        }
    }

    private class ResourceResolver
    implements Runnable {
        private final SynchronizedResourceSet resourceSet;
        private final URI uri;
        private final ThreadSafeProgressMonitor monitor;

        public ResourceResolver(SynchronizedResourceSet resourceSet, URI uri, ThreadSafeProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.uri = uri;
            this.monitor = monitor;
        }

        public void run() {
            if (ThreadedModelResolver.this.isInterruptedOrCanceled((IProgressMonitor)this.monitor)) {
                ThreadedModelResolver.this.demandResolvingAndUnloadingPoolShutdown();
                return;
            }
            Resource resource = this.resourceSet.loadResource(this.uri);
            Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
            if (resourceDiagnostic.getSeverity() >= 2) {
                ThreadedModelResolver.this.safeMergeDiagnostic(resourceDiagnostic);
            }
            ThreadedModelResolver.this.dependencyGraph.add(this.uri);
            if (ThreadedModelResolver.this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                Set<URI> crossReferencedResources = this.resourceSet.discoverCrossReferences(resource, (IProgressMonitor)this.monitor);
                ThreadedModelResolver.this.dependencyGraph.addChildren(this.uri, crossReferencedResources);
                for (URI crossRef : crossReferencedResources) {
                    if (ThreadedModelResolver.this.isInterruptedOrCanceled((IProgressMonitor)this.monitor)) {
                        ThreadedModelResolver.this.demandResolvingAndUnloadingPoolShutdown();
                        break;
                    }
                    ThreadedModelResolver.this.demandResolve(this.resourceSet, crossRef, this.monitor);
                }
            }
            ThreadedModelResolver.this.demandUnload(this.resourceSet, resource, this.monitor);
        }
    }

    private static class ResourceUnloader
    implements Runnable {
        private final SynchronizedResourceSet resourceSet;
        private final Resource resource;
        private final IProgressMonitor monitor;

        public ResourceUnloader(SynchronizedResourceSet resourceSet, Resource resource, IProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.resource = resource;
            this.monitor = monitor;
        }

        public void run() {
            this.resourceSet.unload(this.resource, this.monitor);
        }
    }
}

