/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IViewerCreator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.ForwardingCompareInput;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

public class TextFallbackCompareViewerCreator
implements IViewerCreator {
    public Viewer createViewer(Composite parent, CompareConfiguration config) {
        return new TextFallbackMergeViewer(parent, config);
    }

    private static final class TextFallbackMergeViewer
    extends TextMergeViewer {
        private Object originalInput;

        private TextFallbackMergeViewer(Composite parent, CompareConfiguration configuration) {
            super(parent, configuration);
        }

        public void setInput(Object input) {
            this.originalInput = input;
            if (input instanceof CompareInputAdapter) {
                Notifier target = ((CompareInputAdapter)((Object)input)).getTarget();
                EObject data = ((TreeNode)target).getData();
                Comparison comparison = ComparisonUtil.getComparison((EObject)data);
                if (comparison != null) {
                    ICompareInput compareInput = (ICompareInput)EcoreUtil.getAdapter((List)comparison.eAdapters(), ICompareInput.class);
                    if (compareInput instanceof ForwardingCompareInput) {
                        super.setInput((Object)((ForwardingCompareInput)compareInput).delegate());
                    } else {
                        EMFCompareIDEUIPlugin.getDefault().log(4, "Comparison cannot be adapted to ICompareInput.");
                    }
                } else {
                    EMFCompareIDEUIPlugin.getDefault().log(4, "Cannot find a comparison from input " + input);
                }
            } else if (input instanceof ForwardingCompareInput) {
                super.setInput((Object)((ForwardingCompareInput)((Object)input)).delegate());
            } else {
                super.setInput(input);
            }
        }

        public Object getInput() {
            return this.originalInput;
        }

        protected void handleDispose(DisposeEvent event) {
            super.handleDispose(event);
            this.originalInput = null;
        }

        public String getTitle() {
            return EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.title");
        }
    }
}

