/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.conflict;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.internal.SubMatchIterator;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConflictDetector
implements IConflictDetector {
    @Override
    public void detect(Comparison comparison, Monitor monitor) {
        EList<Diff> differences = comparison.getDifferences();
        int diffCount = differences.size();
        int i = 0;
        while (i < diffCount) {
            Diff diff = (Diff)differences.get(i);
            ConflictCandidateFilter candidateFilter = new ConflictCandidateFilter(diff);
            this.checkConflict(comparison, diff, Iterables.filter(differences, (Predicate)candidateFilter));
            ++i;
        }
    }

    protected void checkConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        if (diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment()) {
            this.checkContainmentConflict(comparison, (ReferenceChange)diff, Iterables.filter(candidates, ReferenceChange.class));
        } else if (diff instanceof ResourceAttachmentChange) {
            this.checkResourceAttachmentConflict(comparison, (ResourceAttachmentChange)diff, candidates);
        } else if (ComparisonUtil.isFeatureMapContainment(diff)) {
            this.checkContainmentFeatureMapConflict(comparison, (FeatureMapChange)diff, Iterables.filter(candidates, FeatureMapChange.class));
        } else {
            switch (diff.getKind()) {
                case DELETE: {
                    this.checkFeatureDeleteConflict(comparison, diff, candidates);
                    break;
                }
                case CHANGE: {
                    this.checkFeatureChangeConflict(comparison, diff, candidates);
                    break;
                }
                case MOVE: {
                    this.checkFeatureMoveConflict(comparison, diff, candidates);
                    break;
                }
                case ADD: {
                    this.checkFeatureAddConflict(comparison, diff, candidates);
                    break;
                }
            }
        }
    }

    protected void checkContainmentConflict(Comparison comparison, ReferenceChange diff, Iterable<ReferenceChange> candidates) {
        Match valueMatch = comparison.getMatch(diff.getValue());
        for (ReferenceChange candidate : candidates) {
            EObject candidateValue = candidate.getValue();
            if (valueMatch.getLeft() != candidateValue && valueMatch.getRight() != candidateValue && valueMatch.getOrigin() != candidateValue) continue;
            this.checkContainmentConflict(comparison, diff, candidate);
        }
        if (diff.getKind() == DifferenceKind.DELETE) {
            ConflictCandidateFilter candidateFilter = new ConflictCandidateFilter(diff);
            DiffTreeIterator diffIterator = new DiffTreeIterator(valueMatch);
            diffIterator.setFilter(candidateFilter);
            diffIterator.setPruningFilter(this.isContainmentDelete());
            while (diffIterator.hasNext()) {
                Diff extendedCandidate = diffIterator.next();
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) {
                    this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    private Predicate<? super Match> isContainmentDelete() {
        return new Predicate<Match>(){

            public boolean apply(Match input) {
                return input.getOrigin() != null && (input.getLeft() == null || input.getRight() == null);
            }
        };
    }

    protected void checkContainmentConflict(Comparison comparison, ReferenceChange diff, ReferenceChange candidate) {
        boolean candidateIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(candidate);
        if (candidate.getReference().isContainment()) {
            ConflictKind kind = ConflictKind.REAL;
            boolean diffIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(diff);
            if (diffIsDelete && candidateIsDelete) {
                kind = ConflictKind.PSEUDO;
            } else if (diff.getMatch() == candidate.getMatch() && diff.getReference() == candidate.getReference() && !diffIsDelete && !candidateIsDelete && this.matchingIndices(comparison, diff.getMatch(), (EStructuralFeature)diff.getReference(), diff.getValue(), candidate.getValue())) {
                kind = ConflictKind.PSEUDO;
            }
            this.conflictOn(comparison, diff, candidate, kind);
        } else if (diff.getKind() == DifferenceKind.DELETE && !candidateIsDelete) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkContainmentFeatureMapConflict(Comparison comparison, FeatureMapChange diff, Iterable<FeatureMapChange> candidates) {
        FeatureMap.Entry entry = (FeatureMap.Entry)diff.getValue();
        entry.getEStructuralFeature();
        Object value = entry.getValue();
        Match valueMatch = value instanceof EObject ? comparison.getMatch((EObject)value) : diff.getMatch();
        for (FeatureMapChange candidate : candidates) {
            FeatureMap.Entry candidateEntry = (FeatureMap.Entry)candidate.getValue();
            Object candidateValue = candidateEntry.getValue();
            if (valueMatch.getLeft() != candidateValue && valueMatch.getRight() != candidateValue && valueMatch.getOrigin() != candidateValue) continue;
            this.checkContainmentFeatureMapConflict(comparison, diff, candidate);
        }
        if (diff.getKind() == DifferenceKind.DELETE) {
            ConflictCandidateFilter candidateFilter = new ConflictCandidateFilter(diff);
            DiffTreeIterator diffIterator = new DiffTreeIterator(valueMatch);
            diffIterator.setFilter(candidateFilter);
            diffIterator.setPruningFilter(this.isContainmentDelete());
            while (diffIterator.hasNext()) {
                Diff extendedCandidate = diffIterator.next();
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) {
                    this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    protected void checkContainmentFeatureMapConflict(Comparison comparison, FeatureMapChange diff, FeatureMapChange candidate) {
        boolean candidateIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(candidate);
        if (ComparisonUtil.isFeatureMapContainment(candidate)) {
            ConflictKind kind = ConflictKind.REAL;
            boolean diffIsDelete = ComparisonUtil.isDeleteOrUnsetDiff(diff);
            if (diffIsDelete && candidateIsDelete) {
                kind = ConflictKind.PSEUDO;
            } else if (diff.getMatch() == candidate.getMatch() && diff.getAttribute() == candidate.getAttribute() && !diffIsDelete && !candidateIsDelete && this.matchingIndices(comparison, diff.getMatch(), (EStructuralFeature)diff.getAttribute(), diff.getValue(), candidate.getValue()) && this.haveSameKey(diff, candidate)) {
                kind = ConflictKind.PSEUDO;
            }
            this.conflictOn(comparison, diff, candidate, kind);
        } else if (diff.getKind() == DifferenceKind.DELETE && !candidateIsDelete) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    private boolean haveSameKey(FeatureMapChange left, FeatureMapChange right) {
        FeatureMap.Entry leftEntry = (FeatureMap.Entry)left.getValue();
        FeatureMap.Entry rightEntry = (FeatureMap.Entry)right.getValue();
        return leftEntry.getEStructuralFeature().equals(rightEntry.getEStructuralFeature());
    }

    protected void checkFeatureChangeConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object changedValue;
        if (diff instanceof ReferenceChange) {
            changedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            changedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            changedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.CHANGE) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : (candidate instanceof AttributeChange ? ((AttributeChange)candidate).getValue() : (candidate instanceof FeatureMapChange ? ((FeatureMap.Entry)((FeatureMapChange)candidate).getValue()).getValue() : null));
            if (diff.getMatch() != candidate.getMatch()) continue;
            if (equalityHelper.matchingValues(changedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            if (diff instanceof FeatureMapChange) continue;
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkFeatureMoveConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object changedValue;
        if (diff instanceof ReferenceChange) {
            changedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            changedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            changedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.MOVE) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : (candidate instanceof AttributeChange ? ((AttributeChange)candidate).getValue() : (candidate instanceof FeatureMapChange ? ((FeatureMap.Entry)((FeatureMapChange)candidate).getValue()).getValue() : null));
            if (diff.getMatch() != candidate.getMatch() || !comparison.getEqualityHelper().matchingValues(changedValue, candidateValue)) continue;
            if (this.matchingIndices(comparison, diff.getMatch(), (EStructuralFeature)feature, changedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkFeatureDeleteConflict(Comparison comparison, Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object deletedValue;
        if (diff instanceof ReferenceChange) {
            deletedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            deletedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            deletedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && (input.getKind() == DifferenceKind.MOVE || input.getKind() == DifferenceKind.DELETE)) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        for (Diff candidate : refinedCandidates) {
            Object movedValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : (candidate instanceof AttributeChange ? ((AttributeChange)candidate).getValue() : (candidate instanceof FeatureMapChange ? ((FeatureMap.Entry)((FeatureMapChange)candidate).getValue()).getValue() : null));
            if (!comparison.getEqualityHelper().matchingValues(deletedValue, movedValue)) continue;
            if (candidate.getKind() == DifferenceKind.MOVE) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
        }
    }

    protected void checkFeatureAddConflict(Comparison comparison, final Diff diff, Iterable<Diff> candidates) {
        EReference feature;
        Object addedValue;
        if (diff instanceof ReferenceChange) {
            addedValue = ((ReferenceChange)diff).getValue();
            feature = ((ReferenceChange)diff).getReference();
        } else if (diff instanceof AttributeChange) {
            addedValue = ((AttributeChange)diff).getValue();
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof FeatureMapChange) {
            addedValue = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue();
            feature = ((FeatureMapChange)diff).getAttribute();
        } else {
            return;
        }
        Iterable refinedCandidates = Iterables.filter(candidates, (Predicate)new Predicate<Diff>((EStructuralFeature)feature){
            private final /* synthetic */ EStructuralFeature val$feature;
            {
                this.val$feature = eStructuralFeature;
            }

            public boolean apply(Diff input) {
                boolean apply = false;
                if (input != null && input.getKind() == DifferenceKind.ADD && diff.getMatch() == input.getMatch()) {
                    if (input instanceof ReferenceChange) {
                        apply = ((ReferenceChange)input).getReference() == this.val$feature;
                    } else if (input instanceof AttributeChange) {
                        apply = ((AttributeChange)input).getAttribute() == this.val$feature;
                    } else if (input instanceof FeatureMapChange) {
                        apply = ((FeatureMapChange)input).getAttribute() == this.val$feature;
                    }
                }
                return apply;
            }
        });
        for (Diff candidate : refinedCandidates) {
            Object candidateValue = candidate instanceof ReferenceChange ? ((ReferenceChange)candidate).getValue() : (candidate instanceof AttributeChange ? ((AttributeChange)candidate).getValue() : (candidate instanceof FeatureMapChange ? ((FeatureMap.Entry)((FeatureMapChange)candidate).getValue()).getValue() : null));
            if (!feature.isUnique() || !comparison.getEqualityHelper().matchingValues(addedValue, candidateValue)) continue;
            if (diff instanceof FeatureMapChange) {
                EStructuralFeature key2;
                EStructuralFeature key1 = ((FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getEStructuralFeature();
                if (key1.equals(key2 = ((FeatureMap.Entry)((FeatureMapChange)candidate).getValue()).getEStructuralFeature())) {
                    this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                    continue;
                }
                if (!ComparisonUtil.isFeatureMapContainment(diff)) continue;
                this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
                continue;
            }
            if (this.matchingIndices(comparison, diff.getMatch(), (EStructuralFeature)feature, addedValue, candidateValue)) {
                this.conflictOn(comparison, diff, candidate, ConflictKind.PSEUDO);
                continue;
            }
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    protected void checkResourceAttachmentConflict(Comparison comparison, ResourceAttachmentChange diff, Iterable<Diff> candidates) {
        Match match = diff.getMatch();
        EObject leftVal = match.getLeft();
        EObject rightVal = match.getRight();
        EObject originVal = match.getOrigin();
        for (Diff candidate : candidates) {
            if (candidate instanceof ReferenceChange) {
                EObject candidateValue = ((ReferenceChange)candidate).getValue();
                if (candidateValue != leftVal && candidateValue != rightVal && candidateValue != originVal) continue;
                this.checkResourceAttachmentConflict(comparison, diff, (ReferenceChange)candidate);
                continue;
            }
            if (!(candidate instanceof ResourceAttachmentChange) || match != candidate.getMatch()) continue;
            ConflictKind kind = ConflictKind.REAL;
            if (candidate.getKind() == DifferenceKind.DELETE && diff.getKind() == DifferenceKind.DELETE) {
                kind = ConflictKind.PSEUDO;
            } else if (candidate.getKind() == DifferenceKind.ADD && diff.getKind() == DifferenceKind.ADD) {
                Resource candidateRes;
                Resource diffRes;
                if (diff.getSource() == DifferenceSource.LEFT) {
                    diffRes = match.getLeft().eResource();
                    candidateRes = match.getRight().eResource();
                } else {
                    diffRes = match.getRight().eResource();
                    candidateRes = match.getLeft().eResource();
                }
                if (this.getMatchResource(comparison, diffRes) == this.getMatchResource(comparison, candidateRes)) {
                    kind = ConflictKind.PSEUDO;
                }
            }
            this.conflictOn(comparison, diff, candidate, kind);
        }
        if (diff.getKind() == DifferenceKind.DELETE) {
            ConflictCandidateFilter candidateFilter = new ConflictCandidateFilter(diff);
            for (Diff extendedCandidate : Iterables.filter(match.getAllDifferences(), (Predicate)candidateFilter)) {
                if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) {
                    this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflictOn(comparison, diff, extendedCandidate, ConflictKind.REAL);
            }
        }
    }

    protected MatchResource getMatchResource(Comparison comparison, Resource resource) {
        EList<MatchResource> matchedResources = comparison.getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = null;
        int i = 0;
        while (i < size && soughtMatch == null) {
            MatchResource matchRes = (MatchResource)matchedResources.get(i);
            if (matchRes.getRight() == resource || matchRes.getLeft() == resource || matchRes.getOrigin() == resource) {
                soughtMatch = matchRes;
            }
            ++i;
        }
        if (soughtMatch == null) {
            throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingMatch", resource.getURI().lastSegment()));
        }
        return soughtMatch;
    }

    protected void checkResourceAttachmentConflict(Comparison comparison, ResourceAttachmentChange diff, ReferenceChange candidate) {
        if (candidate.getReference().isContainment()) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        } else if (diff.getKind() == DifferenceKind.DELETE && candidate.getKind() != DifferenceKind.DELETE) {
            this.conflictOn(comparison, diff, candidate, ConflictKind.REAL);
        }
    }

    private boolean matchingIndices(Comparison comparison, Match match, EStructuralFeature feature, Object value1, Object value2) {
        boolean matching = false;
        if (feature.isMany()) {
            List leftValues = (List)ReferenceUtil.safeEGet(match.getLeft(), feature);
            List rightValues = (List)ReferenceUtil.safeEGet(match.getRight(), feature);
            int leftIndex = -1;
            int rightIndex = -1;
            int i = 0;
            while (i < leftValues.size()) {
                Object left = leftValues.get(i);
                if (comparison.getEqualityHelper().matchingValues(left, value1)) break;
                if (!this.hasDiff(match, feature, left) && !this.hasDeleteDiff(match, feature, left)) {
                    ++leftIndex;
                }
                ++i;
            }
            i = 0;
            while (i < rightValues.size()) {
                Object right = rightValues.get(i);
                if (comparison.getEqualityHelper().matchingValues(right, value2)) break;
                if (!this.hasDiff(match, feature, right) && !this.hasDeleteDiff(match, feature, right)) {
                    ++rightIndex;
                }
                ++i;
            }
            matching = leftIndex == rightIndex;
        } else {
            matching = true;
        }
        return matching;
    }

    private boolean hasDiff(Match match, EStructuralFeature feature, Object value) {
        return Iterables.any(match.getDifferences(), (Predicate)Predicates.and(EMFComparePredicates.onFeature(feature.getName()), EMFComparePredicates.valueIs(value)));
    }

    private boolean hasDeleteDiff(Match match, EStructuralFeature feature, Object value) {
        Match valueMatch;
        Comparison comparison = match.getComparison();
        Object expectedValue = value instanceof EObject && comparison.isThreeWay() ? ((valueMatch = comparison.getMatch((EObject)value)) != null ? valueMatch.getOrigin() : value) : value;
        return Iterables.any(match.getDifferences(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.onFeature(feature.getName()), EMFComparePredicates.valueIs(expectedValue), EMFComparePredicates.ofKind(DifferenceKind.DELETE)}));
    }

    protected void conflictOn(Comparison comparison, Diff diff1, Diff diff2, ConflictKind kind) {
        Equivalence equivalence;
        Conflict conflict = null;
        Conflict toBeMerged = null;
        if (diff1.getConflict() != null) {
            conflict = diff1.getConflict();
            if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                conflict.setKind(kind);
            }
            if (diff2.getConflict() != null) {
                toBeMerged = diff2.getConflict();
            }
        } else if (diff2.getConflict() != null) {
            conflict = diff2.getConflict();
            if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                conflict.setKind(kind);
            }
        } else if (diff1.getEquivalence() != null) {
            equivalence = diff1.getEquivalence();
            for (Diff equ : equivalence.getDifferences()) {
                if (equ.getConflict() == null) continue;
                conflict = equ.getConflict();
                if (conflict.getKind() == ConflictKind.PSEUDO && conflict.getKind() != kind) {
                    conflict.setKind(kind);
                }
                if (diff2.getConflict() == null) break;
                toBeMerged = diff2.getConflict();
                break;
            }
        } else if (diff2.getEquivalence() != null) {
            equivalence = diff2.getEquivalence();
            for (Diff equ : equivalence.getDifferences()) {
                if (equ.getConflict() == null) continue;
                conflict = equ.getConflict();
                if (conflict.getKind() != ConflictKind.PSEUDO || conflict.getKind() == kind) break;
                conflict.setKind(kind);
                break;
            }
        }
        if (conflict == null) {
            conflict = CompareFactory.eINSTANCE.createConflict();
            conflict.setKind(kind);
            comparison.getConflicts().add((Object)conflict);
        }
        EList<Diff> conflictDiffs = conflict.getDifferences();
        if (toBeMerged != null) {
            for (Diff aDiff : Lists.newArrayList(toBeMerged.getDifferences())) {
                if (conflictDiffs.contains(aDiff)) continue;
                conflictDiffs.add(aDiff);
            }
            if (toBeMerged.getKind() == ConflictKind.REAL && conflict.getKind() != ConflictKind.REAL) {
                conflict.setKind(ConflictKind.REAL);
            }
            EcoreUtil.remove((EObject)toBeMerged);
            toBeMerged.getDifferences().clear();
        }
        if (!conflict.getDifferences().contains((Object)diff1)) {
            conflict.getDifferences().add((Object)diff1);
        }
        if (!conflict.getDifferences().contains((Object)diff2)) {
            conflict.getDifferences().add((Object)diff2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConflictCandidateFilter
    implements Predicate<Diff> {
        private final Diff reference;

        public ConflictCandidateFilter(Diff reference) {
            this.reference = reference;
        }

        public boolean apply(Diff input) {
            return this.canConflictWith(this.reference, input);
        }

        private boolean canConflictWith(Diff diff1, Diff diff2) {
            if (diff1 == diff2 || diff1.getSource() == diff2.getSource()) {
                return false;
            }
            Conflict conflict = diff1.getConflict();
            boolean canConflict = false;
            if (conflict == null || !conflict.getDifferences().contains((Object)diff2)) {
                canConflict = diff1.getMatch() != diff2.getMatch() && diff2 instanceof ReferenceChange && ((ReferenceChange)diff2).getReference().isContainment() ? !ComparisonUtil.isDeleteOrUnsetDiff(diff2) : true;
            }
            return canConflict;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiffTreeIterator
    implements Iterator<Diff> {
        private final TreeIterator<Match> subMatchIterator;
        private Iterator<Diff> diffIterator;
        private Match current;
        private Diff nextDiff;
        private Predicate<? super Diff> filter = Predicates.alwaysTrue();
        private Predicate<? super Match> pruningFilter = Predicates.alwaysFalse();

        public DiffTreeIterator(Match start) {
            this.current = start;
            this.subMatchIterator = new SubMatchIterator(start);
            this.diffIterator = start.getDifferences().iterator();
        }

        public void setFilter(Predicate<? super Diff> filter) {
            this.filter = filter;
        }

        public void setPruningFilter(Predicate<? super Match> pruningFilter) {
            this.pruningFilter = pruningFilter;
        }

        @Override
        public boolean hasNext() {
            if (this.nextDiff != null) {
                return true;
            }
            if (!this.diffIterator.hasNext()) {
                this.computeNextMatch();
            }
            while (this.nextDiff == null && this.diffIterator.hasNext()) {
                Diff next = this.diffIterator.next();
                if (!this.filter.apply((Object)next)) continue;
                this.nextDiff = next;
            }
            return this.nextDiff != null;
        }

        private void computeNextMatch() {
            Match old = this.current;
            while (this.current == old && this.subMatchIterator.hasNext()) {
                Match next = (Match)this.subMatchIterator.next();
                if (this.pruningFilter.apply((Object)next)) {
                    this.subMatchIterator.prune();
                    continue;
                }
                this.current = next;
                this.diffIterator = this.current.getDifferences().iterator();
            }
        }

        @Override
        public Diff next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Diff next = this.nextDiff;
            this.nextDiff = null;
            return next;
        }

        @Override
        public void remove() {
            this.diffIterator.remove();
        }
    }
}

