/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;

public class AttributeChangeMerger
extends AbstractMerger {
    public boolean isMergerFor(Diff target) {
        return target instanceof AttributeChange;
    }

    protected void accept(Diff diff, boolean rightToLeft) {
        AttributeChange attributeChange = (AttributeChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.addInTarget(attributeChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.removeFromTarget(attributeChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(attributeChange, rightToLeft);
                break;
            }
            case CHANGE: {
                this.changeValue(attributeChange, rightToLeft);
                break;
            }
        }
    }

    protected void reject(Diff diff, boolean rightToLeft) {
        AttributeChange attributeChange = (AttributeChange)diff;
        switch (diff.getKind()) {
            case ADD: {
                this.removeFromTarget(attributeChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.addInTarget(attributeChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(attributeChange, rightToLeft);
                break;
            }
            case CHANGE: {
                this.changeValue(attributeChange, rightToLeft);
                break;
            }
        }
    }

    protected void addInTarget(AttributeChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        if (expectedContainer != null) {
            Comparison comparison = match.getComparison();
            EAttribute attribute = diff.getAttribute();
            Object expectedValue = diff.getValue();
            if (attribute.isMany()) {
                int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
                List targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)attribute);
                this.addAt(targetList, expectedValue, insertionIndex);
            } else {
                ReferenceUtil.safeESet(expectedContainer, (EStructuralFeature)attribute, expectedValue);
            }
        }
    }

    protected void removeFromTarget(AttributeChange diff, boolean rightToLeft) {
        EObject currentContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        if (currentContainer != null) {
            Object expectedValue = diff.getValue();
            EAttribute attribute = diff.getAttribute();
            if (attribute.isMany()) {
                List targetList = (List)ReferenceUtil.safeEGet(currentContainer, (EStructuralFeature)attribute);
                targetList.remove(expectedValue);
            } else {
                currentContainer.eUnset((EStructuralFeature)attribute);
            }
        }
    }

    protected void moveElement(AttributeChange diff, boolean rightToLeft) {
        EObject expectedContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        if (expectedContainer != null) {
            Comparison comparison = diff.getMatch().getComparison();
            Object expectedValue = diff.getValue();
            this.doMove(diff, comparison, expectedContainer, expectedValue, rightToLeft);
        }
    }

    protected void doMove(AttributeChange diff, Comparison comparison, EObject expectedContainer, Object expectedValue, boolean rightToLeft) {
        EAttribute attribute = diff.getAttribute();
        if (attribute.isMany()) {
            List targetList;
            int currentIndex;
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            if (insertionIndex > (currentIndex = (targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)attribute)).indexOf(expectedValue))) {
                --insertionIndex;
            }
            if (targetList instanceof EList) {
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    ((EList)targetList).move(targetList.size() - 1, expectedValue);
                } else {
                    ((EList)targetList).move(insertionIndex, expectedValue);
                }
            } else {
                targetList.remove(expectedValue);
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    targetList.add(expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            }
        } else {
            ReferenceUtil.safeESet(expectedContainer, (EStructuralFeature)attribute, expectedValue);
        }
    }

    @Deprecated
    protected void resetInTarget(AttributeChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EAttribute attribute = diff.getAttribute();
        EObject targetContainer = rightToLeft ? match.getLeft() : match.getRight();
        EObject originContainer = match.getComparison().isThreeWay() ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        if (originContainer == null || !ReferenceUtil.safeEIsSet(targetContainer, (EStructuralFeature)attribute) || !ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)attribute)) {
            targetContainer.eUnset((EStructuralFeature)attribute);
        } else {
            Object expectedValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)attribute);
            ReferenceUtil.safeESet(targetContainer, (EStructuralFeature)attribute, expectedValue);
        }
    }

    protected void changeValue(AttributeChange diff, boolean rightToLeft) {
        boolean isUnset;
        boolean resetToOrigin;
        Match match = diff.getMatch();
        EAttribute attribute = diff.getAttribute();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        boolean bl = resetToOrigin = diff.getSource() == DifferenceSource.LEFT && rightToLeft || diff.getSource() == DifferenceSource.RIGHT && !rightToLeft;
        EObject originContainer = resetToOrigin && match.getComparison().isThreeWay() ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        Object value = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)attribute);
        Object targetValue = expectedContainer instanceof DynamicEObjectImpl && value instanceof EEnumLiteral ? ((EEnum)((EEnumLiteral)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)attribute)).eContainer()).getEEnumLiteral(((ENamedElement)value).getName()) : value;
        Object defaultValue = attribute.getDefaultValue();
        boolean bl2 = isUnset = targetValue == null || targetValue.equals(defaultValue) || defaultValue == null && "".equals(targetValue);
        if (isUnset) {
            expectedContainer.eUnset((EStructuralFeature)attribute);
        } else {
            ReferenceUtil.safeESet(expectedContainer, (EStructuralFeature)attribute, targetValue);
        }
    }

    protected int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        return DiffUtil.findInsertionIndex(comparison, diff, rightToLeft);
    }
}

