/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.ILogicalModelViewHandler;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.LogicalModelViewHandlerUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLogicalModelViewHandler
implements ILogicalModelViewHandler {
    @Override
    public boolean canHandle(IWorkbenchPart part) {
        Collection<IFile> files = this.getFilesFromWorkbenchPart(part);
        for (IFile file : files) {
            if (!LogicalModelViewHandlerUtil.isEMFCompareCompliantFile(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IFile> getFilesFromWorkbenchPart(IWorkbenchPart part) {
        return Collections.emptySet();
    }

    @Override
    public Collection<IResource> getLogicalModelResources(IWorkbenchPart part, IProgressMonitor monitor) {
        LinkedHashSet resources = Sets.newLinkedHashSet();
        Collection<IFile> files = this.getFilesFromWorkbenchPart(part);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100).setWorkRemaining(files.size());
        for (IFile file : files) {
            resources.addAll(LogicalModelViewHandlerUtil.getLogicalModelResources(file, (IProgressMonitor)subMonitor.newChild(1)));
        }
        return resources;
    }

    @Override
    public boolean canHandle(IWorkbenchPart part, ISelection selection) {
        Collection<IFile> files = this.getFilesFromSelection(selection);
        for (IFile file : files) {
            if (!LogicalModelViewHandlerUtil.isEMFCompareCompliantFile(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IFile> getFilesFromSelection(ISelection selection) {
        return Collections.emptySet();
    }

    @Override
    public Collection<IResource> getLogicalModelResources(ISelection selection, IProgressMonitor monitor) {
        LinkedHashSet resources = Sets.newLinkedHashSet();
        Collection<IFile> files = this.getFilesFromSelection(selection);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100).setWorkRemaining(files.size());
        for (IFile file : files) {
            resources.addAll(LogicalModelViewHandlerUtil.getLogicalModelResources(file, (IProgressMonitor)subMonitor.newChild(1)));
        }
        return resources;
    }
}

