/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.compare.internal.dmp.LineBasedDiff;
import org.eclipse.emf.compare.internal.dmp.diff_match_patch;

public class ThreeWayTextDiff {
    private static final String NL = "\n";
    private final LineOperations leftOperations;
    private final LineOperations rightOperations;

    public ThreeWayTextDiff(String origin, String left, String right) {
        this.leftOperations = new LineOperations(origin, left);
        this.rightOperations = new LineOperations(origin, right);
    }

    public String getOrigin() {
        return this.leftOperations.getOrigin();
    }

    public String getLeft() {
        return this.leftOperations.getRevised();
    }

    public String getRight() {
        return this.rightOperations.getRevised();
    }

    public boolean isConflicting() {
        boolean isConflicting = false;
        int numberOfLinesInOrigin = this.getNumberOfLinesInOrigin();
        int currentIndex = 0;
        while (currentIndex < numberOfLinesInOrigin) {
            if (this.isConflicting(currentIndex)) {
                isConflicting = true;
                break;
            }
            ++currentIndex;
        }
        return isConflicting;
    }

    private int getNumberOfLinesInOrigin() {
        String[] originLines = this.nullToEmpty(this.getOrigin()).split(NL);
        return originLines.length;
    }

    private boolean isConflicting(int lineIndex) {
        return this.isInsertInsertAt(lineIndex) || this.isInsertDeleteAt(lineIndex) || this.isDeleteInsertAt(lineIndex);
    }

    private boolean isInsertInsertAt(int lineIndex) {
        return this.leftOperations.isInsertAtOriginLineIndex(lineIndex) && this.rightOperations.isInsertAtOriginLineIndex(lineIndex);
    }

    private boolean isInsertDeleteAt(int lineIndex) {
        return this.leftOperations.isChangedAtOriginLineIndex(lineIndex) && this.rightOperations.isDeleteAtOriginLineIndex(lineIndex);
    }

    private boolean isDeleteInsertAt(int lineIndex) {
        return this.leftOperations.isDeleteAtOriginLineIndex(lineIndex) && this.rightOperations.isChangedAtOriginLineIndex(lineIndex);
    }

    public String getMerged() {
        String patchedLeft = this.rightOperations.apply(this.getLeft());
        String merged = this.nullIfUnset(patchedLeft);
        return merged;
    }

    private String nullIfUnset(String mergeResult) {
        if (mergeResult.length() < 1 && this.isLeftOrRightUnset()) {
            return null;
        }
        return mergeResult;
    }

    private boolean isLeftOrRightUnset() {
        return this.getOrigin() != null && (this.getLeft() == null || this.getRight() == null);
    }

    private String nullToEmpty(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineOperations {
        private final LineBasedDiff lbDiff = new LineBasedDiff();
        private String origin;
        private String revised;
        private LinkedList<diff_match_patch.Diff> diffs;
        private List<diff_match_patch.Operation> operations = new ArrayList<diff_match_patch.Operation>();

        public LineOperations(String origin, String revised) {
            this.origin = origin;
            this.revised = revised;
            this.diffs = this.computeLineBasedDiff(origin, revised);
            this.initialize();
        }

        public String getOrigin() {
            return this.origin;
        }

        public String getRevised() {
            return this.revised;
        }

        private void initialize() {
            for (diff_match_patch.Diff diff : this.diffs) {
                this.addLineOperations(diff);
            }
        }

        private LinkedList<diff_match_patch.Diff> computeLineBasedDiff(String original, String revision) {
            return this.lbDiff.computeLineBasedDiff(ThreeWayTextDiff.this.nullToEmpty(original), ThreeWayTextDiff.this.nullToEmpty(revision));
        }

        private void addLineOperations(diff_match_patch.Diff diff) {
            int numberOfLines = this.getNumberOfLines(diff);
            int i = 0;
            while (i < numberOfLines) {
                this.operations.add(diff.operation);
                ++i;
            }
        }

        private int getNumberOfLines(diff_match_patch.Diff diff) {
            return diff.text.split(ThreeWayTextDiff.NL).length;
        }

        public String apply(String original) {
            LinkedList<diff_match_patch.Patch> patches = this.computePatches();
            return (String)this.lbDiff.patch_apply(patches, ThreeWayTextDiff.this.nullToEmpty(original))[0];
        }

        private LinkedList<diff_match_patch.Patch> computePatches() {
            return this.lbDiff.patch_make(this.diffs);
        }

        public boolean isInsertAtOriginLineIndex(int originLineIndex) {
            int lineIndex = this.getRevisedLineIndexForOriginLineIndex(originLineIndex);
            return this.isInsertAt(lineIndex);
        }

        public boolean isDeleteAtOriginLineIndex(int originLineIndex) {
            int lineIndex = this.getRevisedLineIndexForOriginLineIndex(originLineIndex);
            return this.isDeleteAt(lineIndex);
        }

        public boolean isChangedAtOriginLineIndex(int originLineIndex) {
            int lineIndex = this.getRevisedLineIndexForOriginLineIndex(originLineIndex);
            return this.isChangedAt(lineIndex);
        }

        public int getRevisedLineIndexForOriginLineIndex(int originLineIndex) {
            int currentOriginLineIndex = 0;
            int lineIndex = 0;
            while (currentOriginLineIndex < originLineIndex) {
                diff_match_patch.Operation operation = this.getOperation(lineIndex);
                if (!this.isInsert(operation)) {
                    ++currentOriginLineIndex;
                }
                ++lineIndex;
            }
            return lineIndex;
        }

        private boolean isInsertAt(int lineIndex) {
            return this.hasIndex(lineIndex) && this.isInsert(this.getOperation(lineIndex));
        }

        private boolean isDeleteAt(int lineIndex) {
            return this.hasIndex(lineIndex) && this.isDelete(this.getOperation(lineIndex));
        }

        private boolean isChangedAt(int lineIndex) {
            return this.isDeleteAt(lineIndex) && this.isFollowedByInsert(lineIndex) || this.isInsertAt(lineIndex);
        }

        private boolean isFollowedByInsert(int lineIndex) {
            diff_match_patch.Operation nextOperation;
            int nextLineIndex = lineIndex + 1;
            boolean isFollowedByInsert = this.hasIndex(nextLineIndex) && !this.isEqual(this.getOperation(nextLineIndex)) ? this.isInsert(nextOperation = this.getOperation(nextLineIndex)) || this.isFollowedByInsert(nextLineIndex) : false;
            return isFollowedByInsert;
        }

        private diff_match_patch.Operation getOperation(int index) {
            return this.operations.get(index);
        }

        private boolean hasIndex(int index) {
            return this.operations.size() > index;
        }

        private boolean isInsert(diff_match_patch.Operation operation) {
            return diff_match_patch.Operation.INSERT.equals((Object)operation);
        }

        private boolean isDelete(diff_match_patch.Operation operation) {
            return diff_match_patch.Operation.DELETE.equals((Object)operation);
        }

        private boolean isEqual(diff_match_patch.Operation operation) {
            return diff_match_patch.Operation.EQUAL.equals((Object)operation);
        }
    }
}

