/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.provider.custom;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.internal.provider.custom.UMLDiffCustomItemProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;

public class OpaqueElementBodyChangeCustomItemProvider
extends UMLDiffCustomItemProvider {
    private final ExtendedAdapterFactoryItemDelegator itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public OpaqueElementBodyChangeCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)object;
        EObject discriminant = bodyChange.getDiscriminant();
        ComposedStyledString text = new ComposedStyledString();
        text.append(bodyChange.getLanguage());
        text.append(" body of ");
        text.append(this.itemDelegator.getText((Object)discriminant));
        text.append(" ");
        text.append(this.getChangeKindLabel(bodyChange));
        String opaqueElementType = this.getOpaqueElementTypeLabel(discriminant);
        return text.append(" [" + opaqueElementType + " body change]", IStyledString.Style.DECORATIONS_STYLER);
    }

    private String getChangeKindLabel(OpaqueElementBodyChange bodyChange) {
        String changeKindLabel;
        switch (bodyChange.getKind()) {
            case ADD: {
                changeKindLabel = "added";
                break;
            }
            case DELETE: {
                changeKindLabel = "deleted";
                break;
            }
            case MOVE: {
                changeKindLabel = "moved";
                break;
            }
            default: {
                changeKindLabel = "changed";
            }
        }
        return changeKindLabel;
    }

    private String getOpaqueElementTypeLabel(EObject element) {
        String opaqueElementTypeLabel = element instanceof OpaqueAction ? "opaque action" : (element instanceof OpaqueBehavior ? "opaque behavior" : (element instanceof OpaqueExpression ? "opaque expression" : ""));
        return opaqueElementTypeLabel;
    }
}

