/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupDescriptorWrapper;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceGroupProviderExtensionRegistryListener
extends AbstractRegistryEventListener {
    private static final int DEFAULT_RANK_VALUE = 0;
    static final String TAG_GROUP_PROVIDER = "group";
    static final String ATT_LABEL = "label";
    static final String ATT_DESCRIPTION = "description";
    static final String ATT_COMPARISON_TYPE = "type";
    static final String ATT_RANK = "rank";
    static final String ATT_CLASS = "class";
    private final IItemRegistry<IDifferenceGroupProvider.Descriptor> groupProviderRegistry;

    public DifferenceGroupProviderExtensionRegistryListener(String pluginID, String extensionPointID, ILog log, IItemRegistry<IDifferenceGroupProvider.Descriptor> registry) {
        super(pluginID, extensionPointID, log);
        this.groupProviderRegistry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (element.getName().equals(TAG_GROUP_PROVIDER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else if (element.getAttribute(ATT_LABEL) == null) {
                this.logMissingAttribute(element, ATT_LABEL);
                valid = false;
            } else if (element.getAttribute(ATT_RANK) != null) {
                try {
                    Integer.valueOf(element.getAttribute(ATT_RANK));
                }
                catch (NumberFormatException e) {
                    this.log(element, e);
                    return false;
                }
                valid = true;
            } else if (element.getAttribute(ATT_COMPARISON_TYPE) != null) {
                try {
                    IDifferenceGroupProvider.ComparisonType.valueOf(element.getAttribute(ATT_COMPARISON_TYPE));
                    valid = true;
                }
                catch (IllegalArgumentException e) {
                    this.log(element, e);
                    return false;
                }
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    protected boolean addedValid(IConfigurationElement element) {
        String description;
        String rankValue = element.getAttribute(ATT_RANK);
        int rank = rankValue == null ? 0 : Integer.valueOf(rankValue);
        String typeAttribute = element.getAttribute(ATT_COMPARISON_TYPE);
        IDifferenceGroupProvider.ComparisonType type = typeAttribute != null ? IDifferenceGroupProvider.ComparisonType.valueOf(typeAttribute) : IDifferenceGroupProvider.ComparisonType.BOTH;
        String label = element.getAttribute(ATT_LABEL);
        DifferenceGroupDescriptorWrapper itemDescriptor = new DifferenceGroupDescriptorWrapper(label, description = element.getAttribute(ATT_DESCRIPTION), element, rank, type);
        IItemDescriptor previous = this.groupProviderRegistry.add((IItemDescriptor)itemDescriptor);
        if (previous != null) {
            this.log(2, element, "The group provider descriptor'" + element.getAttribute(ATT_CLASS) + "' is registered twice.");
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.groupProviderRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

