/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.tree.TreeNode;

public class ResourceUIUtil {
    public static final String RESOURCES_GRAPH_ID = "org.eclipse.emf.compare.resources.graph";
    private static Function<EObject, EObject> TREE_NODE_DATA = new Function<EObject, EObject>(){

        public EObject apply(EObject node) {
            EObject data = node instanceof TreeNode ? ((TreeNode)node).getData() : node;
            return data;
        }
    };

    public static IGraphView<URI> getResourcesURIGraph() {
        return EMFCompareRCPPlugin.getDefault().getGraphView(RESOURCES_GRAPH_ID);
    }

    public static boolean isRootResource(URI uri) {
        return !ResourceUIUtil.isFragment(uri);
    }

    public static boolean isFragment(URI uri) {
        URI parentData;
        IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
        return uri != null && graph != null && (parentData = (URI)graph.getParentData((Object)uri)) != null;
    }

    public static boolean isFragment(Match rootMatch, IMergeViewer.MergeViewerSide side) {
        if (rootMatch != null && rootMatch.eContainer() instanceof Comparison) {
            URI uri = ResourceUIUtil.getDataURI(rootMatch, side);
            return ResourceUIUtil.isFragment(uri);
        }
        return false;
    }

    public static boolean isFirstLevelFragment(URI uri) {
        URI parentData;
        IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
        if (uri != null && graph != null && (parentData = (URI)graph.getParentData((Object)uri)) != null) {
            URI parent = parentData.trimFragment();
            return !ResourceUIUtil.isFragment(parent);
        }
        return false;
    }

    public static URI getRootResourceURI(URI uri) {
        URI uriRoot;
        IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
        if (uri != null && graph != null) {
            URI parentData = (URI)graph.getParentData((Object)uri);
            if (parentData == null) {
                uriRoot = uri;
            } else {
                URI parent = parentData.trimFragment();
                uriRoot = ResourceUIUtil.getRootResourceURI(parent);
            }
        } else {
            uriRoot = null;
        }
        return uriRoot;
    }

    public static URI getParentResourceURI(ResourceSet rs, URI uri) {
        Resource resource;
        Map.Entry<URI, Resource> entry = ResourceUIUtil.getResourceParent(rs, uri);
        URI parentURI = entry != null ? ((resource = entry.getValue()) != null ? entry.getKey().trimFragment() : null) : null;
        return parentURI;
    }

    public static Resource getParent(ResourceSet rs, URI uri) {
        URI parentData;
        IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
        Resource resource = uri != null && graph != null ? ((parentData = (URI)graph.getParentData((Object)uri)) != null ? rs.getResource(parentData.trimFragment(), false) : null) : null;
        return resource;
    }

    public static EObject getEObjectParent(ResourceSet rs, URI uri) {
        Resource resource;
        Map.Entry<URI, Resource> entry = ResourceUIUtil.getResourceParent(rs, uri);
        EObject eObject = entry != null ? ((resource = entry.getValue()) != null ? resource.getEObject(entry.getKey().fragment()) : null) : null;
        return eObject;
    }

    private static Map.Entry<URI, Resource> getResourceParent(ResourceSet rs, URI uri) {
        URI parentData;
        Map.Entry<URI, Resource> entry = null;
        IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
        if (uri != null && graph != null && (parentData = (URI)graph.getParentData((Object)uri)) != null) {
            URI parent = parentData.trimFragment();
            Resource resourceParent = rs.getResource(parent, false);
            entry = resourceParent != null ? Maps.immutableEntry((Object)parentData, (Object)resourceParent) : ResourceUIUtil.getResourceParent(rs, parent);
        }
        return entry;
    }

    public static TreeNode getTreeNode(Collection<TreeNode> nodes, Match match) {
        for (TreeNode treeNode : nodes) {
            EObject data = (EObject)TREE_NODE_DATA.apply((Object)treeNode);
            if (!data.equals(match)) continue;
            return treeNode;
        }
        for (TreeNode treeNode : nodes) {
            TreeNode treeNode2 = ResourceUIUtil.getTreeNode((Collection<TreeNode>)treeNode.getChildren(), match);
            if (treeNode2 == null) continue;
            return treeNode2;
        }
        return null;
    }

    public static TreeNode getTreeNodeFromURI(Collection<TreeNode> nodes, URI uri) {
        for (TreeNode treeNode : nodes) {
            EObject data = (EObject)TREE_NODE_DATA.apply((Object)treeNode);
            URI dataURI = ResourceUIUtil.getDataURI((Match)data);
            if (!uri.equals(dataURI)) continue;
            return treeNode;
        }
        return null;
    }

    public static URI getDataURI(Match match) {
        Object resource = match.getLeft() != null ? match.getLeft().eResource() : (match.getRight() != null ? match.getRight().eResource() : (match.getOrigin() != null ? match.getOrigin().eResource() : null));
        URI uri = resource != null ? resource.getURI() : null;
        return uri;
    }

    public static Collection<URI> getDataURIs(Collection<Match> matches, IMergeViewer.MergeViewerSide side) {
        ArrayList uris = Lists.newArrayList();
        for (Match match : matches) {
            URI dataURI = ResourceUIUtil.getDataURI(match, side);
            if (dataURI == null) continue;
            uris.add(dataURI);
        }
        return uris;
    }

    public static URI getDataURI(Match match, IMergeViewer.MergeViewerSide side) {
        Object resource = IMergeViewer.MergeViewerSide.LEFT == side && match.getLeft() != null ? match.getLeft().eResource() : (IMergeViewer.MergeViewerSide.RIGHT == side && match.getRight() != null ? match.getRight().eResource() : (IMergeViewer.MergeViewerSide.ANCESTOR == side && match.getOrigin() != null ? match.getOrigin().eResource() : null));
        URI uri = resource != null ? resource.getURI() : null;
        return uri;
    }

    public static ResourceSet getDataResourceSet(Match match) {
        Object resource = match.getLeft() != null ? match.getLeft().eResource() : (match.getRight() != null ? match.getRight().eResource() : (match.getOrigin() != null ? match.getOrigin().eResource() : null));
        ResourceSet rs = resource != null ? resource.getResourceSet() : null;
        return rs;
    }

    public static ResourceSet getDataResourceSet(Match match, IMergeViewer.MergeViewerSide side) {
        Resource resource = IMergeViewer.MergeViewerSide.LEFT == side && match != null && match.getLeft() != null ? match.getLeft().eResource() : (IMergeViewer.MergeViewerSide.RIGHT == side && match != null && match.getRight() != null ? match.getRight().eResource() : (IMergeViewer.MergeViewerSide.ANCESTOR == side && match != null && match.getOrigin() != null ? match.getOrigin().eResource() : null));
        ResourceSet rs = resource != null ? resource.getResourceSet() : null;
        return rs;
    }

    public static boolean containsNotLoadedFragmentNodes(Collection<TreeNode> nodes) {
        int notLoadedFragments = 0;
        for (TreeNode node : nodes) {
            EObject data = (EObject)TREE_NODE_DATA.apply((Object)node);
            if (!(data instanceof NotLoadedFragmentMatch)) continue;
            ++notLoadedFragments;
        }
        return notLoadedFragments > 1;
    }

    public static Collection<Match> getNotLoadedFragmentMatches(Collection<IMergeViewerItem> items) {
        ArrayList notLoadedFragmentMatches = Lists.newArrayList();
        for (IMergeViewerItem item : items) {
            Object left = item.getLeft();
            if (!(left instanceof NotLoadedFragmentMatch)) continue;
            notLoadedFragmentMatches.add((NotLoadedFragmentMatch)left);
        }
        return notLoadedFragmentMatches;
    }

    public static String getResourceName(NotLoadedFragmentMatch match) {
        String name;
        Collection children = match.getChildren();
        if (Iterables.size((Iterable)children) == 1) {
            URI uri = ResourceUIUtil.getDataURI((Match)children.iterator().next());
            name = uri.lastSegment();
        } else {
            name = "";
        }
        return name;
    }

    public static Collection<Match> getChildrenMatchWithNotLoadedParent(Comparison comparison, Match match, IMergeViewer.MergeViewerSide side) {
        LinkedHashSet childrenMatches = Sets.newLinkedHashSet();
        EList matches = comparison.getMatches();
        IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
        if (graph == null) {
            return childrenMatches;
        }
        ResourceSet rs = ResourceUIUtil.getDataResourceSet(match, side);
        if (rs == null) {
            return childrenMatches;
        }
        for (Match rootMatch : matches) {
            if (!ResourceUIUtil.isFragment(rootMatch, side)) continue;
            URI uri = ResourceUIUtil.getDataURI(rootMatch, side);
            Resource resourceParent = ResourceUIUtil.getParent(rs, uri);
            URI parentData = (URI)graph.getParentData((Object)uri);
            boolean _continue = true;
            while (resourceParent == null && _continue) {
                if (parentData != null) {
                    resourceParent = ResourceUIUtil.getParent(rs, parentData.trimFragment());
                    parentData = (URI)graph.getParentData((Object)parentData.trimFragment());
                    continue;
                }
                _continue = false;
            }
            if (resourceParent == null || parentData == null) continue;
            EObject eObjectParent = resourceParent.getEObject(parentData.fragment());
            Match matchParent = match.getComparison().getMatch(eObjectParent);
            if (matchParent == null || !matchParent.equals(match)) continue;
            childrenMatches.add(rootMatch);
        }
        return childrenMatches;
    }

    public static boolean isChildOf(URI uri, Collection<URI> uris) {
        IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
        URI parentData = (URI)graph.getParentData((Object)uri);
        while (parentData != null) {
            URI parent = parentData.trimFragment();
            if (uris.contains(parent)) {
                return true;
            }
            parentData = (URI)graph.getParentData((Object)parent);
        }
        return false;
    }

    public static IMergeViewerItem createItemForNotLoadedFragmentMatch(Match match, IMergeViewer.MergeViewerSide side, Comparison comparison, AdapterFactory adapterFactory) {
        MergeViewerItem.Container container;
        URI uri;
        ResourceSet rs = ResourceUIUtil.getDataResourceSet(match, side);
        EObject firstLoadedParent = ResourceUIUtil.getEObjectParent(rs, uri = ResourceUIUtil.getDataURI(match, side));
        if (firstLoadedParent == null) {
            NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(match);
            container = new MergeViewerItem.Container(comparison, null, notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, side, adapterFactory);
        } else if (ResourceUIUtil.isRootResource(firstLoadedParent.eResource().getURI())) {
            Match matchParent = comparison.getMatch(firstLoadedParent);
            if (matchParent != null) {
                container = !comparison.getMatches().contains((Object)matchParent) ? new MergeViewerItem.Container(comparison, null, match.getLeft(), match.getRight(), match.getOrigin(), side, adapterFactory) : null;
            } else {
                NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(match);
                container = new MergeViewerItem.Container(comparison, null, notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, side, adapterFactory);
            }
        } else {
            container = null;
        }
        return container;
    }

    public static IMergeViewerItem addNewContainerForNotLoadedFragmentMatches(Collection<IMergeViewerItem> items, IMergeViewer.MergeViewerSide side, Comparison comparison, AdapterFactory adapterFactory) {
        MergeViewerItem.Container newContainer;
        Collection<Match> notLoadedFragmentMatches = ResourceUIUtil.getNotLoadedFragmentMatches(items);
        if (notLoadedFragmentMatches.size() > 1) {
            NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(notLoadedFragmentMatches);
            for (NotLoadedFragmentMatch match : Iterables.filter(notLoadedFragmentMatches, NotLoadedFragmentMatch.class)) {
                match.setName(ResourceUIUtil.getResourceName(match));
            }
            newContainer = new MergeViewerItem.Container(comparison, null, notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, side, adapterFactory);
        } else {
            newContainer = null;
        }
        return newContainer;
    }
}

