/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedImage;

public class OverlayImageProvider {
    private static final String CHG_OV = "chg_ov";
    private static final String DEL_OV = "del_ov";
    private static final String ADD_OV = "add_ov";
    private static final String MERGED_TO_RIGHT_OV = "merged_right_ov";
    private static final String MERGED_TO_LEFT_OV = "merged_left_ov";
    private static final String REJECTED_OV = "removed_ov";
    private static final String ACCEPTED_OV = "merged_ov";
    private final ResourceLocator fResourceLocator;

    public OverlayImageProvider(ResourceLocator resourceLocator) {
        this.fResourceLocator = resourceLocator;
    }

    public Object getComposedImage(Diff diff, Object imageToCompose) {
        String overlay = this.getImageOverlay(diff);
        return this.getComposedImage(imageToCompose, overlay);
    }

    public Object getComposedImage(Match match, Object imageToCompose) {
        String overlay = this.getImageOverlay();
        return this.getComposedImage(imageToCompose, overlay);
    }

    public Object getComposedImage(Object object, Object imageToCompose) {
        String overlay = "full/ovr16/match_ov";
        return this.getComposedImage(imageToCompose, overlay);
    }

    private Object getComposedImage(Object imageToCompose, String overlayPath) {
        ArrayList images = Lists.newArrayList();
        images.add(imageToCompose);
        if (overlayPath != null) {
            Object image = this.fResourceLocator.getImage(overlayPath);
            images.add(image);
        }
        return new ComposedImageExtension(images);
    }

    private String getImageOverlay(Diff diff) {
        Comparison comparison = ComparisonUtil.getComparison((Diff)diff);
        String path = "full/ovr16/";
        path = diff.getState() == DifferenceState.MERGED ? String.valueOf(path) + this.getMergedOverlay(diff) : (diff.getState() == DifferenceState.DISCARDED ? String.valueOf(path) + REJECTED_OV : (comparison.isThreeWay() ? String.valueOf(path) + this.getThreeWayOverlay(diff) : String.valueOf(path) + this.getTwoWayDiffOverlay(diff)));
        return path;
    }

    private String getThreeWayOverlay(Diff diff) {
        DifferenceKind diffKind = diff.getKind();
        DifferenceSource source = diff.getSource();
        StringBuilder path = new StringBuilder();
        if (EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)diff)) {
            path.append("conf");
            if (source == DifferenceSource.RIGHT) {
                path.append("r_");
            }
        } else if (EMFComparePredicates.canBeConsideredAsPseudoConflicting().apply((Object)diff)) {
            path.append("pconf");
            if (source == DifferenceSource.RIGHT) {
                path.append("r_");
            }
        } else {
            switch (source) {
                case LEFT: {
                    path.append("r_out");
                    break;
                }
                case RIGHT: {
                    path.append("r_in");
                    break;
                }
            }
        }
        switch (diffKind) {
            case ADD: {
                path.append(ADD_OV);
                break;
            }
            case DELETE: {
                path.append(DEL_OV);
                break;
            }
            case CHANGE: 
            case MOVE: {
                path.append(CHG_OV);
                break;
            }
        }
        return path.toString();
    }

    private String getMergedOverlay(Diff diff) {
        String path;
        block7: {
            block6: {
                Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)diff, IMergeData.class);
                if (adapter == null) break block6;
                IMergeData mergeData = (IMergeData)adapter;
                switch (mergeData.getMergeMode()) {
                    case LEFT_TO_RIGHT: {
                        path = MERGED_TO_RIGHT_OV;
                        break block7;
                    }
                    case RIGHT_TO_LEFT: {
                        path = MERGED_TO_LEFT_OV;
                        break block7;
                    }
                    case ACCEPT: {
                        path = ACCEPTED_OV;
                        break block7;
                    }
                    case REJECT: {
                        path = REJECTED_OV;
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            Match match = diff.getMatch();
            Comparison comparison = match.getComparison();
            path = comparison.isThreeWay() ? this.getThreeWayOverlay(diff) : this.getTwoWayDiffOverlay(diff);
        }
        return path;
    }

    private String getTwoWayDiffOverlay(Diff diff) {
        String path;
        DifferenceKind diffKind = diff.getKind();
        switch (diffKind) {
            case ADD: {
                path = ADD_OV;
                break;
            }
            case DELETE: {
                path = DEL_OV;
                break;
            }
            case CHANGE: 
            case MOVE: {
                path = CHG_OV;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return path;
    }

    private String getImageOverlay() {
        return "full/ovr16/match_ov";
    }

    private static final class ComposedImageExtension
    extends ComposedImage {
        private static final int X_OFFSET = 10;

        ComposedImageExtension(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List result = super.getDrawPoints(size);
            if (result.size() > 1) {
                ((ComposedImage.Point)result.get((int)1)).x = 10;
                ((ComposedImage.Point)result.get((int)1)).y = 2;
            }
            return result;
        }

        public ComposedImage.Size getSize(Collection<? extends ComposedImage.Size> sizes) {
            this.imageSizes = Lists.newArrayList(sizes);
            List<ComposedImage.Point> drawPoints = this.getDrawPoints(null);
            ComposedImage.Size result = new ComposedImage.Size();
            int i = 0;
            while (i < sizes.size()) {
                ComposedImage.Size size = (ComposedImage.Size)this.imageSizes.get(i);
                ComposedImage.Point point = drawPoints.get(i);
                result.width = Math.max(result.width, size.width + Math.abs(point.x));
                result.height = Math.max(result.height, size.height + Math.abs(point.y));
                ++i;
            }
            return result;
        }
    }
}

