/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.DependencyData;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.ide.ui.internal.util.JFaceUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class EMFCompareDiffTreeRuler
extends Canvas {
    private static final int Y_OFFSET = 6;
    private static final int ANNOTATION_HEIGHT = 5;
    private final WrappableTreeViewer fTreeViewer;
    private Map<Rectangle, TreeNodeToVisibleTreeItem> annotationsData;
    private PaintListener paintListener;
    private MouseListener mouseClickListener;
    private MouseMoveListener mouseMoveListener;
    private MouseTrackListener mouseTrackListener;
    private Cursor lastCursor;
    private final DependencyData dependencyData;
    private ICompareColor compareColor;

    EMFCompareDiffTreeRuler(Composite parent, int style, WrappableTreeViewer treeViewer, DependencyData dependencyData, ICompareColor compareColor) {
        super(parent, style);
        this.fTreeViewer = treeViewer;
        this.dependencyData = dependencyData;
        this.compareColor = compareColor;
        this.annotationsData = Maps.newHashMap();
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                EMFCompareDiffTreeRuler.this.handlePaintEvent(e);
            }
        };
        this.addPaintListener(this.paintListener);
        this.mouseClickListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                EMFCompareDiffTreeRuler.this.handleMouseClickEvent(e);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.addMouseListener(this.mouseClickListener);
        this.mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                EMFCompareDiffTreeRuler.this.handleMouveMoveEvent(e);
            }
        };
        this.addMouseMoveListener(this.mouseMoveListener);
        this.mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                EMFCompareDiffTreeRuler.this.handleMouseHoverEvent(e);
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
            }
        };
        this.addMouseTrackListener(this.mouseTrackListener);
    }

    public void handleDispose() {
        this.removeMouseTrackListener(this.mouseTrackListener);
        this.removeMouseMoveListener(this.mouseMoveListener);
        this.removeMouseListener(this.mouseClickListener);
        this.removePaintListener(this.paintListener);
    }

    private void handlePaintEvent(PaintEvent e) {
        Collection<TreeNode> treeNodes;
        this.annotationsData.clear();
        for (Diff diff : this.dependencyData.getRequires()) {
            treeNodes = this.dependencyData.getTreeNodes(diff);
            for (TreeNodeToVisibleTreeItem treeNodeToVisibleTreeItem : this.findTreeItems(treeNodes)) {
                if (JFaceUtil.isFiltered((StructuredViewer)this.fTreeViewer, treeNodeToVisibleTreeItem.getTreeNode(), null)) continue;
                this.createAnnotation(e, treeNodeToVisibleTreeItem, this.compareColor.getRequiredFillColor(), this.compareColor.getRequiredStrokeColor());
            }
        }
        for (Diff diff : this.dependencyData.getRejections()) {
            treeNodes = this.dependencyData.getTreeNodes(diff);
            for (TreeNodeToVisibleTreeItem treeNodeToVisibleTreeItem : this.findTreeItems(treeNodes)) {
                if (JFaceUtil.isFiltered((StructuredViewer)this.fTreeViewer, treeNodeToVisibleTreeItem.getTreeNode(), null)) continue;
                this.createAnnotation(e, treeNodeToVisibleTreeItem, this.compareColor.getUnmergeableFillColor(), this.compareColor.getUnmergeableStrokeColor());
            }
        }
    }

    public Collection<TreeNodeToVisibleTreeItem> findTreeItems(Collection<TreeNode> treeNodes) {
        LinkedHashSet<TreeNodeToVisibleTreeItem> result = new LinkedHashSet<TreeNodeToVisibleTreeItem>();
        for (TreeNode node : treeNodes) {
            TreeItem item = this.findFirstAncestorTreeItem(node);
            if (item == null) continue;
            result.add(new TreeNodeToVisibleTreeItem(node, item));
        }
        return result;
    }

    private TreeItem findFirstAncestorTreeItem(TreeNode node) {
        CompareInputAdapter cia = this.findFirstAncestorCompareInputAdapter(node);
        Object item = cia != null ? this.fTreeViewer.testFindItem((Object)cia) : null;
        TreeNode parent = node;
        while (!(item instanceof TreeItem) && (parent = parent.getParent()) != null) {
            cia = this.findFirstAncestorCompareInputAdapter(parent);
            item = cia != null ? this.fTreeViewer.testFindItem((Object)cia) : null;
        }
        if (item instanceof TreeItem) {
            return (TreeItem)item;
        }
        return null;
    }

    private CompareInputAdapter findFirstAncestorCompareInputAdapter(TreeNode node) {
        CompareInputAdapter cia = this.getCompareInputAdapter(node);
        if (cia != null) {
            return cia;
        }
        TreeNode parent = node;
        while (cia == null && (parent = parent.getParent()) != null) {
            cia = this.getCompareInputAdapter(parent);
        }
        return cia;
    }

    private CompareInputAdapter getCompareInputAdapter(TreeNode node) {
        return (CompareInputAdapter)((Object)Iterators.tryFind((Iterator)node.eAdapters().iterator(), (Predicate)Predicates.instanceOf(CompareInputAdapter.class)).orNull());
    }

    private void handleMouseClickEvent(MouseEvent e) {
        for (Map.Entry<Rectangle, TreeNodeToVisibleTreeItem> entry : this.annotationsData.entrySet()) {
            if (e.y < entry.getKey().y || e.y > entry.getKey().y + 5) continue;
            TreeItem targetItem = this.createChildrenDownTo(entry.getValue().getTreeItem(), entry.getValue().getTreeNode());
            TreePath treePath = this.getTreePathFromItem(targetItem);
            this.fTreeViewer.expandToLevel(treePath, 0);
            this.fTreeViewer.reveal(treePath);
            if (this.isVerticalScrollBarEnabled()) {
                TreeItem previousItem = this.getPreviousItem(targetItem, 2);
                this.fTreeViewer.getTree().setTopItem(previousItem);
            }
            this.redraw();
            return;
        }
    }

    private TreeItem createChildrenDownTo(TreeItem from, TreeNode to) {
        TreeItem currentItem = from;
        TreeNode currentNode = this.getTreeNodeFromAdapter(currentItem.getData());
        Iterator<TreeNode> pathToTarget = this.getPath(currentNode, to).iterator();
        block0: while (currentNode != to && pathToTarget.hasNext()) {
            TreeItem[] children = currentItem.getItems();
            if (this.isDummyChild(children)) {
                this.fTreeViewer.createChildren((Widget)currentItem);
                children = currentItem.getItems();
            }
            currentNode = pathToTarget.next();
            TreeItem[] treeItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                TreeNode childNode = this.getTreeNodeFromAdapter(child.getData());
                if (childNode == currentNode) {
                    currentItem = child;
                    continue block0;
                }
                ++n2;
            }
        }
        return currentItem;
    }

    private TreeNode getTreeNodeFromAdapter(Object data) {
        Notifier target;
        if (data instanceof Adapter && (target = ((Adapter)data).getTarget()) instanceof TreeNode) {
            return (TreeNode)target;
        }
        return null;
    }

    private Iterable<TreeNode> getPath(TreeNode from, TreeNode to) {
        if (to == from) {
            return Collections.emptyList();
        }
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        path.add(to);
        TreeNode parent = to.getParent();
        while (parent != null && parent != from) {
            path.add(parent);
            parent = parent.getParent();
        }
        return Lists.reverse(path);
    }

    private boolean isDummyChild(TreeItem[] items) {
        return items.length == 1 && items[0].getData() == null;
    }

    private void handleMouveMoveEvent(MouseEvent e) {
        Cursor cursor = null;
        for (Rectangle rect : this.annotationsData.keySet()) {
            if (e.y < rect.y || e.y > rect.y + 5) continue;
            cursor = e.display.getSystemCursor(21);
            break;
        }
        if (cursor != this.lastCursor) {
            this.setCursor(cursor);
            this.lastCursor = cursor;
        }
    }

    private void handleMouseHoverEvent(MouseEvent e) {
        String overview = "";
        for (Map.Entry<Rectangle, TreeNodeToVisibleTreeItem> entry : this.annotationsData.entrySet()) {
            if (e.y < entry.getKey().y || e.y > entry.getKey().y + 5) continue;
            TreeNode node = entry.getValue().getTreeNode();
            if (!(this.fTreeViewer.getLabelProvider() instanceof DelegatingStyledCellLabelProvider)) break;
            overview = ((DelegatingStyledCellLabelProvider)this.fTreeViewer.getLabelProvider()).getStyledStringProvider().getStyledText((Object)node).toString();
            break;
        }
        this.setToolTipText(overview);
    }

    private void createAnnotation(PaintEvent e, TreeNodeToVisibleTreeItem treeNodeToVisibleTreeItem, Color fill, Color border) {
        TreeItem item = this.getDeepestVisibleTreeItem(treeNodeToVisibleTreeItem.getTreeItem(), treeNodeToVisibleTreeItem.getTreeItem());
        if (item != null) {
            int yMin;
            int yMax;
            int realYMax;
            int y = item.getBounds().y;
            int yRuler = this.getSize().y;
            if (this.isVerticalScrollBarEnabled() && (y = (realYMax = (yMax = this.getLastVisibleItem().getBounds().y) + (yMin = Math.abs(item.getParent().getItems()[0].getBounds().y))) > 0 ? (y + yMin) * yRuler / realYMax : (y + yMin) * yRuler) + 6 + 5 > yRuler) {
                y = yRuler - 6 - 5;
            }
            Rectangle rect = this.drawAnnotation(e.gc, 2, y + 6, this.getBounds().width - 5, 5, fill, border);
            this.annotationsData.put(rect, treeNodeToVisibleTreeItem);
        }
    }

    private TreePath getTreePathFromItem(TreeItem item) {
        LinkedList segments = Lists.newLinkedList();
        TreeItem parent = item;
        while (parent != null) {
            Object segment = parent.getData();
            Assert.isNotNull((Object)segment);
            segments.addFirst(segment);
            parent = parent.getParentItem();
        }
        return new TreePath(segments.toArray());
    }

    private boolean isVerticalScrollBarEnabled() {
        ScrollBar verticalBar = this.fTreeViewer.getTree().getVerticalBar();
        if (verticalBar != null) {
            return verticalBar.isVisible() && verticalBar.isEnabled();
        }
        return false;
    }

    private Rectangle drawAnnotation(GC gc, int x, int y, int w, int h, Color fill, Color border) {
        Rectangle rect = new Rectangle(x, y, w, h);
        gc.setBackground(fill);
        gc.fillRectangle(rect);
        gc.setForeground(border);
        gc.drawRectangle(x, y, w, h);
        return rect;
    }

    private TreeItem getDeepestVisibleTreeItem(TreeItem currentItem, TreeItem deepestVisibleItem) {
        TreeItem item = null;
        if (!currentItem.isDisposed()) {
            TreeItem parent = currentItem.getParentItem();
            item = parent == null ? deepestVisibleItem : (parent.getExpanded() ? this.getDeepestVisibleTreeItem(parent, deepestVisibleItem) : this.getDeepestVisibleTreeItem(parent, parent));
        }
        return item;
    }

    private TreeItem getPreviousItem(TreeItem treeItem, int index) {
        TreeItem previousItem = treeItem;
        if (index > 0) {
            TreeItem parentItem = treeItem.getParentItem();
            if (parentItem != null) {
                int treeItemIndex = 0;
                TreeItem[] treeItemArray = parentItem.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem siblingItem = treeItemArray[n2];
                    if (siblingItem.equals(treeItem)) break;
                    ++treeItemIndex;
                    ++n2;
                }
                if (treeItemIndex == 0) {
                    previousItem = this.getPreviousItem(parentItem, index - 1);
                } else if (treeItemIndex == 1) {
                    TreeItem firstChild = parentItem.getItem(0);
                    previousItem = this.getLastVisibleItem(firstChild);
                    previousItem = this.getPreviousItem(previousItem, index - 1);
                } else {
                    previousItem = this.getPreviousItem(this.getLastVisibleItem(parentItem.getItem(treeItemIndex - 1)), index - 1);
                }
            } else {
                Tree tree = treeItem.getParent();
                int treeItemIndex = 0;
                TreeItem[] treeItemArray = tree.getItems();
                int n = treeItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TreeItem siblingItem = treeItemArray[n3];
                    if (siblingItem.equals(treeItem)) break;
                    ++treeItemIndex;
                    ++n3;
                }
                if (treeItemIndex == 0) {
                    previousItem = treeItem;
                } else if (treeItemIndex == 1) {
                    TreeItem firstRoot = tree.getItem(0);
                    previousItem = firstRoot.getExpanded() ? this.getLastVisibleItem(firstRoot) : firstRoot;
                    previousItem = this.getPreviousItem(previousItem, index - 1);
                } else {
                    previousItem = tree.getItem(treeItemIndex - index);
                }
            }
        }
        return previousItem;
    }

    private TreeItem getLastVisibleItem() {
        int rootChildren = this.fTreeViewer.getTree().getItemCount();
        return this.getLastVisibleItem(this.fTreeViewer.getTree().getItem(rootChildren - 1));
    }

    private TreeItem getLastVisibleItem(TreeItem item) {
        TreeItem lastDirectChildren;
        TreeItem lastVisibleItem = null;
        int directChildren = item.getItemCount();
        lastVisibleItem = directChildren == 0 || !item.getExpanded() ? item : ((lastDirectChildren = item.getItem(directChildren - 1)).getData() == null ? item : (lastDirectChildren.getExpanded() ? this.getLastVisibleItem(lastDirectChildren) : lastDirectChildren));
        return lastVisibleItem;
    }

    static class TreeNodeToVisibleTreeItem {
        private final TreeNode treeNode;
        private final TreeItem treeItem;

        public TreeNodeToVisibleTreeItem(TreeNode treeNode, TreeItem treeItem) {
            this.treeNode = treeNode;
            this.treeItem = treeItem;
        }

        public TreeNode getTreeNode() {
            return this.treeNode;
        }

        public TreeItem getTreeItem() {
            return this.treeItem;
        }
    }
}

