/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpa.convert;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.teneo.ERuntime;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceMappingBuilder;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.extension.DefaultExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.jpa.orm.AccessType;
import org.eclipse.emf.teneo.jpa.orm.AttributeOverride;
import org.eclipse.emf.teneo.jpa.orm.Attributes;
import org.eclipse.emf.teneo.jpa.orm.Basic;
import org.eclipse.emf.teneo.jpa.orm.Column;
import org.eclipse.emf.teneo.jpa.orm.DocumentRoot;
import org.eclipse.emf.teneo.jpa.orm.Embedded;
import org.eclipse.emf.teneo.jpa.orm.EmbeddedId;
import org.eclipse.emf.teneo.jpa.orm.Entity;
import org.eclipse.emf.teneo.jpa.orm.EntityMappingsType;
import org.eclipse.emf.teneo.jpa.orm.Id;
import org.eclipse.emf.teneo.jpa.orm.IdClass;
import org.eclipse.emf.teneo.jpa.orm.ManyToMany;
import org.eclipse.emf.teneo.jpa.orm.ManyToOne;
import org.eclipse.emf.teneo.jpa.orm.MappedSuperclass;
import org.eclipse.emf.teneo.jpa.orm.OneToMany;
import org.eclipse.emf.teneo.jpa.orm.OneToOne;
import org.eclipse.emf.teneo.jpa.orm.OrmFactory;
import org.eclipse.emf.teneo.jpa.orm.PersistenceUnitDefaults;
import org.eclipse.emf.teneo.jpa.orm.PersistenceUnitMetadata;
import org.eclipse.emf.teneo.jpa.orm.Transient;
import org.eclipse.emf.teneo.jpa.orm.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORMGenerator {
    private OrmFactory factory = OrmFactory.eINSTANCE;

    public PersistenceOptions getDefaultPersistenceOptions(Properties props) {
        props.setProperty("teneo.mapping.sql_name_escape_character", "");
        props.setProperty("teneo.mapping.emap_as_true_map", "false");
        props.setProperty("teneo.mapping.set_default_cascade_on_non_containment", "true");
        props.setProperty("teneo.mapping.cascade_policy_on_non_containment", "REFRESH,PERSIST,MERGE");
        props.setProperty("teneo.naming.id_feature_as_primary_key", "false");
        props.setProperty("teneo.naming.strategy", "uppercase");
        DefaultExtensionManager extensionManager = new DefaultExtensionManager();
        return (PersistenceOptions)extensionManager.getExtension(PersistenceOptions.class, new Object[]{props});
    }

    public String generateORM(EPackage[] ePackages) {
        return this.generateORM(ePackages, this.getDefaultPersistenceOptions(new Properties()));
    }

    public String generateORM(EPackage[] ePackages, PersistenceOptions po) {
        DefaultExtensionManager extensionManager = new DefaultExtensionManager();
        PAnnotatedModel paModel = ((PersistenceMappingBuilder)extensionManager.getExtension(PersistenceMappingBuilder.class)).buildMapping(ePackages, po, (ExtensionManager)extensionManager);
        return this.generateORM((List<PAnnotatedEPackage>)paModel.getPaEPackages(), po);
    }

    public String generateORM(List<PAnnotatedEPackage> annotatedEPackages, PersistenceOptions po) {
        XMLResourceImpl res = new XMLResourceImpl();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        options.put("EXTENDED_META_DATA", true);
        options.put("SCHEMA_LOCATION", true);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", true);
        StringWriter sw = new StringWriter();
        DocumentRoot dr = this.factory.createDocumentRoot();
        dr.setEntityMappings(this.convertPAnnotatedEPackages(annotatedEPackages, po));
        dr.getXMLNSPrefixMap().put((Object)"xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance");
        dr.getXSISchemaLocation().put((Object)"http://java.sun.com/xml/ns/persistence/orm", (Object)"http://java.sun.com/xml/ns/persistence/orm_1_0.xsd");
        res.getContents().add((Object)dr);
        try {
            res.save((Writer)sw, options);
            return sw.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public EntityMappingsType convertPAnnotatedEPackages(List<PAnnotatedEPackage> annotatedEPackages, PersistenceOptions po) {
        EntityMappingsType entityMappings = OrmFactory.eINSTANCE.createEntityMappingsType();
        entityMappings.setVersion("1.0");
        entityMappings.setPersistenceUnitMetadata(this.getMetaData());
        for (PAnnotatedEPackage pPackage : annotatedEPackages) {
            this.copyFeatures((EObject)pPackage, entityMappings);
            for (PAnnotatedEClass pClass : pPackage.getPaEClasses()) {
                if (pClass.getEntity() == null) continue;
                this.convertPAnnotatedEClass(entityMappings, pClass);
            }
        }
        this.escape(entityMappings, po.getSqlNameEscapeCharacter());
        return entityMappings;
    }

    private void escape(EntityMappingsType entityMappings, String escapeChar) {
        if (escapeChar == null || escapeChar.trim().length() == 0) {
            return;
        }
        TreeIterator it = entityMappings.eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            for (EStructuralFeature eFeature : eObject.eClass().getEAllAttributes()) {
                String value;
                EAnnotation eAnnotation = eFeature.getEAnnotation("teneo.escape");
                if (eAnnotation == null || (value = (String)eObject.eGet(eFeature)) == null || value.trim().length() <= 0 || value.startsWith(escapeChar) || value.endsWith(escapeChar)) continue;
                eObject.eSet(eFeature, (Object)("'\"" + value + "\"'"));
            }
        }
    }

    private void convertPAnnotatedEClass(EntityMappingsType entityTypes, PAnnotatedEClass pClass) {
        PAnnotatedEReference containmentRef;
        Object mainType;
        EList annotatedEPackages = pClass.getPaModel().getPaEPackages();
        if (pClass.getMappedSuperclass() != null) {
            MappedSuperclass mappedSuperclass = this.factory.createMappedSuperclass();
            entityTypes.getMappedSuperclass().add((Object)mappedSuperclass);
            mainType = mappedSuperclass;
            mappedSuperclass.setClass(ERuntime.INSTANCE.getJavaClass((EClassifier)pClass.getModelEClass()).getName());
        } else {
            Entity entity = this.factory.createEntity();
            entityTypes.getEntity().add((Object)entity);
            mainType = entity;
            entity.setName(pClass.getEntity().getName());
            entity.setClass(ERuntime.INSTANCE.getJavaClass((EClassifier)pClass.getModelEClass()).getName());
        }
        this.copyFeatures((EObject)pClass, (EObject)mainType);
        Attributes attributes = this.factory.createAttributes();
        mainType.eSet(mainType.eClass().getEStructuralFeature("attributes"), attributes);
        if (this.isMapEntry(pClass.getModelEClass())) {
            this.addEMapAnnotations((Entity)mainType, attributes, pClass);
        }
        for (PAnnotatedEStructuralFeature pFeature : pClass.getPaEStructuralFeatures()) {
            this.mapEFeature(pFeature, attributes);
        }
        if (pClass.getPaSuperEntity() == null) {
            Basic basic = this.factory.createBasic();
            basic.setName("eContainerFeatureID");
            Column c = this.factory.createColumn();
            c.setName("ECONT_FEAT_ID");
            basic.setColumn(c);
            attributes.getBasic().add((Object)basic);
        }
        if ((containmentRef = this.getContainmentFeature(pClass, (List<PAnnotatedEPackage>)annotatedEPackages)) != null) {
            if (containmentRef.getModelEReference().isMany()) {
                ManyToOne mto = this.factory.createManyToOne();
                mto.setName("eContainer");
                mto.setTargetEntity(ERuntime.INSTANCE.getJavaClass((EClassifier)containmentRef.getPaEClass().getModelEClass()).getName());
                attributes.getManyToOne().add((Object)mto);
                org.eclipse.emf.teneo.jpa.orm.JoinColumn jc = this.factory.createJoinColumn();
                jc.setName(((JoinColumn)containmentRef.getJoinColumns().get(0)).getName());
                mto.getJoinColumn().add((Object)jc);
                org.eclipse.emf.teneo.jpa.orm.CascadeType ct = this.factory.createCascadeType();
                ct.setCascadeAll(this.factory.createEmptyType());
                mto.setCascade(ct);
            } else {
                OneToOne oto = this.factory.createOneToOne();
                oto.setName("eContainer");
                oto.setTargetEntity(ERuntime.INSTANCE.getJavaClass((EClassifier)containmentRef.getPaEClass().getModelEClass()).getName());
                attributes.getOneToOne().add((Object)oto);
                oto.setMappedBy(containmentRef.getModelEReference().getName());
                org.eclipse.emf.teneo.jpa.orm.CascadeType ct = this.factory.createCascadeType();
                ct.setCascadeAll(this.factory.createEmptyType());
                oto.setCascade(ct);
            }
        }
    }

    private void mapEFeature(PAnnotatedEStructuralFeature pFeature, Attributes attributes) {
        if (this.isMapEntry(pFeature.getPaEClass().getModelEClass()) && pFeature.getModelElement().getName().equals("key")) {
            return;
        }
        if (pFeature instanceof PAnnotatedEAttribute) {
            PAnnotatedEAttribute pAttribute = (PAnnotatedEAttribute)pFeature;
            if (pAttribute.getTransient() != null) {
                Transient t = this.factory.createTransient();
                t.setName(pAttribute.getModelEAttribute().getName());
                attributes.getTransient().add((Object)t);
            } else if (pAttribute.getVersion() != null) {
                Version v = this.factory.createVersion();
                v.setName(pAttribute.getModelEAttribute().getName());
                this.copyFeatures((EObject)pAttribute, v);
                this.copyFeatures((EObject)pAttribute.getVersion(), v);
                attributes.getVersion().add((Object)v);
            } else if (pAttribute.getId() != null) {
                Id id = this.factory.createId();
                id.setName(pAttribute.getModelEAttribute().getName());
                this.copyFeatures((EObject)pAttribute, id);
                this.copyFeatures((EObject)pAttribute.getId(), id);
                attributes.getId().add((Object)id);
            } else if (pAttribute.getBasic() != null) {
                Basic b = this.factory.createBasic();
                b.setName(pAttribute.getModelEAttribute().getName());
                this.copyFeatures((EObject)pAttribute, b);
                this.copyFeatures((EObject)pAttribute.getBasic(), b);
                attributes.getBasic().add((Object)b);
            }
        } else {
            PAnnotatedEReference pReference = (PAnnotatedEReference)pFeature;
            if (!pReference.getModelEReference().isContainer()) {
                if (pReference.getTransient() != null) {
                    Transient t = this.factory.createTransient();
                    t.setName(pReference.getModelEReference().getName());
                    attributes.getTransient().add((Object)t);
                } else if (pReference.getEmbedded() != null) {
                    Embedded embedded = this.factory.createEmbedded();
                    embedded.setName(pReference.getModelEReference().getName());
                    this.copyFeatures((EObject)pReference, embedded);
                    this.copyFeatures((EObject)pReference.getEmbedded(), embedded);
                    attributes.getEmbedded().add((Object)embedded);
                } else if (pReference.getEmbeddedId() != null) {
                    EmbeddedId embeddedId = this.factory.createEmbeddedId();
                    embeddedId.setName(pReference.getModelEReference().getName());
                    this.copyFeatures((EObject)pReference, embeddedId);
                    this.copyFeatures((EObject)pReference.getEmbeddedId(), embeddedId);
                    attributes.setEmbeddedId(embeddedId);
                } else if (pReference.getManyToOne() != null) {
                    if (pReference.getModelEReference().isContainment()) {
                        OneToOne oto = this.factory.createOneToOne();
                        oto.setName(pReference.getModelEReference().getName());
                        this.copyFeatures((EObject)pReference, oto);
                        this.copyFeatures((EObject)pReference.getManyToOne(), oto);
                        attributes.getOneToOne().add((Object)oto);
                        if (oto.getMappedBy() != null) {
                            oto.getJoinColumn().clear();
                        }
                        this.setTargetEntity(oto, pReference);
                    } else {
                        ManyToOne mto = this.factory.createManyToOne();
                        mto.setName(pReference.getModelEReference().getName());
                        this.copyFeatures((EObject)pReference, mto);
                        this.copyFeatures((EObject)pReference.getManyToOne(), mto);
                        attributes.getManyToOne().add((Object)mto);
                        this.setTargetEntity(mto, pReference);
                    }
                } else if (pReference.getManyToMany() != null) {
                    ManyToMany mtm = this.factory.createManyToMany();
                    mtm.setName(pReference.getModelEReference().getName());
                    this.copyFeatures((EObject)pReference, mtm);
                    this.copyFeatures((EObject)pReference.getManyToMany(), mtm);
                    attributes.getManyToMany().add((Object)mtm);
                    this.setTargetEntity(mtm, pReference);
                } else if (pReference.getOneToMany() != null) {
                    OneToMany otm = this.factory.createOneToMany();
                    otm.setName(pReference.getModelEReference().getName());
                    this.copyFeatures((EObject)pReference, otm);
                    this.copyFeatures((EObject)pReference.getOneToMany(), otm);
                    attributes.getOneToMany().add((Object)otm);
                    if (pReference.getModelEReference().isContainment() && pReference.getModelEReference().getEOpposite() == null) {
                        otm.setMappedBy("eContainer");
                    }
                    if (otm.getMappedBy() != null) {
                        otm.getJoinColumn().clear();
                    }
                    this.setTargetEntity(otm, pReference);
                } else if (pReference.getOneToOne() != null) {
                    OneToOne oto = this.factory.createOneToOne();
                    oto.setName(pReference.getModelEReference().getName());
                    this.copyFeatures((EObject)pReference, oto);
                    this.copyFeatures((EObject)pReference.getOneToOne(), oto);
                    attributes.getOneToOne().add((Object)oto);
                    this.setTargetEntity(oto, pReference);
                    if (oto.getMappedBy() != null) {
                        oto.getJoinColumn().clear();
                    }
                }
            }
        }
    }

    private void addEMapAnnotations(Entity entity, Attributes attributes, PAnnotatedEClass aClass) {
        IdClass idClass = this.factory.createIdClass();
        idClass.setClass("org.eclipse.emf.teneo.eclipselink.util.MapEntryId");
        Id id = this.factory.createId();
        id.setName("key");
        Column idColumn = this.factory.createColumn();
        idColumn.setName("e_key");
        id.setColumn(idColumn);
        attributes.getId().add((Object)id);
        Transient t = this.factory.createTransient();
        t.setName("hash");
        attributes.getTransient().add((Object)t);
        if (this.hasSuperTypeWithId(aClass)) {
            PAnnotatedEReference owningReference = this.getContainmentFeature(aClass, (List<PAnnotatedEPackage>)aClass.getPaModel().getPaEPackages());
            if (owningReference == null) {
                System.err.println("EMap " + aClass.getModelEClass().getName() + " has no owning type");
                return;
            }
            AttributeOverride ao = this.factory.createAttributeOverride();
            Column c = this.factory.createColumn();
            c.setName(((JoinColumn)owningReference.getJoinColumns().get(0)).getName());
            c.setUpdatable(false);
            c.setInsertable(false);
            ao.setName("id");
            ao.setColumn(c);
            entity.getAttributeOverride().add((Object)ao);
        } else {
            Id eContainerId = this.factory.createId();
            eContainerId.setName("eContainer");
            attributes.getId().add((Object)eContainerId);
        }
    }

    private boolean isMapEntry(EClass eclass) {
        return eclass != null && eclass.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(eclass.getInstanceClass()) && eclass.getEStructuralFeatures().size() == 2 && eclass.getEStructuralFeature("key") != null && eclass.getEStructuralFeature("value") != null;
    }

    private boolean hasSuperTypeWithId(PAnnotatedEClass aClass) {
        for (PAnnotatedEClass aSuperClass : aClass.getPaMappedSupers()) {
            for (PAnnotatedEStructuralFeature aFeature : aSuperClass.getPaEStructuralFeatures()) {
                PAnnotatedEAttribute aAttribute;
                if (!(aFeature instanceof PAnnotatedEAttribute) || (aAttribute = (PAnnotatedEAttribute)aFeature).getId() == null) continue;
                return true;
            }
            if (!this.hasSuperTypeWithId(aSuperClass)) continue;
            return true;
        }
        return false;
    }

    private void copyFeatures(EObject from, EObject to) {
        for (EStructuralFeature eToFeature : to.eClass().getEAllStructuralFeatures()) {
            EObject localFrom = from;
            String postFix = "";
            if (eToFeature.isMany()) {
                postFix = "s";
            }
            String lookingFor = String.valueOf(eToFeature.getName()) + postFix;
            EStructuralFeature eFromFeature = localFrom.eClass().getEStructuralFeature(lookingFor);
            if (eFromFeature == null) continue;
            if (eFromFeature.getEType().getName().equals("CascadeType")) {
                to.eSet(eToFeature, (Object)this.getCascade((List)from.eGet(eFromFeature)));
                continue;
            }
            if (eFromFeature.isMany() != eToFeature.isMany()) {
                System.err.println("ERROR FEATURES HAVE DIFFERENT MANIES " + eFromFeature.getName());
                continue;
            }
            if (eFromFeature.eClass() != eToFeature.eClass()) {
                localFrom = (EObject)from.eGet(eFromFeature);
                if (localFrom == null) continue;
                eFromFeature = localFrom.eClass().getEStructuralFeature("value");
            }
            if (eFromFeature.isMany()) {
                this.copyList(eFromFeature, (List)from.eGet(eFromFeature), (List)to.eGet(eToFeature), eToFeature);
                continue;
            }
            to.eSet(eToFeature, this.convertValue(eFromFeature, localFrom.eGet(eFromFeature), eToFeature));
        }
    }

    private Object convertValue(EStructuralFeature from, Object value, EStructuralFeature to) {
        if (value == null) {
            return null;
        }
        if (from instanceof EAttribute && ((EAttribute)from).getEAttributeType() instanceof EEnum) {
            EAttribute eAttribute = (EAttribute)to;
            Enumerator eenum = (Enumerator)value;
            EDataType eDataType = eAttribute.getEAttributeType();
            Object newValue = this.factory.createFromString(eDataType, eenum.getName());
            if (newValue == null) {
                System.err.println("EENUM NOT DEFINED " + eenum.getName() + " for datatype " + eDataType.getName());
            }
            return newValue;
        }
        if (from instanceof EReference) {
            EObject eValue = (EObject)value;
            EObject ormObject = this.factory.create(((EReference)to).getEReferenceType());
            this.copyFeatures(eValue, ormObject);
            return ormObject;
        }
        return value;
    }

    private void copyList(EStructuralFeature fromFeature, List<Object> from, List<Object> to, EStructuralFeature toFeature) {
        for (Object o : from) {
            to.add(this.convertValue(fromFeature, o, toFeature));
        }
    }

    private PersistenceUnitMetadata getMetaData() {
        PersistenceUnitMetadata metaData = this.factory.createPersistenceUnitMetadata();
        metaData.setXmlMappingMetadataComplete(this.factory.createEmptyType());
        PersistenceUnitDefaults defaults = this.factory.createPersistenceUnitDefaults();
        defaults.setAccess(AccessType.FIELD);
        metaData.setPersistenceUnitDefaults(defaults);
        return metaData;
    }

    private org.eclipse.emf.teneo.jpa.orm.CascadeType getCascade(List<Object> cascades) {
        org.eclipse.emf.teneo.jpa.orm.CascadeType newCascade = this.factory.createCascadeType();
        for (Object o : cascades) {
            CascadeType cascadeType = (CascadeType)o;
            if (cascadeType == CascadeType.ALL) {
                newCascade.setCascadeAll(this.factory.createEmptyType());
                continue;
            }
            if (cascadeType == CascadeType.MERGE) {
                newCascade.setCascadeMerge(this.factory.createEmptyType());
                continue;
            }
            if (cascadeType == CascadeType.PERSIST) {
                newCascade.setCascadePersist(this.factory.createEmptyType());
                continue;
            }
            if (cascadeType == CascadeType.REFRESH) {
                newCascade.setCascadeRefresh(this.factory.createEmptyType());
                continue;
            }
            if (cascadeType != CascadeType.REMOVE) continue;
            newCascade.setCascadeRemove(this.factory.createEmptyType());
        }
        return newCascade;
    }

    private PAnnotatedEReference getContainmentFeature(PAnnotatedEClass pClass, List<PAnnotatedEPackage> annotatedEPackages) {
        for (PAnnotatedEPackage pPackage : annotatedEPackages) {
            for (PAnnotatedEClass paClass : pPackage.getPaEClasses()) {
                for (PAnnotatedEStructuralFeature pFeature : paClass.getPaEStructuralFeatures()) {
                    if (!(pFeature instanceof PAnnotatedEReference) || !((PAnnotatedEReference)pFeature).getModelEReference().isContainment() || ((PAnnotatedEReference)pFeature).getAReferenceType() != pClass) continue;
                    return (PAnnotatedEReference)pFeature;
                }
            }
        }
        return null;
    }

    private void setTargetEntity(EObject ormType, PAnnotatedEReference pReference) {
        Class clz = ERuntime.INSTANCE.getJavaClass((EClassifier)pReference.getModelEReference().getEReferenceType());
        ormType.eSet(ormType.eClass().getEStructuralFeature("targetEntity"), (Object)clz.getName());
    }
}

