/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.common.ui.wizards;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.teneo.eclipselink.common.ui.Activator;
import org.eclipse.emf.teneo.eclipselink.common.ui.internal.messages.Messages;
import org.eclipse.emf.teneo.eclipselink.common.ui.wizards.pages.AbstractRootObjectAndModelEditorPage;
import org.eclipse.emf.teneo.eclipselink.common.ui.wizards.pages.BasicModelAndDatabaseAccessParametersPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractLoadModelFromDatabaseWizard
extends Wizard {
    protected BasicModelAndDatabaseAccessParametersPage modelAndDatabaseAccessParametersPage;
    protected AbstractRootObjectAndModelEditorPage rootObjectAndModelEditorPage;

    public AbstractLoadModelFromDatabaseWizard() {
        this.setWindowTitle(Messages.wizard_loadEMFModelFromDatabase_title);
    }

    public void addPages() {
        this.modelAndDatabaseAccessParametersPage = this.createModelAndDatabaseAccessParametersPage("Page1");
        this.modelAndDatabaseAccessParametersPage.setTitle(Messages.page_emfModelAndDatabase_title);
        this.modelAndDatabaseAccessParametersPage.setDescription(Messages.page_emfModelAndDatabase_description);
        this.addPage((IWizardPage)this.modelAndDatabaseAccessParametersPage);
        this.rootObjectAndModelEditorPage = this.createRootObjectAndModelEditorPage("Page2");
        this.rootObjectAndModelEditorPage.setTitle(Messages.page_rootObjectAndEMFModelEditor_title);
        this.rootObjectAndModelEditorPage.setDescription(Messages.page_rootObjectAndEMFModelEditor_description);
        this.addPage((IWizardPage)this.rootObjectAndModelEditorPage);
    }

    public boolean performFinish() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue("USE_LOGIN_FROM", this.modelAndDatabaseAccessParametersPage.getUseLoginFrom());
        if ("from_user_preferences".equals(this.modelAndDatabaseAccessParametersPage.getUseLoginFrom())) {
            store.setValue("DATABASE_URL", this.modelAndDatabaseAccessParametersPage.getDatabaseURL());
            store.setValue("JDBC_DRIVER", this.modelAndDatabaseAccessParametersPage.getJDBCDriver());
            store.setValue("USER_NAME", this.modelAndDatabaseAccessParametersPage.getUserName());
            store.setValue("PASSWORD", this.modelAndDatabaseAccessParametersPage.getPassword());
        }
        URI uri = this.createDatabaseURI(this.modelAndDatabaseAccessParametersPage.getPersistenceUnitName(), this.rootObjectAndModelEditorPage.getRootObject());
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            page.openEditor((IEditorInput)new URIEditorInput(uri), this.rootObjectAndModelEditorPage.getEditorId());
        }
        catch (PartInitException piex) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)this.getWindowTitle(), (String)piex.getMessage());
            return false;
        }
        return true;
    }

    protected abstract BasicModelAndDatabaseAccessParametersPage createModelAndDatabaseAccessParametersPage(String var1);

    protected abstract AbstractRootObjectAndModelEditorPage createRootObjectAndModelEditorPage(String var1);

    protected abstract URI createDatabaseURI(String var1, EObject var2);
}

