/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.resource;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EclipseLinkURIUtil {
    public static final String URI_SCHEME_ECLIPSELINK = "eclipselink";

    public static URI createEclipseLinkURI(String persistenceUnitName, String contentsQueryAlias) {
        Assert.isLegal((persistenceUnitName != null && persistenceUnitName.trim().length() > 0 ? 1 : 0) != 0);
        Assert.isLegal((contentsQueryAlias != null && contentsQueryAlias.trim().length() > 0 ? 1 : 0) != 0);
        String result = "eclipselink:///" + persistenceUnitName + "?" + contentsQueryAlias;
        return URI.createURI((String)result);
    }

    public static boolean isEclipseLinkURI(URI uri) {
        Assert.isNotNull((Object)uri);
        return URI_SCHEME_ECLIPSELINK.equals(uri.scheme());
    }

    public static String createContentsInstancesOfQuery(EClass contentsType) {
        Assert.isNotNull((Object)contentsType);
        return "select o from " + contentsType.getName() + " o";
    }

    public static String createContentsEqualQuery(EClass contentsType, EStructuralFeature feature, Object value) {
        Assert.isNotNull((Object)contentsType);
        Assert.isNotNull((Object)feature);
        Assert.isNotNull((Object)value);
        return "select o from " + contentsType.getName() + " o where o." + feature.getName() + " = '" + value + "'";
    }

    public static String createContentsExampleQuery(EObject contentsExample) {
        Assert.isNotNull((Object)contentsExample);
        EAttribute idAttribute = contentsExample.eClass().getEIDAttribute();
        if (idAttribute != null) {
            return EclipseLinkURIUtil.createContentsEqualQuery(contentsExample.eClass(), (EStructuralFeature)idAttribute, contentsExample.eGet((EStructuralFeature)idAttribute));
        }
        return "";
    }
}

