/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.simpletypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SimpleEnum implements Enumerator
{
    ENUM1_LITERAL(0, "Enum1", "Enum1"),
    ENUM2_LITERAL(1, "Enum2", "Enum2");

    public static final int ENUM1 = 0;
    public static final int ENUM2 = 1;
    private static final SimpleEnum[] VALUES_ARRAY;
    public static final List<SimpleEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SimpleEnum[]{ENUM1_LITERAL, ENUM2_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SimpleEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SimpleEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SimpleEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SimpleEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SimpleEnum get(int value) {
        switch (value) {
            case 0: {
                return ENUM1_LITERAL;
            }
            case 1: {
                return ENUM2_LITERAL;
            }
        }
        return null;
    }

    private SimpleEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

