/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.CompositeEMFOperation;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.ExternalDataCommand;
import org.eclipse.emf.workspace.tests.fixtures.ItemDefaultPublicationDateTrigger;
import org.eclipse.emf.workspace.tests.fixtures.LibraryDefaultBookTrigger;
import org.eclipse.emf.workspace.tests.fixtures.LibraryDefaultNameTrigger;
import org.eclipse.emf.workspace.tests.fixtures.TestListener;
import org.eclipse.emf.workspace.tests.fixtures.TestOperation;
import org.eclipse.emf.workspace.tests.fixtures.TestUndoContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractEMFOperationTest
extends AbstractTest {
    public AbstractEMFOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AbstractEMFOperationTest.class, "EMF Operation Tests");
    }

    public void test_execute_undo_redo() {
        UndoRedoResourceSetListener listener = new UndoRedoResourceSetListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        AbstractEMFOperationTest.assertEquals((int)0, (int)listener.undoCount);
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        AbstractEMFOperationTest.assertNotNull((Object)book);
        String oldTitle = book.getTitle();
        Writer oldAuthor = book.getAuthor();
        final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        AbstractEMFOperationTest.assertNotNull((Object)newAuthor);
        this.commit();
        TestUndoContext ctx = new TestUndoContext();
        TestOperation oper = new TestOperation(this.domain){

            protected void doExecute() {
                book.setTitle("New Title");
                newAuthor.getBooks().add((Object)book);
            }
        };
        try {
            oper.addContext(ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        AbstractEMFOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        AbstractEMFOperationTest.assertEquals((int)1, (int)listener.undoCount);
        this.startReading();
        AbstractEMFOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        AbstractEMFOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        AbstractEMFOperationTest.assertEquals((int)2, (int)listener.undoCount);
        this.startReading();
        AbstractEMFOperationTest.assertSame((Object)"New Title", (Object)book.getTitle());
        AbstractEMFOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_triggerCommands_nonEMF() {
        final String[] externalData = new String[]{"..."};
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (notification.getFeature() == EXTLibraryPackage.Literals.LIBRARY__NAME) {
                    return new ExternalDataCommand(externalData, notification.getNewStringValue());
                }
                return null;
            }
        });
        final Library[] newLibrary = new Library[1];
        TestUndoContext ctx = new TestUndoContext();
        TestOperation oper = new TestOperation(this.domain){

            protected void doExecute() {
                newLibrary[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                AbstractEMFOperationTest.this.root.getBranches().add((Object)newLibrary[0]);
                AbstractEMFOperationTest.assertNull((Object)newLibrary[0].getName());
                AbstractEMFOperationTest.assertTrue((boolean)newLibrary[0].getBranches().isEmpty());
                newLibrary[0].setName("New Library");
            }
        };
        try {
            oper.addContext(ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        AbstractEMFOperationTest.assertEquals((String)"New Library", (String)externalData[0]);
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        AbstractEMFOperationTest.assertEquals((String)"...", (String)externalData[0]);
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        AbstractEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        AbstractEMFOperationTest.assertEquals((String)"New Library", (String)externalData[0]);
        this.commit();
    }

    public void test_triggerCommands() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultNameTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        final Library[] newLibrary = new Library[1];
        TestUndoContext ctx = new TestUndoContext();
        TestOperation oper = new TestOperation(this.domain){

            protected void doExecute() {
                newLibrary[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                AbstractEMFOperationTest.this.root.getBranches().add((Object)newLibrary[0]);
                AbstractEMFOperationTest.assertNull((Object)newLibrary[0].getName());
                AbstractEMFOperationTest.assertTrue((boolean)newLibrary[0].getBranches().isEmpty());
            }
        };
        try {
            oper.addContext(ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        AbstractEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        AbstractEMFOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary[0].getBooks().get(0)).getTitle());
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        AbstractEMFOperationTest.assertEquals((String)"New Library", (String)newLibrary[0].getName());
        AbstractEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        AbstractEMFOperationTest.assertEquals((String)"New Book", (String)((Book)newLibrary[0].getBooks().get(0)).getTitle());
        this.commit();
    }

    public void test_triggerCommands_cascading() {
        this.domain.addResourceSetListener((ResourceSetListener)new LibraryDefaultBookTrigger());
        this.domain.addResourceSetListener((ResourceSetListener)new ItemDefaultPublicationDateTrigger());
        final Library[] newLibrary = new Library[1];
        TestUndoContext ctx = new TestUndoContext();
        TestOperation oper = new TestOperation(this.domain){

            protected void doExecute() {
                newLibrary[0] = EXTLibraryFactory.eINSTANCE.createLibrary();
                AbstractEMFOperationTest.this.root.getBranches().add((Object)newLibrary[0]);
                AbstractEMFOperationTest.assertNull((Object)newLibrary[0].getName());
                AbstractEMFOperationTest.assertTrue((boolean)newLibrary[0].getBranches().isEmpty());
            }
        };
        try {
            oper.addContext(ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        Book book = (Book)newLibrary[0].getBooks().get(0);
        AbstractEMFOperationTest.assertEquals((String)"New Book", (String)book.getTitle());
        AbstractEMFOperationTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertFalse((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        this.commit();
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        this.startReading();
        AbstractEMFOperationTest.assertTrue((boolean)this.root.getBranches().contains((Object)newLibrary[0]));
        AbstractEMFOperationTest.assertEquals((int)1, (int)newLibrary[0].getBooks().size());
        book = (Book)newLibrary[0].getBooks().get(0);
        AbstractEMFOperationTest.assertEquals((String)"New Book", (String)book.getTitle());
        AbstractEMFOperationTest.assertNotNull((Object)book.getPublicationDate());
        this.commit();
    }

    public void test_validation() {
        IStatus status;
        Writer oldAuthor;
        String oldTitle;
        Book book;
        block5: {
            this.startReading();
            book = (Book)this.find("root/Root Book");
            AbstractEMFOperationTest.assertNotNull((Object)book);
            oldTitle = book.getTitle();
            oldAuthor = book.getAuthor();
            final String newTitle = null;
            final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            AbstractEMFOperationTest.assertNotNull((Object)newAuthor);
            this.commit();
            TestUndoContext ctx = new TestUndoContext();
            TestOperation oper = new TestOperation(this.domain){

                protected void doExecute() {
                    book.setTitle(newTitle);
                    newAuthor.getBooks().add((Object)book);
                }
            };
            status = null;
            try {
                try {
                    validationEnabled = true;
                    oper.addContext(ctx);
                    status = this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    this.fail((Exception)((Object)e));
                    validationEnabled = false;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                validationEnabled = false;
                throw throwable;
            }
            validationEnabled = false;
        }
        AbstractEMFOperationTest.assertNotNull(status);
        AbstractEMFOperationTest.assertTrue((boolean)status.matches(4));
        status = this.findValidationStatus(status, 4);
        AbstractEMFOperationTest.assertNotNull((Object)status);
        this.startReading();
        AbstractEMFOperationTest.assertSame((Object)oldTitle, (Object)book.getTitle());
        AbstractEMFOperationTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
        this.commit();
    }

    public void test_options_124741() {
        IStatus status;
        TestListener listener;
        Writer newAuthor;
        String newTitle;
        Book book;
        block5: {
            this.startReading();
            book = (Book)this.find("root/Root Book");
            AbstractEMFOperationTest.assertNotNull((Object)book);
            newTitle = null;
            newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            AbstractEMFOperationTest.assertNotNull((Object)newAuthor);
            this.commit();
            listener = new TestListener();
            this.domain.addResourceSetListener((ResourceSetListener)listener);
            TestUndoContext ctx = new TestUndoContext();
            TestOperation oper = new TestOperation(this.domain, this.makeOptions("silent", true, "no_triggers", true, "no_validation", true)){

                protected void doExecute() {
                    book.setTitle(newTitle);
                    newAuthor.getBooks().add((Object)book);
                }
            };
            status = null;
            try {
                try {
                    validationEnabled = true;
                    oper.addContext(ctx);
                    status = this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    this.fail((Exception)((Object)e));
                    validationEnabled = false;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                validationEnabled = false;
                throw throwable;
            }
            validationEnabled = false;
        }
        this.startReading();
        AbstractEMFOperationTest.assertSame(newTitle, (Object)book.getTitle());
        AbstractEMFOperationTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
        this.commit();
        AbstractEMFOperationTest.assertNotNull((Object)status);
        AbstractEMFOperationTest.assertTrue((boolean)status.isOK());
        AbstractEMFOperationTest.assertNull((Object)listener.precommit);
        AbstractEMFOperationTest.assertNull((Object)listener.postcommit);
    }

    public void test_rollbackNestingTransactionOnException_135673() {
        CompositeEMFOperation outer = new CompositeEMFOperation(this.domain, "");
        AbstractEMFOperation inner = new AbstractEMFOperation(this.domain, ""){

            public boolean canExecute() {
                return true;
            }

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    ((InternalTransactionalEditingDomain)AbstractEMFOperationTest.this.domain).startTransaction(false, null);
                    ((InternalTransactionalEditingDomain)AbstractEMFOperationTest.this.domain).startTransaction(false, null);
                }
                catch (Exception e) {
                    AbstractEMFOperationTest.fail((String)("Failed to start nested transaction: " + e.getLocalizedMessage()));
                }
                throw new TestError("intentional error");
            }
        };
        outer.add((IUndoableOperation)inner);
        try {
            outer.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            AbstractEMFOperationTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        catch (TestError testError) {
        }
        catch (IllegalArgumentException e) {
            AbstractEMFOperationTest.fail((String)("Rolled back out of order: " + e.getLocalizedMessage()));
        }
    }

    public void test_undoRedoNonEMFOperationWithEMFChanges_155268() {
        final CompositeEMFOperation comp = new CompositeEMFOperation(this.domain, "");
        final Book book = (Book)this.find("root/Root Book");
        AbstractEMFOperationTest.assertNotNull((Object)book);
        AbstractEMFOperation emfOperation = new AbstractEMFOperation(this.domain, ""){

            public boolean canExecute() {
                return true;
            }

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                book.setTitle("155268");
                return Status.OK_STATUS;
            }
        };
        IUndoableOperation nonEMFOperation = new IUndoableOperation(emfOperation){
            private IUndoableOperation wrappedOperation;
            {
                this.wrappedOperation = abstractEMFOperation;
            }

            public void addContext(IUndoContext context) {
                this.wrappedOperation.addContext(context);
            }

            public boolean canExecute() {
                return this.wrappedOperation.canExecute();
            }

            public boolean canRedo() {
                return this.wrappedOperation.canRedo();
            }

            public boolean canUndo() {
                return this.wrappedOperation.canUndo();
            }

            public void dispose() {
                this.wrappedOperation.dispose();
            }

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return this.wrappedOperation.execute(monitor, info);
            }

            public IUndoContext[] getContexts() {
                return this.wrappedOperation.getContexts();
            }

            public String getLabel() {
                return this.wrappedOperation.getLabel();
            }

            public boolean hasContext(IUndoContext context) {
                return this.wrappedOperation.hasContext(context);
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return this.wrappedOperation.redo(monitor, info);
            }

            public void removeContext(IUndoContext context) {
                this.wrappedOperation.removeContext(context);
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return this.wrappedOperation.undo(monitor, info);
            }
        };
        AbstractEMFOperation root = new AbstractEMFOperation(this.domain, ""){

            public boolean canExecute() {
                return true;
            }

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                comp.execute(monitor, info);
                return Status.OK_STATUS;
            }
        };
        comp.add(nonEMFOperation);
        try {
            root.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            AbstractEMFOperationTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        catch (TestError testError) {
        }
        catch (IllegalArgumentException e) {
            AbstractEMFOperationTest.fail((String)("Rolled back out of order: " + e.getLocalizedMessage()));
        }
        AbstractEMFOperationTest.assertEquals((String)book.getTitle(), (String)"155268");
        try {
            root.undo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            AbstractEMFOperationTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        catch (TestError testError) {
        }
        catch (IllegalArgumentException e) {
            AbstractEMFOperationTest.fail((String)("Rolled back out of order: " + e.getLocalizedMessage()));
        }
        AbstractEMFOperationTest.assertFalse((boolean)"155268".equals(book.getTitle()));
        try {
            root.redo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            AbstractEMFOperationTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
        catch (TestError testError) {
        }
        catch (IllegalArgumentException e) {
            AbstractEMFOperationTest.fail((String)("Rolled back out of order: " + e.getLocalizedMessage()));
        }
        AbstractEMFOperationTest.assertEquals((String)book.getTitle(), (String)"155268");
    }

    public void test_nullProgressMonitors_bug150033() {
        AbstractEMFOperation operation = new AbstractEMFOperation(this.domain, "Test"){

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                monitor.isCanceled();
                return super.doUndo(monitor, info);
            }

            protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                monitor.isCanceled();
                return super.doRedo(monitor, info);
            }

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                monitor.isCanceled();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute(null, null);
        }
        catch (Exception e) {
            AbstractEMFOperationTest.fail((String)("Should not have failed to execute with null monitor: " + e.getLocalizedMessage()));
        }
        try {
            operation.undo(null, null);
        }
        catch (Exception e) {
            AbstractEMFOperationTest.fail((String)("Should not have failed to undo with null monitor: " + e.getLocalizedMessage()));
        }
        try {
            operation.redo(null, null);
        }
        catch (Exception e) {
            AbstractEMFOperationTest.fail((String)("Should not have failed to redo with null monitor: " + e.getLocalizedMessage()));
        }
    }

    public void test_undoWithRecordingCommandTrigger_218276() {
        final Book[] book = new Book[]{(Book)this.find("root/Root Book")};
        final RecordingCommand trigger = new RecordingCommand(this.domain, "Test Trigger"){

            protected void doExecute() {
                book[0].setCopies(30);
            }
        };
        ResourceSetListenerImpl listener = new ResourceSetListenerImpl(){

            public boolean isPrecommitOnly() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                CompoundCommand result = new CompoundCommand();
                for (Notification next : event.getNotifications()) {
                    if (next.getFeature() != EXTLibraryPackage.Literals.BOOK__TITLE) continue;
                    return trigger;
                }
                return result;
            }
        };
        try {
            try {
                this.domain.addResourceSetListener((ResourceSetListener)listener);
                TestOperation op = new TestOperation(this.domain){

                    protected void doExecute() throws ExecutionException {
                        book[0].setTitle("New Title");
                    }
                };
                op.execute(null, null);
                AbstractEMFOperationTest.assertEquals((String)"Wrong number of copies on execute", (int)30, (int)book[0].getCopies());
                op.undo(null, null);
                AbstractEMFOperationTest.assertFalse((String)"Wrong number of copies on undo", (book[0].getCopies() == 30 ? 1 : 0) != 0);
                op.redo(null, null);
                AbstractEMFOperationTest.assertEquals((String)"Wrong number of copies on redo", (int)30, (int)book[0].getCopies());
            }
            catch (ExecutionException e) {
                this.fail((Exception)((Object)e));
                this.domain.removeResourceSetListener((ResourceSetListener)listener);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)listener);
        }
    }

    public void test_setOptions_245419() {
        this.startReading();
        final Book book = (Book)this.find("root/Root Book");
        AbstractEMFOperationTest.assertNotNull((Object)book);
        final Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
        AbstractEMFOperationTest.assertNotNull((Object)newAuthor);
        this.commit();
        HashMap<String, Constable> options = new HashMap<String, Constable>();
        options.put("one", Integer.valueOf(1));
        options.put("two", Integer.valueOf(2));
        TestUndoContext ctx = new TestUndoContext();
        TestOperation oper = new TestOperation(this.domain, options){

            protected void doExecute() {
                book.setTitle("New Title");
                newAuthor.getBooks().add((Object)book);
            }
        };
        this.assertSubset(options, oper.getOptions());
        options.clear();
        options.put("first", Boolean.valueOf(true));
        options.put("second", Boolean.valueOf(false));
        this.assertNotSubset(options, oper.getOptions());
        AbstractEMFOperationTest.assertTrue((boolean)oper.canSetOptions());
        oper.setOptions(options);
        this.assertSubset(options, oper.getOptions());
        try {
            oper.addContext(ctx);
            this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        AbstractEMFOperationTest.assertFalse((boolean)oper.canSetOptions());
        try {
            oper.setOptions(options);
            AbstractEMFOperationTest.fail((String)"Should not have been able to set options");
        }
        catch (IllegalStateException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        AbstractEMFOperationTest.assertFalse((boolean)oper.canSetOptions());
        try {
            oper.setOptions(options);
            AbstractEMFOperationTest.fail((String)"Should not have been able to set options");
        }
        catch (IllegalStateException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        try {
            AbstractEMFOperationTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            this.fail((Exception)((Object)e));
        }
        AbstractEMFOperationTest.assertFalse((boolean)oper.canSetOptions());
        try {
            oper.setOptions(options);
            AbstractEMFOperationTest.fail((String)"Should not have been able to set options");
        }
        catch (IllegalStateException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_executeInActiveTransaction_245393() {
        AbstractEMFOperation operation = new AbstractEMFOperation(this.domain, "Test_executeInActiveTransaction"){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                InternalTransaction outer = ((InternalTransactionalEditingDomain)this.getEditingDomain()).getActiveTransaction();
                AbstractEMFOperation delegate = new AbstractEMFOperation(AbstractEMFOperationTest.this.domain, "Test_executeInActiveTransaction_delegate", (Transaction)outer){
                    private final /* synthetic */ Transaction val$outer;
                    {
                        this.val$outer = transaction;
                        super($anonymous0, $anonymous1);
                    }

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        AbstractEMFOperationTest.assertSame((String)"Transaction not reused by inner operation", (Object)this.val$outer, (Object)((InternalTransactionalEditingDomain)this.getEditingDomain()).getActiveTransaction());
                        return Status.OK_STATUS;
                    }
                };
                delegate.setReuseParentTransaction(true);
                return delegate.execute(monitor, info);
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            AbstractEMFOperationTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_rollbackOnError_250253() {
        RollbackListener l = new RollbackListener();
        l.install(this.domain);
        try {
            try {
                new AbstractEMFOperation(this.domain, "Test error result"){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        return new Status(4, "org.eclipse.emf.transaction.tests", "I want to fail");
                    }
                }.execute(null, null);
                l.assertRolledBack();
            }
            catch (ExecutionException e) {
                AbstractEMFOperationTest.fail((String)("Shouldn't have an execution exception from a normal error return." + e.getLocalizedMessage()));
                l.uninstall(this.domain);
            }
        }
        finally {
            l.uninstall(this.domain);
        }
    }

    public void test_inheritValidateEditOption_247691() {
        final CompositeEMFOperation outer = new CompositeEMFOperation(this.domain, "outer", Collections.singletonMap("validate_edit", Boolean.TRUE));
        outer.setTransactionNestingEnabled(false);
        AbstractEMFOperation inner = new AbstractEMFOperation(this.domain, "inner"){

            public boolean canExecute() {
                return true;
            }

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Method getTransactionMethod = null;
                try {
                    getTransactionMethod = AbstractEMFOperation.class.getDeclaredMethod("getTransaction", new Class[0]);
                    getTransactionMethod.setAccessible(true);
                    Object outerTransaction = getTransactionMethod.invoke((Object)outer, new Object[0]);
                    Object innerTransaction = getTransactionMethod.invoke((Object)this, new Object[0]);
                    AbstractEMFOperationTest.assertTrue((String)"Should have reused the parent transaction", (innerTransaction == null || innerTransaction == outerTransaction ? 1 : 0) != 0);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (getTransactionMethod != null) {
                        getTransactionMethod.setAccessible(false);
                    }
                }
            }
        };
        outer.add((IUndoableOperation)inner);
        try {
            outer.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            AbstractEMFOperationTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
        }
    }

    void assertSubset(Map<?, ?> expected, Map<?, ?> actual) {
        for (Map.Entry<?, ?> next : expected.entrySet()) {
            AbstractEMFOperationTest.assertEquals((String)"map is not a subset", next.getValue(), actual.get(next.getKey()));
        }
    }

    void assertNotSubset(Map<?, ?> notExpected, Map<?, ?> actual) {
        boolean subset = true;
        for (Map.Entry<?, ?> next : notExpected.entrySet()) {
            Object value = actual.get(next.getKey());
            if (value == null) {
                if (next.getValue() == null) continue;
                subset = false;
                break;
            }
            if (value.equals(next.getValue())) continue;
            subset = false;
            break;
        }
        AbstractEMFOperationTest.assertFalse((String)"map is a subset", (boolean)subset);
    }

    public static class RollbackListener
    extends TransactionalEditingDomainListenerImpl {
        private int rollbackCount = 0;

        public void install(TransactionalEditingDomain domain) {
            ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)domain, TransactionalEditingDomain.Lifecycle.class)).addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }

        public void uninstall(TransactionalEditingDomain domain) {
            ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)domain, TransactionalEditingDomain.Lifecycle.class)).removeTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }

        public void reset() {
            this.rollbackCount = 0;
        }

        public void transactionClosed(TransactionalEditingDomainEvent event) {
            if (event.getTransaction().getStatus().getSeverity() >= 4) {
                ++this.rollbackCount;
            }
        }

        public void assertRolledBack() {
            AbstractEMFOperationTest.assertEquals((String)"No rollback occurred", (int)1, (int)this.rollbackCount);
        }

        public void assertRollbacks(int expected) {
            AbstractEMFOperationTest.assertEquals((String)"Wrong number of rollbacks", (int)expected, (int)this.rollbackCount);
        }

        public void assertNoRollbacks() {
            AbstractEMFOperationTest.assertEquals((String)"Should not have any rollbacks", (int)0, (int)this.rollbackCount);
        }
    }

    static class TestError
    extends Error {
        private static final long serialVersionUID = 1502966836790504386L;

        TestError(String msg) {
            super(msg);
        }
    }

    public class UndoRedoResourceSetListener
    implements ResourceSetListener {
        public int undoCount = 0;

        public NotificationFilter getFilter() {
            return null;
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }

        public boolean isPostcommitOnly() {
            return false;
        }

        public boolean isPrecommitOnly() {
            return false;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            Transaction transaction = event.getTransaction();
            Object obj = transaction.getOptions().get("is_undo_redo_transaction");
            if (Boolean.TRUE.equals(obj)) {
                ++this.undoCount;
            }
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            return null;
        }
    }
}

