/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.matching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.internal.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.internal.matching.DomainChange;
import org.eclipse.emf.henshin.internal.matching.DomainSlot;
import org.eclipse.emf.henshin.internal.matching.Variable;

public class ReferenceConstraint
implements BinaryConstraint {
    private EReference reference;
    private Variable target;

    public ReferenceConstraint(Variable target, EReference eReference) {
        this.target = target;
        this.reference = eReference;
    }

    @Override
    public boolean check(DomainSlot source, DomainSlot target) {
        List referedObjects;
        if (!source.locked || source.value.eGet((EStructuralFeature)this.reference) == null) {
            return false;
        }
        if (this.reference.isMany()) {
            referedObjects = (List)source.value.eGet((EStructuralFeature)this.reference);
        } else {
            referedObjects = new ArrayList<EObject>();
            referedObjects.add((EObject)source.value.eGet((EStructuralFeature)this.reference));
        }
        if (referedObjects.isEmpty()) {
            return false;
        }
        if (target.locked) {
            return referedObjects.contains(target.value);
        }
        DomainChange change = new DomainChange(target, target.temporaryDomain);
        source.remoteChangeMap.put(this, change);
        target.temporaryDomain = new ArrayList<EObject>(referedObjects);
        if (change.originalValues != null) {
            target.temporaryDomain.retainAll(change.originalValues);
        }
        return !target.temporaryDomain.isEmpty();
    }

    public Variable getTarget() {
        return this.target;
    }
}

