/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.Arrays;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.Storage;

public class StorageImpl
extends MinimalEObjectImpl.Container
implements Storage {
    public static int[] EMPTY_DATA = new int[0];
    protected static final int[] DATA_EDEFAULT = null;
    protected int[] data = DATA_EDEFAULT;

    @Override
    public int[] getData() {
        return this.data != null ? this.data : EMPTY_DATA;
    }

    @Override
    public int getData(int index) {
        return this.data == null || this.data.length <= index ? 0 : this.data[index];
    }

    @Override
    public int[] getData(int beginIndex, int endIndex) {
        int[] result = new int[endIndex - beginIndex];
        if (this.data != null) {
            int end = Math.min(endIndex, this.data.length);
            int i = beginIndex;
            while (i < end) {
                result[i - beginIndex] = this.data[i];
                ++i;
            }
        }
        return result;
    }

    @Override
    public void setData(int index, int value) {
        int size = this.minSize(this.data);
        if (value != 0 && index >= size) {
            size = index + 1;
        }
        if (size == 0) {
            this.setData(null);
        } else {
            int[] newData = this.resized(this.data, size);
            if (index < size) {
                newData[index] = value;
            }
            this.setData(newData);
        }
    }

    @Override
    public void setData(int beginIndex, int endIndex, int[] value) {
        value = this.resized(value, endIndex - beginIndex);
        this.setData(beginIndex, value);
    }

    @Override
    public void setData(int beginIndex, int[] value) {
        int valueSize;
        int size;
        if (value == null) {
            value = EMPTY_DATA;
        }
        if ((size = Math.max(beginIndex + (valueSize = this.minSize(value)), this.minSize(this.data))) == 0) {
            this.setData(null);
        } else {
            int[] newData = this.resized(this.data, size);
            int i = 0;
            while (i < valueSize) {
                newData[beginIndex + i] = value[i];
                ++i;
            }
            this.setData(newData);
        }
    }

    private int[] resized(int[] array, int size) {
        if (array == null) {
            return new int[size];
        }
        return Arrays.copyOf(array, size);
    }

    private int minSize(int[] data) {
        if (data == null) {
            return 0;
        }
        int i = data.length - 1;
        while (i >= 0) {
            if (data[i] != 0) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    protected StorageImpl() {
    }

    protected EClass eStaticClass() {
        return StateSpacePackage.Literals.STORAGE;
    }

    @Override
    public void setData(int[] newData) {
        int[] oldData = this.data;
        this.data = newData;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldData, (Object)this.data));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getData();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setData((int[])newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setData(DATA_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DATA_EDEFAULT == null ? this.data != null : !DATA_EDEFAULT.equals(this.data);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (data: ");
        result.append(this.data);
        result.append(')');
        return result.toString();
    }
}

